<?php ($business_name =    \App\CentralLogics\Helpers::get_business_settings('business_name')); ?>
<?php $__env->startSection('title', translate('messages.landing_page') . ' | ' . $business_name != 'null' ? $business_name : 'Sixam Mart'); ?>
<?php $__env->startSection('content'); ?>

    <!-- Basic Settings -->
    <!-- ==== Banner Section Starts Here ==== -->
    <section class="banner-section position-relative">
        <div class="container">
            <div class="banner-content wow fadeInUp">
                <h1 class="title"><?php echo e($landing_data['fixed_header_title']); ?></h1>
                <img class="w-100 onerror-image" data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>"
                    src="<?php echo e(\App\CentralLogics\Helpers::logoFullUrl()); ?>"
                    alt="">
                <div class="text">
                    <?php echo e($landing_data['fixed_header_sub_title']); ?>

                </div>
            </div>
        </div>
        <div class="px-xl-5 d-flex justify-content-center text-base banner-svg-img">
            <img src="<?php echo e(asset('public/assets/landing/img/main-banner.svg')); ?>" class="svg" alt="">
        </div>
    </section>
    <!-- ==== Banner Section Ends Here ==== -->

    <!-- ==== Ecommerce Venture Section Starts Here ==== -->
    <section class="ecommerce-venture-section">
        <div class="container max-w1060">
            <div class="section-header mb-30 wow fadeInUp">
                <h2 class="title"><?php echo e($landing_data['fixed_module_title']); ?>


                </h2>
                <p>
                    <?php echo e($landing_data['fixed_module_sub_title']); ?>

                </p>
            </div>
            <div class="nav--tabs-wrapper">
                <?php ($modules = \App\Models\Module::Active()->get()); ?>
                <div class="nav--tabs">
                    <div class="owl-theme owl-carousel" id="sync2">
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="item">
                                <img class="__img-50 onerror-image"
                                    data-onerror-image="<?php echo e(asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    src="<?php echo e($item['icon_full_url'] ?? asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    alt="image">
                                <div class="txt d-block"><?php echo e(translate("messages.{$item->module_name}")); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="owl-theme owl-carousel" id="sync1">
                <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row flex-wrap-reverse justify-content-center align-items-center">
                        <div class="col-lg-6 col-md-8">
                            <div class="venture-content mt-4 mt-lg-0">
                                <div class="venture-content-box">
                                    <?php echo $item->description ?? ''; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-8">
                            <div class="venture-img mx-1">
                                <img src="<?php echo e($item['thumbnail_full_url'] ?? asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    class="img-fluid onerror-image w-100 mw-450"
                                    data-onerror-image="<?php echo e(asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    alt="image">
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- ==== Ecommerce Venture Section Ends Here ==== -->

    <!-- ==== Main Category Section Starts Here ==== -->
    <?php ($promotion_banner = $landing_data['promotional_banners']); ?>
    <?php if($promotion_banner && count($promotion_banner) > 0): ?>
        <section class="main-category overflow-hidden pt-80 pb-80">
            <div class="container">
                <div class="overflow-hidden">
                    <div class="main-category-slider owl-theme owl-carousel">
                        <?php $__currentLoopData = $promotion_banner; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="category-slide-item"
                                style="background: url(<?php echo e($item['image_full_url']); ?>) no-repeat center center / cover">
                                <div>
                                    <h2 class="title"><?php echo e($item['title'] ?? ''); ?></h2>
                                    <div class="text"><?php echo e($item['sub_title'] ?? ''); ?></div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Main Category Section Ends Here ==== -->

    <!-- ==== Learn Feature Section Starts Here ==== -->
    <section class="learn-feature-section"
        style="background: url(<?php echo e(asset('public/assets/landing/img/learn-feature-bg.svg')); ?>) no-repeat center center / cover">
        <div class="container position-relative">
            <div class="row gy-5 gx-0 gx-xl-4 align-items-center">
                <div class=" col-lg-6 pe-lg-5">
                    <div class="learn-feature-content wow fadeInUp">
                        <div class="section-header text-start mb-0">
                            <h2 class="title">
                                <?php echo e($landing_data['feature_title']); ?>


                            </h2>
                            <div class="text">
                                <?php echo e($landing_data['feature_short_description']); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php ($feature = $landing_data['features']); ?>
                <?php
                $array1 = array_slice($feature, 0, ceil(count($feature) / 2));
                $array2 = array_slice($feature, ceil(count($feature) / 2));
                ?>
                <?php if(isset($feature) && ($x = count($feature) > 0)): ?>

                    <div class="col-lg-6">
                        <div class="learn-feature-wrapper py-5">
                            <div class="row g-4 learn-feature-item-group">
                                <div class="col-6">
                                    <div class="row gy-4 gy-sm-5">
                                        <!-- Item -->
                                        <?php $__currentLoopData = $array1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12">
                                                <div class="learn-feature-item">
                                                    <div class="learn-feature-icon">
                                                        <img src="<?php echo e($item['image_full_url']); ?>"
                                                            alt="<?php echo e($item['title'] ?? ''); ?>">
                                                    </div>
                                                    <div class="learn-feature-item-content">
                                                        <h5 class="subttle"><?php echo e($item['title'] ?? ''); ?></h5>
                                                        <div class="text">
                                                            <?php echo e($item['sub_title'] ?? ''); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Item End-->
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="row gy-4 gy-sm-5 mt-5 pt-5">
                                        <?php $__currentLoopData = $array2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12">
                                                <div class="learn-feature-item">
                                                    <div class="learn-feature-icon">
                                                        <img src="<?php echo e($item['image_full_url']); ?>"
                                                            alt="<?php echo e($item['title'] ?? ''); ?>">
                                                    </div>
                                                    <div class="learn-feature-item-content">
                                                        <h5 class="subttle"><?php echo e($item['title'] ?? ''); ?></h5>
                                                        <div class="text">
                                                            <?php echo e($item['sub_title'] ?? ''); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- ==== Learn Feature Section Ends Here ==== -->

    <!-- ==== Delivery Area Section Starts Here ==== -->
    <?php if($landing_data['available_zone_status'] && $landing_data['available_zone_list']): ?>
        <section class="delivery-area-section">
            <div class="container">
                <div class="row text-center gy-4 flex-wrap-reverse align-items-center">
                    <div class="col-lg-5 col-xl-6 text-lg-start">
                        <div class="section-header text-lg-start wow fadeInUp">
                            <h2 class="title">
                                
                                <span><?php echo e($landing_data['available_zone_title']); ?></span>

                            </h2>
                        </div>
                        <div class="text">
                            <?php echo e($landing_data['available_zone_short_description']); ?>

                        </div>
                        <div class="zone-list-container">
                            <div class="zone-list-wrapper mt-4">
                                <div class="zone-list">
                                    <?php $__currentLoopData = $landing_data['available_zone_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($zone['modules']->toArray()) > 0): ?>
                                            <span class="item" data-bs-trigger="hover" data-bs-toggle="popover"
                                                data-bs-placement="top" title="<?php echo e($zone['display_name']); ?>"
                                                data-bs-content="<?php echo e(count($zone['modules']->toArray()) > 0 ? implode(', ', $zone['modules']->toArray()) . ' ' . translate('are_available.') : translate('right_now_no_module_available.')); ?>">
                                                <?php echo e($zone['display_name']); ?>

                                            </span>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-7 col-xl-6 text-lg-end">
                        <img src="<?php echo e($landing_data['available_zone_image_full_url']); ?>" alt=""
                            class="img-fluid w-100 mw-450">
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Delivery Area Section Ends Here ==== -->

    <!-- ==== Refer Section Starts Here ==== -->
    <section class="refer-section pb-80">
        <div class="container">
            <div class="row align-items-center text-center gy-4 flex-wrap-reverse">
                <div class="col-lg-5 col-xl-6 text-lg-start">
                    <div class="section-header text-lg-start mb-3 wow fadeInUp">
                        <h2 class="title">
                            <div>
                                <?php echo e($landing_data['fixed_referal_title']); ?>


                            </div>
                        </h2>
                    </div>
                    <div class="text">
                        <?php echo e($landing_data['fixed_referal_sub_title']); ?>

                    </div>
                </div>
                <div class="col-lg-7 col-xl-6 text-lg-end">
                    <div class="refer-img">
                        <!-- Main Image -->
                        <svg class="main-img" viewBox="0 0 518 382" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M237.219 159.432C236.893 159.812 236.872 160.312 236.885 160.799C236.897 161.452 236.932 162.105 236.962 162.759C236.992 163.412 237.018 164.061 237.013 164.715C237.013 164.745 237.013 164.779 237.013 164.809C236.885 164.578 236.769 164.335 236.653 164.1C236.216 163.194 235.74 162.31 235.208 161.456C235.079 161.251 234.946 161.046 234.813 160.841C234.702 160.671 234.599 160.47 234.419 160.363C234.341 160.316 234.247 160.32 234.166 160.337C233.861 160.389 233.557 160.495 233.265 160.602C233.072 160.675 232.849 160.743 232.682 160.876C232.605 160.935 232.57 161.051 232.545 161.145C232.3 162.02 232.24 162.951 232.189 163.861C232.159 164.429 232.133 165.001 232.086 165.569C232.073 165.718 232.06 165.868 232.043 166.021C231.781 165.701 231.584 165.33 231.391 164.962C231.172 164.557 230.949 164.151 230.628 163.818C230.499 163.685 230.323 163.583 230.139 163.587C229.929 163.587 229.71 163.673 229.513 163.737C229.32 163.801 229.122 163.865 228.934 163.942C228.814 163.989 228.668 164.04 228.565 164.121C228.419 164.236 228.398 164.403 228.385 164.582C228.368 164.838 228.363 165.095 228.368 165.351C228.372 165.671 228.41 165.983 228.453 166.299C228.243 166.115 228.037 165.919 227.819 165.744C227.446 165.453 226.987 165.231 226.515 165.266C226.193 165.291 225.867 165.419 225.571 165.53C225.426 165.586 225.271 165.641 225.134 165.714C225.125 165.718 224.975 165.804 225.074 165.795C225.692 165.744 226.206 166.145 226.656 166.542C226.905 166.76 227.145 166.991 227.424 167.174C227.699 167.354 227.969 167.397 228.269 167.341C228.29 167.345 228.346 167.332 228.428 167.307C228.814 167.209 229.208 167.085 229.568 166.914C229.714 166.846 229.869 166.773 229.954 166.632C230.122 166.363 229.98 165.97 229.941 165.676C229.937 165.633 229.933 165.586 229.929 165.543C230.04 165.752 230.156 165.966 230.28 166.167C230.499 166.513 230.769 166.833 231.116 167.051C231.271 167.149 231.451 167.23 231.635 167.23C231.85 167.23 232.069 167.14 232.266 167.08C232.579 166.987 232.939 166.884 233.218 166.7C233.368 166.602 233.428 166.427 233.462 166.256C233.509 166.026 233.535 165.791 233.561 165.56C233.612 165.103 233.642 164.646 233.668 164.185C233.707 163.502 233.733 162.819 233.805 162.144C234.003 162.468 234.196 162.801 234.384 163.135C234.633 163.579 234.865 164.031 235.083 164.488C235.268 164.873 235.448 165.257 235.679 165.616C235.898 165.957 236.181 166.29 236.537 166.487C236.627 166.534 236.726 166.534 236.82 166.521C237.125 166.47 237.429 166.363 237.721 166.256C238.008 166.15 238.334 166.068 238.446 165.748C238.514 165.552 238.501 165.317 238.51 165.112C238.523 164.856 238.527 164.599 238.531 164.343C238.536 163.848 238.523 163.357 238.506 162.861C238.48 162.148 238.437 161.435 238.416 160.726C238.398 160.167 238.313 159.453 238.699 159.001C238.754 158.937 238.63 158.967 238.604 158.971C238.446 158.997 238.295 159.043 238.141 159.09C237.944 159.15 237.751 159.219 237.562 159.295C237.476 159.33 237.296 159.377 237.228 159.453L237.219 159.432Z"
                                fill="url(#paint0_linear_28_1911)" />
                            <path
                                d="M229.564 166.897L229.616 166.871C228.977 166.901 228.458 166.282 228.458 166.282C228.248 166.098 228.042 165.902 227.823 165.727C227.45 165.436 226.991 165.214 226.519 165.248C226.198 165.274 225.872 165.402 225.576 165.513C225.43 165.569 225.276 165.624 225.138 165.697C225.13 165.701 224.98 165.787 225.078 165.778C225.696 165.727 226.211 166.128 226.661 166.525C226.91 166.743 227.15 166.974 227.428 167.157C227.703 167.337 227.973 167.379 228.273 167.324C228.295 167.328 228.351 167.315 228.432 167.29C228.818 167.192 229.213 167.068 229.573 166.897H229.564Z"
                                fill="url(#paint1_linear_28_1911)" />
                            <path
                                d="M232.094 165.56C232.081 165.71 232.069 165.859 232.051 166.013C231.79 165.693 231.593 165.321 231.4 164.954C231.181 164.548 230.958 164.142 230.636 163.809C230.508 163.677 230.332 163.574 230.147 163.579C229.937 163.579 229.718 163.664 229.521 163.728C229.328 163.792 229.131 163.856 228.942 163.933C228.852 163.972 228.745 164.006 228.651 164.061C229.217 164.194 229.847 165.389 229.847 165.389L229.929 165.59C229.929 165.59 229.924 165.552 229.924 165.53C230.036 165.74 230.152 165.953 230.276 166.154C230.495 166.5 230.765 166.82 231.112 167.038C231.267 167.136 231.447 167.217 231.631 167.217C231.631 167.217 232 167.196 232.094 165.56Z"
                                fill="url(#paint2_linear_28_1911)" />
                            <path
                                d="M237 164.787C236.876 164.561 236.764 164.326 236.653 164.095C236.216 163.19 235.739 162.306 235.208 161.452C235.079 161.247 234.946 161.042 234.813 160.837C234.702 160.666 234.599 160.466 234.419 160.359C234.341 160.312 234.247 160.316 234.166 160.333C233.861 160.384 233.557 160.491 233.265 160.598C233.072 160.67 232.849 160.739 232.682 160.871H232.677L232.802 160.854C232.802 160.854 233.248 160.922 233.797 162.127C233.994 162.451 234.187 162.784 234.376 163.117C234.624 163.562 234.856 164.014 235.075 164.471C235.259 164.856 235.439 165.24 235.671 165.599C235.89 165.94 236.173 166.273 236.529 166.47C236.576 166.495 236.627 166.508 236.679 166.512C236.73 166.508 236.949 166.389 237 164.791V164.787Z"
                                fill="url(#paint3_linear_28_1911)" />
                            <path d="M466.096 355.875H431.784V356.133H466.096V355.875Z" fill="#EBEBEB" />
                            <path d="M343.144 358.692H334.141V358.951H343.144V358.692Z" fill="#EBEBEB" />
                            <path d="M430.748 346.261H410.867V346.52H430.748V346.261Z" fill="#EBEBEB" />
                            <path d="M99.0935 348.002H54.3486V348.261H99.0935V348.002Z" fill="#EBEBEB" />
                            <path d="M114.882 348.002H108.324V348.261H114.882V348.002Z" fill="#EBEBEB" />
                            <path d="M233.255 352.373H136.203V352.632H233.255V352.373Z" fill="#EBEBEB" />
                            <path
                                d="M246.982 293.005H46.9307C43.6673 293.005 41.0151 290.354 41.0151 287.09V5.91501C41.0151 2.65191 43.6673 0 46.9307 0H246.982C250.246 0 252.898 2.65191 252.898 5.91501V287.09C252.898 290.354 250.246 293.005 246.982 293.005ZM46.9307 0.258976C43.8123 0.258976 41.2741 2.79694 41.2741 5.91501V287.09C41.2741 290.209 43.8123 292.746 46.9307 292.746H246.982C250.101 292.746 252.639 290.209 252.639 287.09V5.91501C252.639 2.79694 250.101 0.258976 246.982 0.258976H46.9307Z"
                                fill="#EBEBEB" />
                            <path
                                d="M471.069 293.005H271.018C267.754 293.005 265.102 290.354 265.102 287.09V5.91501C265.102 2.65191 267.754 0 271.018 0H471.069C474.333 0 476.985 2.65191 476.985 5.91501V287.09C476.985 290.354 474.333 293.005 471.069 293.005ZM271.018 0.258976C267.899 0.258976 265.361 2.79694 265.361 5.91501V287.09C265.361 290.209 267.899 292.746 271.018 292.746H471.069C474.188 292.746 476.726 290.209 476.726 287.09V5.91501C476.726 2.79694 474.188 0.258976 471.069 0.258976H271.018Z"
                                fill="#EBEBEB" />
                            <path d="M518 339.207H0V339.466H518V339.207Z" fill="#EBEBEB" />
                            <path
                                d="M421.424 113.804H380.471C376.576 113.804 373.416 116.964 373.416 120.859V147.233C373.416 151.128 376.576 154.288 380.471 154.288H392.25L397.513 161.166C399.244 163.435 402.662 163.435 404.392 161.166L409.655 154.288H421.435C425.33 154.288 428.49 151.128 428.49 147.233V120.859C428.49 116.964 425.33 113.804 421.435 113.804H421.424Z"
                                fill="#E0E0E0" />
                            <path
                                d="M392.136 136.864C390.085 134.854 389.204 132.658 389.204 130.69C389.204 127.333 391.442 125.096 394.84 125.096C398.01 125.096 399.088 126.567 400.942 128.69C402.797 126.567 403.874 125.096 407.044 125.096C410.442 125.096 412.68 127.333 412.68 130.69C412.68 132.658 411.789 134.854 409.748 136.864L400.942 145.627L392.136 136.864Z"
                                fill="white" />
                            <path
                                d="M104.491 321.192C102.077 318.831 101.031 316.23 101.031 313.91C101.031 309.953 103.673 307.311 107.672 307.311C111.401 307.311 112.675 309.041 114.861 311.538C117.047 309.041 118.322 307.311 122.051 307.311C126.05 307.311 128.692 309.953 128.692 313.91C128.692 316.23 127.646 318.82 125.232 321.192L114.861 331.52L104.491 321.192Z"
                                fill="#E0E0E0" />
                            <path
                                d="M127.915 332.846C126.444 331.396 125.801 329.811 125.801 328.402C125.801 325.978 127.417 324.373 129.862 324.373C132.142 324.373 132.919 325.429 134.255 326.962C135.591 325.429 136.368 324.373 138.648 324.373C141.093 324.373 142.709 325.989 142.709 328.402C142.709 329.821 142.066 331.406 140.595 332.846L134.255 339.155L127.915 332.846Z"
                                fill="#EBEBEB" />
                            <path
                                d="M393.908 38.6703H346.925C342.46 38.6703 338.834 42.2959 338.834 46.7607V77.0195C338.834 81.4842 342.46 85.1099 346.925 85.1099H360.435L366.464 93.0035C368.453 95.6036 372.369 95.6036 374.358 93.0035L380.388 85.1099H393.897C398.363 85.1099 401.989 81.4842 401.989 77.0195V46.7607C401.989 42.2959 398.363 38.6703 393.897 38.6703H393.908Z"
                                fill="#F5F5F5" />
                            <path d="M355.659 74.0568H360.984V55.1308H354.768L355.659 74.0568Z" fill="#E0E0E0" />
                            <path
                                d="M385.671 58.0935C385.402 57.2544 384.552 55.4934 383.744 55.1412C381.413 54.0949 376.306 54.4264 371.779 55.0272C371.965 54.6646 372.131 54.3435 372.214 54.1053C372.607 53.0797 373.229 50.925 373.156 49.8373C373.094 48.8325 372.628 46.6053 371.779 46.077C371.323 45.787 370.017 45.6937 369.644 46.077C368.753 47.0093 369.375 49.972 369.012 51.2254C368.681 52.3649 367.199 54.385 365.925 55.9699C364.35 56.2599 363.335 56.4775 363.335 56.4775V73.1866C363.335 73.1866 376.979 76.8952 381.372 75.7039C383.061 75.2377 383.858 72.3165 384.48 70.6797C385.588 67.7378 386.625 61.108 385.661 58.1142L385.671 58.0935Z"
                                fill="#E0E0E0" />
                            <path
                                d="M275.058 64.9512C274.561 58.7979 269.422 54.0638 263.258 54.0638H254.742C248.567 54.0638 243.439 58.7979 242.942 64.9512L242.227 72.1714H275.773L275.058 64.9512Z"
                                fill="#EBEBEB" />
                            <path
                                d="M259 54.0639C263.411 54.0639 266.987 50.488 266.987 46.077C266.987 41.666 263.411 38.0902 259 38.0902C254.588 38.0902 251.012 41.666 251.012 46.077C251.012 50.488 254.588 54.0639 259 54.0639Z"
                                fill="#EBEBEB" />
                            <path
                                d="M100.513 176.3C99.2385 176.3 98.0678 176.746 97.1458 177.502L90.7329 172.333C91.0955 171.608 91.3131 170.789 91.3131 169.919C91.3131 166.967 88.9199 164.574 85.9673 164.574C83.0147 164.574 80.6216 166.967 80.6216 169.919C80.6216 172.872 83.0147 175.265 85.9673 175.265C87.2416 175.265 88.4123 174.819 89.3343 174.063L95.7472 179.232C95.3846 179.957 95.167 180.776 95.167 181.646C95.167 182.516 95.3742 183.334 95.7472 184.059L89.3343 189.228C88.4123 188.483 87.2416 188.027 85.9673 188.027C83.0147 188.027 80.6216 190.42 80.6216 193.372C80.6216 196.324 83.0147 198.717 85.9673 198.717C88.9199 198.717 91.3131 196.324 91.3131 193.372C91.3131 192.502 91.1059 191.684 90.7329 190.958L97.1458 185.789C98.0678 186.535 99.2385 186.991 100.513 186.991C103.465 186.991 105.859 184.598 105.859 181.646C105.859 178.693 103.465 176.3 100.513 176.3Z"
                                fill="#E0E0E0" />
                            <path
                                d="M259 382C369.937 382 459.87 376.75 459.87 370.274C459.87 363.797 369.937 358.547 259 358.547C148.062 358.547 58.1299 363.797 58.1299 370.274C58.1299 376.75 148.062 382 259 382Z"
                                fill="#F5F5F5" />
                            <path
                                d="M327.055 92.2679H302.844L278.425 371.32H302.636C313.856 371.32 323.75 362.225 324.734 351.006L345.599 112.592C346.583 101.374 338.275 92.2783 327.055 92.2783V92.2679Z"
                                fill="#263238" />
                            <path
                                d="M342.056 120.248C342.149 119.17 343.102 118.3 344.17 118.3C345.237 118.3 346.045 119.17 345.951 120.248L344.315 138.946C344.221 140.023 343.268 140.893 342.201 140.893C341.134 140.893 340.326 140.023 340.419 138.946L342.056 120.248Z"
                                fill="#039D55" />
                            <path opacity="0.3"
                                d="M342.056 120.248C342.149 119.17 343.102 118.3 344.17 118.3C345.237 118.3 346.045 119.17 345.951 120.248L344.315 138.946C344.221 140.023 343.268 140.893 342.201 140.893C341.134 140.893 340.326 140.023 340.419 138.946L342.056 120.248Z"
                                fill="white" />
                            <path
                                d="M297.684 371.309H197.928C186.708 371.309 178.399 362.214 179.383 350.995L200.248 112.582C201.233 101.363 211.126 92.2679 222.346 92.2679H322.103C333.323 92.2679 341.631 101.363 340.647 112.582L319.782 350.995C318.798 362.214 308.904 371.309 297.684 371.309Z"
                                fill="#039D55" />
                            <path
                                d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.106 104.792 287.335 107.879 283.18 107.879H258.534C254.39 107.879 251.157 104.792 250.992 100.679L250.961 99.8715C250.888 98.183 249.572 96.9295 247.873 96.9295H221.942C213.292 96.9295 205.667 103.943 204.91 112.582L184.045 350.995C183.289 359.645 189.681 366.648 198.332 366.648H298.088C306.739 366.648 314.364 359.635 315.12 350.995L335.985 112.582C336.741 103.932 330.349 96.9295 321.699 96.9295Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.106 104.792 287.335 107.879 283.18 107.879H258.534C254.39 107.879 251.157 104.792 250.992 100.679L250.961 99.8715C250.888 98.183 249.572 96.9295 247.873 96.9295H221.942C213.292 96.9295 205.667 103.943 204.91 112.582L184.045 350.995C183.289 359.645 189.681 366.648 198.332 366.648H298.088C306.739 366.648 314.364 359.635 315.12 350.995L335.985 112.582C336.741 103.932 330.349 96.9295 321.699 96.9295Z"
                                fill="white" />
                            <g opacity="0.2">
                                <path
                                    d="M264.875 100.926C265.701 100.134 265.784 98.8799 265.06 98.1237C264.336 97.3674 263.079 97.3957 262.253 98.1869C261.426 98.9782 261.343 100.233 262.067 100.989C262.791 101.745 264.048 101.717 264.875 100.926Z"
                                    fill="black" />
                                <path
                                    d="M279.772 97.5822H272.976C271.878 97.5822 270.914 98.473 270.821 99.5607C270.728 100.659 271.536 101.539 272.634 101.539H279.43C280.528 101.539 281.492 100.648 281.585 99.5607C281.678 98.4627 280.87 97.5822 279.772 97.5822Z"
                                    fill="black" />
                            </g>
                            <path d="M216.182 107.838H218.275L218.461 105.745H216.369L216.182 107.838Z" fill="#039D55" />
                            <path
                                d="M220.564 105.745L220.378 107.838H222.471L222.657 105.745L222.844 103.642H220.741L220.564 105.745Z"
                                fill="#039D55" />
                            <path
                                d="M225.123 101.55L224.936 103.642L224.76 105.745L224.574 107.838H226.666L226.853 105.745L227.039 103.642L227.216 101.55H225.123Z"
                                fill="#039D55" />
                            <path
                                d="M315.327 101.684L315.192 103.228H314.167L313.897 106.304H314.923L314.788 107.838H324.019L324.558 101.684H315.327ZM319.026 106.304H315.949L316.218 103.228H319.295L319.026 106.304Z"
                                fill="#039D55" />
                            <g opacity="0.4">
                                <path
                                    d="M258.606 107.879L189.743 363.913C192.105 365.633 195.058 366.648 198.342 366.648H203.729L273.328 107.879H258.617H258.606Z"
                                    fill="white" />
                                <path
                                    d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.126 104.688 287.521 107.703 283.501 107.858L213.903 366.648H266.987L335.985 110.106C335.446 102.637 329.5 96.9191 321.699 96.9191V96.9295Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M218.865 164.647L215.813 163.755C214.989 163.51 214.566 162.597 214.933 161.813L220.054 150.815L224.928 152.241L220.566 163.802C220.31 164.49 219.556 164.862 218.854 164.656L218.865 164.647Z"
                                fill="#039D55" />
                            <path
                                d="M284.444 141.018C284.444 141.018 287.459 142.354 290.495 140.365C293.675 138.283 299.653 140.904 297.84 149.377C294.732 163.963 288.247 174.436 292.453 178.849C292.453 178.849 278.446 179.491 280.518 167.122C282.072 157.851 292.608 147.316 290.07 145.223C289.22 144.529 287.988 144.881 284.009 144.881L284.434 141.007L284.444 141.018Z"
                                fill="#263238" />
                            <path
                                d="M284.02 144.892C286.485 144.892 288.34 145.13 289.707 145.576C290.598 143.017 290.547 140.779 290.453 139.723C287.211 140.075 284.455 141.018 284.455 141.018L284.03 144.892H284.02Z"
                                fill="#039D55" />
                            <path
                                d="M270.831 130.389C270.831 130.389 265.009 128.721 268.853 124.971C273.867 120.072 281.005 129.239 281.005 129.239C281.005 129.239 297.705 136.542 283.916 153.479C283.916 153.479 278.943 162.388 277.897 158.928C276.861 155.468 283.781 145.627 283.781 145.627L283.367 136.822L281.45 133.383L275.431 129.954L270.831 130.389Z"
                                fill="#263238" />
                            <path
                                d="M247.739 179.988C246.082 177.274 242.528 176.425 239.814 178.082L239.721 178.134C237.918 179.242 235.981 180.486 234.074 181.615L228.325 185.064C225.631 186.649 222.927 188.182 220.202 189.674C220.037 187.758 220.026 185.613 220.109 183.459C220.182 181.035 220.347 178.559 220.544 176.083C220.71 173.597 220.969 171.08 221.186 168.614V168.552C221.3 167.288 220.565 166.066 219.322 165.61C217.83 165.061 216.183 165.827 215.634 167.319C214.711 169.816 213.986 172.281 213.271 174.809C212.588 177.336 211.987 179.895 211.5 182.516C211.044 185.157 210.63 187.82 210.63 190.824C210.661 192.347 210.681 193.9 211.303 196.024C211.686 197.081 212.132 198.438 213.789 199.898C214.608 200.603 215.768 201.193 216.939 201.421C218.099 201.649 219.114 201.566 219.964 201.4C220.192 201.359 220.441 201.286 220.668 201.193L221.01 201.048C223.217 200.137 225.413 199.225 227.548 198.189C229.702 197.184 231.816 196.138 233.898 195.019C235.991 193.921 238.042 192.761 240.073 191.559C242.103 190.316 244.072 189.135 246.113 187.726C248.589 185.997 249.335 182.599 247.739 179.988Z"
                                fill="#CE7A63" />
                            <path
                                d="M252.815 172.437C256.307 179.47 251.282 185.572 242.072 195.351C233.867 188.493 232.531 180.019 232.531 180.019C232.531 180.019 243.15 171.235 252.815 172.447V172.437Z"
                                fill="#039D55" />
                            <path opacity="0.2"
                                d="M253.147 180.786C249.738 178.704 245.916 177.782 243.222 181.169C240.228 184.95 237.773 187.188 236.063 188.493C237.472 190.72 239.399 193.113 242.072 195.351C247.573 189.508 251.562 184.981 253.147 180.786Z"
                                fill="black" />
                            <path
                                d="M218.555 155.396L220.927 156.96C221.818 157.551 222.367 158.524 222.409 159.591L222.585 164.574C222.657 166.563 221.756 168.469 220.181 169.681L219.197 170.427C215.095 168.106 212.37 162.575 212.37 162.575L211.417 161.083C210.567 159.757 210.899 158.089 212.173 157.25L215.105 155.323C216.12 154.66 217.488 154.681 218.555 155.386V155.396Z"
                                fill="#CE7A63" />
                            <path
                                d="M244.693 366.648C250.07 350.032 253.727 331.665 250.08 318.23C272.251 253.113 262.253 234.156 262.253 234.156L235.866 224.532C235.866 224.532 232.095 283.175 230.956 311.527C230.324 327.397 227.61 348.012 224.491 366.637H244.683L244.693 366.648Z"
                                fill="#263238" />
                            <path opacity="0.5"
                                d="M258.379 258.251L253.023 249.622L249.738 256.355C249.738 256.355 246.651 282.211 252.152 311.983C257.291 296.113 260.42 283.206 262.243 272.785L258.379 258.251Z"
                                fill="black" />
                            <path
                                d="M260.907 366.648H280.902C282.942 349.431 282.963 330.899 276.861 318.499C286.154 250.347 272.707 233.648 272.707 233.648L244.963 229.256C244.963 229.256 252.494 287.536 256.814 315.588C259.052 330.111 260.316 348.955 260.907 366.637V366.648Z"
                                fill="#263238" />
                            <path
                                d="M240.435 185.53C239.741 189.208 238.83 191.943 237.949 200.841C237.058 208.351 236.405 215.768 235.545 228.168L273.1 234.114C274.022 223.413 277.162 211.552 287.677 188.814C290.112 183.541 287.47 177.689 281.989 176.249C280.529 175.865 278.964 175.482 277.358 175.151C271.111 173.845 265.973 172.83 260.306 172.447C258.42 172.323 256.473 172.25 254.587 172.219C247.812 172.095 241.679 178.942 240.435 185.53Z"
                                fill="#039D55" />
                            <path
                                d="M279.202 155.758C276.851 161.011 273.432 170.779 276.426 175.006C276.426 175.006 271.349 173.4 259.239 178.476C256.773 173.39 259.373 172.302 259.373 172.302C265.838 171.825 266.729 167.319 266.656 162.937L279.202 155.758Z"
                                fill="#CE7A63" />
                            <path
                                d="M261.777 177.471C263.186 177.906 264.077 179.056 264.647 180.299C265.548 182.267 267.91 183.065 269.785 181.988C272.852 180.237 276.809 177.74 278.767 175.524C277.576 174.643 275.898 172.996 275.898 172.996C275.898 172.996 264.232 175.71 261.777 177.471Z"
                                fill="white" />
                            <path
                                d="M258.41 176.342C258.41 176.342 257.27 176.466 255.965 177.43C255.053 178.103 253.789 177.191 254.162 176.124C255.457 172.457 257.685 172.022 257.685 172.022C257.685 172.022 258.949 171.39 261.041 172.064C257.923 173.131 258.399 176.342 258.399 176.342H258.41Z"
                                fill="white" />
                            <path opacity="0.2"
                                d="M274.084 158.69L266.656 162.937C266.677 163.973 266.636 165.019 266.48 166.014C268.894 166.045 272.707 164.025 273.525 161.642C273.929 160.451 274.157 159.291 274.084 158.69Z"
                                fill="black" />
                            <path
                                d="M285.636 145.493C282.569 154.091 281.45 157.778 275.721 161.228C267.102 166.418 257.187 161.383 257.622 152.195C258.006 143.918 262.958 131.259 272.551 129.778C282 128.317 288.692 136.905 285.626 145.503L285.636 145.493Z"
                                fill="#CE7A63" />
                            <path
                                d="M274.084 145.172C273.856 145.907 273.287 146.404 272.82 146.301C272.344 146.187 272.147 145.503 272.375 144.768C272.603 144.032 273.173 143.535 273.639 143.638C274.115 143.752 274.312 144.436 274.084 145.172Z"
                                fill="#263238" />
                            <path
                                d="M264.916 142.716C264.688 143.452 264.118 143.949 263.652 143.846C263.175 143.732 262.979 143.048 263.207 142.312C263.434 141.577 264.004 141.08 264.47 141.183C264.937 141.287 265.144 141.981 264.916 142.716Z"
                                fill="#263238" />
                            <path d="M264.667 141.287L263.082 140.375C263.082 140.375 263.548 141.96 264.667 141.287Z"
                                fill="#263238" />
                            <path
                                d="M267.578 144.229C267.578 144.229 265.372 147.098 263.548 148.3C264.232 149.429 265.983 149.398 265.983 149.398L267.578 144.229Z"
                                fill="#BA4D3C" />
                            <path
                                d="M276.871 140.904C276.757 140.883 276.654 140.821 276.581 140.728C275.545 139.122 273.908 139.174 273.888 139.174C273.649 139.174 273.453 138.998 273.453 138.749C273.453 138.5 273.67 138.303 273.908 138.293C273.991 138.293 276.053 138.231 277.338 140.22C277.462 140.417 277.4 140.696 277.182 140.841C277.079 140.914 276.965 140.935 276.851 140.914L276.871 140.904Z"
                                fill="#263238" />
                            <path
                                d="M262.947 136.574C262.844 136.532 262.761 136.449 262.72 136.346C262.637 136.128 262.761 135.869 262.999 135.786C265.382 134.885 267.081 135.993 267.143 136.035C267.34 136.17 267.382 136.439 267.236 136.636C267.081 136.832 266.801 136.884 266.594 136.75C266.532 136.708 265.196 135.859 263.31 136.584C263.186 136.625 263.061 136.625 262.947 136.584V136.574Z"
                                fill="#263238" />
                            <path d="M273.836 143.732L272.251 142.82C272.251 142.82 272.717 144.405 273.836 143.732Z"
                                fill="#263238" />
                            <path
                                d="M239.669 213.769H230.707C229.858 213.769 229.029 213.085 228.853 212.236L224.698 192.844C224.522 191.994 225.061 191.311 225.9 191.311H234.862C235.711 191.311 236.54 191.994 236.716 192.844L240.87 212.236C241.046 213.085 240.508 213.769 239.669 213.769Z"
                                fill="#263238" />
                            <path
                                d="M238.633 213.769H229.671C228.822 213.769 227.993 213.085 227.817 212.236L223.663 192.844C223.486 191.994 224.025 191.311 224.864 191.311H233.826C234.675 191.311 235.504 191.994 235.68 192.844L239.834 212.236C240.011 213.085 239.472 213.769 238.633 213.769Z"
                                fill="#263238" />
                            <path opacity="0.2"
                                d="M238.633 213.769H229.671C228.822 213.769 227.993 213.085 227.817 212.236L223.663 192.844C223.486 191.994 224.025 191.311 224.864 191.311H233.826C234.675 191.311 235.504 191.994 235.68 192.844L239.834 212.236C240.011 213.085 239.472 213.769 238.633 213.769Z"
                                fill="white" />
                            <path
                                d="M235.421 202.343L238.187 201.732C239.233 201.504 240.321 201.784 241.109 202.498L244.818 205.834C246.299 207.17 247.045 209.139 246.817 211.117L246.672 212.34C242.145 213.676 236.271 211.78 236.271 211.78L234.54 211.428C232.997 211.117 232.023 209.719 232.313 208.217L232.966 204.777C233.194 203.586 234.167 202.623 235.411 202.343H235.421Z"
                                fill="#CE7A63" />
                            <path
                                d="M283.17 182.164C280 181.863 277.192 184.194 276.892 187.354L276.871 187.53C276.778 188.566 276.633 189.829 276.498 191C276.364 192.191 276.198 193.382 276.011 194.574C275.659 196.956 275.234 199.329 274.768 201.67C274.281 204.011 273.701 206.3 273.059 208.558C272.51 210.361 271.878 212.101 271.204 213.8C270.531 213.842 269.64 213.79 268.708 213.645C266.491 213.303 263.217 212.661 260.793 211.884C258.358 211.128 255.903 210.237 253.447 209.304C250.992 208.403 248.516 207.367 246.102 206.393L246.03 206.362C244.849 205.886 243.44 206.248 242.642 207.315C241.699 208.59 241.968 210.392 243.243 211.335C245.522 213.013 247.812 214.473 250.194 215.944C252.577 217.374 255.022 218.71 257.591 219.943C260.171 221.145 263.652 222.284 266.708 223.082C268.241 223.465 269.868 223.807 271.878 223.828C272.883 223.828 274.012 223.734 275.338 223.32C276.623 222.937 278.218 222.067 279.399 220.647C279.575 220.43 279.762 220.171 279.896 219.912L280 219.726C281.357 217.219 282.528 214.66 283.481 212.07C284.424 209.48 285.242 206.87 285.895 204.239C286.558 201.618 287.086 198.976 287.501 196.314C287.698 194.988 287.884 193.652 288.029 192.315C288.195 190.958 288.298 189.684 288.371 188.172C288.516 185.116 286.237 182.443 283.16 182.153L283.17 182.164Z"
                                fill="#CE7A63" />
                            <path
                                d="M284.9 177.585C291.313 182.112 291.614 188.887 288.153 201.867C283.522 204.187 272.271 201.245 272.271 201.245C272.271 201.245 275.815 181.107 284.9 177.585Z"
                                fill="#039D55" />
                            <path
                                d="M261.86 151.687C261.86 151.687 265.337 151.338 275.001 151.486C273.787 152.926 271.607 154.072 266.657 153.995C264.17 154.078 262.037 153.133 261.872 151.893C261.872 151.822 261.872 151.758 261.872 151.687H261.86Z"
                                fill="#263238" />
                            <path
                                d="M269.002 152.867C267.104 152.785 265.195 153.009 263.569 153.499C264.464 153.812 265.537 153.983 266.645 153.977C268.542 154.06 270.439 153.842 272.078 153.346C271.182 153.027 270.109 152.856 269.013 152.862L269.002 152.867Z"
                                fill="#BA4D3C" />
                            <path
                                d="M262.296 151.651C262.473 152.017 263.039 152.307 263.769 152.395C266.633 152.431 269.509 152.348 272.349 152.153C273.268 152.124 274.093 151.864 274.553 151.468C270.463 151.374 266.362 151.433 262.284 151.657L262.296 151.651Z"
                                fill="white" />
                            <path
                                d="M272.634 129.198C272.085 129.281 271.546 129.405 271.028 129.56V130.047C272.23 130.037 273.567 130.182 275.048 130.638C282.217 132.824 283.367 136.812 280.933 142.81C279.783 145.648 279.161 151.667 280.487 152.796C280.829 153.086 281.865 153.044 283.212 152.827C284.103 150.786 284.952 148.341 286.04 145.296C289.179 136.491 282.321 127.696 272.634 129.188V129.198Z"
                                fill="#263238" />
                            <path
                                d="M286.454 153.345C284.952 154.888 282.974 155.582 281.316 155.572C278.84 155.562 278.436 153.003 279.834 150.869C281.088 148.953 283.896 146.653 286.04 147.689C288.154 148.714 288.164 151.584 286.444 153.345H286.454Z"
                                fill="#CE7A63" />
                            <g opacity="0.9">
                                <path
                                    d="M271.173 197.36C253.737 196.283 245.854 193.061 242.714 191.238C242.611 191.176 242.528 191.114 242.445 191.041C241.544 190.254 242.683 188.804 243.719 189.405C246.465 190.99 254.028 194.211 271.298 195.278C271.867 195.309 272.313 195.796 272.282 196.366C272.251 196.936 271.754 197.381 271.173 197.34V197.36Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.9">
                                <path
                                    d="M270.262 207.222C270.241 207.802 269.744 208.248 269.174 208.227C253.966 207.512 243.481 203.027 240.342 201.514C239.803 201.255 239.607 200.603 239.886 200.085C240.156 199.598 240.746 199.411 241.243 199.65C244.227 201.069 254.587 205.472 269.267 206.155C269.837 206.186 270.283 206.652 270.262 207.222Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.9">
                                <path
                                    d="M252.712 224.501C244.641 222.916 240.477 221.849 238.736 221.352C238.166 221.186 237.856 220.585 238.042 220.026C238.218 219.508 238.767 219.208 239.296 219.363C240.984 219.839 245.118 220.917 253.106 222.481C253.665 222.595 254.038 223.134 253.924 223.693C253.82 224.252 253.271 224.625 252.702 224.511L252.712 224.501Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M271.153 132.689C270.49 133.041 269.588 132.637 269.267 131.953C268.946 131.27 269.122 130.431 269.557 129.809C269.992 129.188 270.645 128.763 271.319 128.421C270.904 129.043 270.106 130.089 270.127 130.845C270.148 131.591 270.428 132.906 271.142 132.689H271.153Z"
                                fill="#263238" />
                            <path
                                d="M279.803 153.79C279.845 154.174 279.42 154.495 279.037 154.432C278.653 154.37 278.363 154.039 278.249 153.666C278.135 153.293 278.166 152.899 278.208 152.516C278.301 151.636 278.456 150.755 278.84 149.957C279.223 149.16 279.845 148.445 280.663 148.124C280.984 148.414 280.995 148.994 280.819 149.388C280.642 149.781 280.342 150.092 280.093 150.444C279.461 151.366 279.296 152.578 279.648 153.635C279.783 153.635 279.669 153.79 279.803 153.801V153.79Z"
                                fill="#263238" />
                            <defs>
                                <linearGradient id="paint0_linear_28_1911" x1="233.665" y1="167.502"
                                    x2="231.627" y2="161.077" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#F8A629" />
                                </linearGradient>
                                <linearGradient id="paint1_linear_28_1911" x1="229.666" y1="167.018"
                                    x2="225.584" y2="165.53" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                                <linearGradient id="paint2_linear_28_1911" x1="231.994" y1="167.315"
                                    x2="229.889" y2="163.655" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                                <linearGradient id="paint3_linear_28_1911" x1="237.106" y1="166.146"
                                    x2="233.757" y2="160.525" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                            </defs>
                        </svg>

                        <!-- Shape 1 -->
                        <svg class="shape-1" width="128" height="133" viewBox="0 0 128 133" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M97.2488 36.8319L24.3196 25.7714C18.7167 24.9217 13.491 28.7707 12.6414 34.373L4.23492 89.8023C3.38527 95.4046 7.23475 100.63 12.8376 101.48L67.9033 109.831C67.6336 118.864 74.1419 126.871 83.299 128.259C83.7088 128.322 84.1027 128.35 84.5068 128.38C82.2278 124.199 80.729 118.398 80.186 111.683L85.7684 112.53C91.3713 113.38 96.597 109.531 97.4466 103.928L105.853 48.4991C106.703 42.8967 102.853 37.6714 97.2504 36.8217L97.2488 36.8319Z"
                                fill="#dbdbdb" />
                            <path opacity="0.4"
                                d="M97.2488 36.8319L24.3196 25.7714C18.7167 24.9217 13.491 28.7707 12.6414 34.373L4.23492 89.8023C3.38527 95.4046 7.23475 100.63 12.8376 101.48L67.9033 109.831C67.6336 118.864 74.1419 126.871 83.299 128.259C83.7088 128.322 84.1027 128.35 84.5068 128.38C82.2278 124.199 80.729 118.398 80.186 111.683L85.7684 112.53C91.3713 113.38 96.597 109.531 97.4466 103.928L105.853 48.4991C106.703 42.8967 102.853 37.6714 97.2504 36.8217L97.2488 36.8319Z"
                                fill="white" />
                            <path
                                d="M108.284 62.5933L114.754 58.21L118.238 67.9167C118.238 67.9167 111.972 71.367 109.034 68.2182L108.274 62.5917L108.284 62.5933Z"
                                fill="#FF8B7B" />
                            <path d="M108.284 62.5934L103.177 70.2218L107.818 75.41L113.576 68.6033L108.284 62.5934Z"
                                fill="#FF8B7B" />
                            <path
                                d="M119.969 60.2374L120.387 63.7688C120.596 65.4979 119.691 67.2467 118.238 67.9169L115.952 68.9637L111.697 57.9142L116.854 57.4181C118.422 57.2368 119.757 58.4555 119.967 60.2476L119.969 60.2374Z"
                                fill="#FF8B7B" />
                            <path
                                d="M108.284 62.5934C108.284 62.5934 111.262 56.5699 111.258 54.5891C111.26 53.4054 112.408 53.7786 113.34 54.2657C114.058 54.647 114.475 55.4227 114.383 56.2364C114.151 58.3177 113.497 62.2838 111.86 62.2975C109.636 62.3164 108.284 62.5934 108.284 62.5934Z"
                                fill="#FF8B7B" />
                            <path
                                d="M113.912 70.1839C112.637 68.2303 110.748 66.6552 108.387 65.7836L106.71 65.1626C105.758 64.8086 105.486 65.0085 105.323 65.2561L104.715 65.9497L103.478 67.3337C102.638 68.2436 101.817 69.1668 100.96 70.0531C99.2913 71.8641 97.5724 73.5942 95.8557 75.2407C94.1508 76.8786 92.3795 78.4016 90.68 79.5897C90.5164 79.7011 90.3528 79.8125 90.1907 79.9137C89.7569 79.2507 89.3246 78.5774 88.9174 77.8766C87.7323 75.8109 86.6304 73.6111 85.6243 71.3316C84.6199 69.0419 81.2734 62.2269 80.4428 59.8273C80.0267 58.6326 79.624 57.419 79.252 56.2101L78.7196 54.4005C78.5545 53.8307 78.3758 53.1435 78.2741 52.709C78.2542 52.6326 78.2201 52.5122 78.2018 52.4256C77.0579 48.2916 72.7741 45.8608 68.6383 47.0147C64.5039 48.1584 62.073 52.4417 63.2271 56.5772C63.4701 57.4627 63.677 58.1018 63.8992 58.848L64.5945 60.9651C65.0732 62.3684 65.5771 63.744 66.1015 65.1227C67.1621 67.8715 70.8236 75.0277 72.1573 77.7026C73.4911 80.3776 74.9964 83.0262 76.7325 85.605C78.4787 88.1854 80.4525 90.7164 82.8379 93.0899L83.13 93.3751C84.4971 94.7245 86.4513 95.4505 88.5151 95.1767C91.2082 94.8308 93.084 93.9313 94.6944 93.0545C96.2977 92.1556 97.6071 91.1911 98.8141 90.2112C101.228 88.2513 103.216 86.1954 105.095 84.102C106.953 82.0054 108.635 79.8297 110.245 77.6431C111.033 76.5262 111.809 75.418 112.546 74.2831L113.646 72.5638L114.186 71.6924C114.397 71.41 114.508 71.0915 113.93 70.2075L113.912 70.1839Z"
                                fill="#263238" />
                            <path opacity="0.4"
                                d="M76.446 61.1699L70.2097 64.2894L67.9546 67.8974C68.1534 68.4514 68.3421 69.0039 68.5528 69.5493C69.6134 72.2981 70.8282 74.9969 72.1604 77.6821C73.4942 80.3571 74.9995 83.0057 76.7356 85.5845C77.5486 86.787 78.416 87.9768 79.3496 89.1451C77.6082 82.2488 76.446 61.1699 76.446 61.1699Z"
                                fill="black" />
                            <path
                                d="M21.3702 84.6686C20.262 94.9466 18.7104 94.2608 17.4687 102.172L67.3822 109.741C73.7639 85.972 73.0576 82.0615 75.5429 66.0202C76.9436 56.9915 76.928 47.5594 68.0777 45.2532C58.2391 42.6924 45.7375 40.9012 36.2938 40.6424C29.5219 40.4536 23.8813 45.8636 23.8494 52.6377C23.7967 66.5963 21.5264 74.1729 21.3702 84.6686Z"
                                fill="#263238" />
                            <path opacity="0.9"
                                d="M63.5771 44.183C57.1689 42.771 50.0824 41.6858 43.6128 41.0923C43.4471 43.1522 44.2197 48.5605 54.8921 54.6739C54.8921 54.6739 58.2547 49.568 60.0093 52.3696C60.0093 52.3696 62.1983 49.4745 64.9861 55.8276C64.9861 55.8276 71.3443 50.7988 63.5771 44.183Z"
                                fill="white" />
                            <path opacity="0.4"
                                d="M34.405 54.6158C34.061 64.2763 25.5896 79.2317 21.1572 86.4176C21.2395 85.8747 21.2973 85.2863 21.37 84.6686C21.4631 78.1134 22.3872 72.7109 23.0734 66.1827L34.405 54.6158Z"
                                fill="black" />
                            <path
                                d="M51.2597 23.6965C49.9714 32.2603 47.6044 36.9514 44.9868 41.2903C44.7357 41.7027 44.7589 42.2406 45.0677 42.6227C47.8878 46.0679 52.5213 49.2329 59.2984 50.355C65.9935 51.4646 65.9227 49.306 64.6923 46.7096C64.5182 46.3374 64.2528 46.0143 63.9357 45.7566C59.76 42.3364 60.1491 38.6654 61.7619 36.6678L51.2582 23.7067L51.2597 23.6965Z"
                                fill="#FF8B7B" />
                            <path opacity="0.2"
                                d="M51.2699 23.698L61.7736 36.6591C60.86 37.7778 60.3461 39.4392 60.8108 41.2803C58.3913 40.9972 56.0495 39.8562 54.1766 37.6967C51.4374 34.5467 50.8506 31.2306 50.7462 26.6675C50.9404 25.733 51.11 24.7529 51.2699 23.698Z"
                                fill="black" />
                            <path
                                d="M48.5037 17.4111C47.8054 25.6767 46.4389 26.8106 49.9787 31.5908C55.2911 38.7773 65.3011 41.5213 68.005 33.4341C70.4398 26.1548 73.2087 12.7339 65.6346 8.36866C58.1773 4.06299 49.2121 9.14699 48.5139 17.4126L48.5037 17.4111Z"
                                fill="#FF8B7B" />
                            <path
                                d="M67.0595 29.2359C67.0595 29.2359 64.3195 27.8878 56.2087 26.3015C56.6336 29.373 57.9745 32.07 62.1349 32.8267C66.2938 33.5936 67.0611 29.2256 67.0611 29.2256L67.0595 29.2359Z"
                                fill="#263238" />
                            <path
                                d="M60.6265 30.1986C62.635 30.5661 63.9876 31.3894 64.8926 32.4696C64.2153 32.8593 63.3067 33.0463 62.1453 32.8283C60.1367 32.4608 58.7928 31.6493 57.8894 30.5588C58.5667 30.1691 59.465 29.9805 60.6265 30.1986Z"
                                fill="#FF5652" />
                            <path
                                d="M66.7046 29.0878C66.3672 29.6548 66.0179 30.2305 65.1736 30.2701C63.464 30.0736 59.2446 28.6689 58.1282 28.1538C57.4069 27.8663 56.8318 27.4438 56.5522 26.3851C62.7876 27.6241 65.7468 28.7015 66.6928 29.0965L66.7046 29.0878Z"
                                fill="white" />
                            <path
                                d="M65.0076 21.1399C65.0076 21.1399 66.2084 24.2767 67.5625 25.7812C66.5877 26.6811 64.9635 26.2672 64.9635 26.2672L65.0076 21.1399Z"
                                fill="#FF5652" />
                            <path
                                d="M57.4618 16.3808C57.3917 16.3596 57.3349 16.3196 57.2915 16.2606C57.1509 16.0821 57.1692 15.823 57.3493 15.6722C59.1333 14.2035 60.9776 14.7556 61.0477 14.7767C61.2684 14.8416 61.3895 15.08 61.3143 15.2991C61.2494 15.5198 61.011 15.6408 60.7903 15.5759C60.7289 15.5666 59.2937 15.1498 57.8697 16.3169C57.7502 16.414 57.5903 16.4317 57.4501 16.3894L57.4618 16.3808Z"
                                fill="#263238" />
                            <path
                                d="M70.8437 19.8981C70.7074 19.8984 70.5805 19.8372 70.4936 19.7192C69.4648 18.2116 67.9659 18.2148 67.9029 18.2157C67.6714 18.2225 67.4898 18.0378 67.483 17.8063C67.4762 17.5747 67.6609 17.3932 67.8925 17.3864C67.976 17.3886 69.8883 17.3538 71.1834 19.2476C71.3121 19.4348 71.2615 19.6995 71.0743 19.8283C71.0036 19.8804 70.9272 19.9003 70.8437 19.8981Z"
                                fill="#263238" />
                            <path
                                d="M5.91807 84.0226C5.87085 84.4031 5.87328 84.8016 5.91823 85.1961C6.3495 89.0543 7.19183 92.1367 8.06737 95.2766C8.56812 97.0184 9.09557 98.7224 9.64662 100.409C10.6283 100.914 11.6933 101.285 12.8405 101.459L23.8823 103.134C23.6378 102.259 23.4036 101.385 23.1575 100.52C22.3543 97.6634 21.6243 94.8075 21.0125 92.0011C20.4852 89.6056 20.0404 87.1493 19.8619 85.0791C20.0401 84.4565 20.3587 83.5304 20.7592 82.6168C21.2749 81.4272 21.8968 80.1594 22.592 78.8923C23.9838 76.3478 25.5724 73.7493 27.221 71.1704C28.8797 68.5931 30.6512 66.0328 32.4298 63.4946C34.2068 60.9666 36.0767 58.3794 37.8949 55.9938L37.9601 55.9094C37.9601 55.9094 38.0269 55.8148 38.0654 55.7682C40.5745 52.2825 39.7811 47.4264 36.295 44.9174C32.809 42.4085 27.9524 43.2017 25.4434 46.6874C23.44 49.4639 21.6208 52.1322 19.786 54.9029C17.9732 57.6664 16.2259 60.4818 14.519 63.3767C12.8223 66.2731 11.1896 69.2315 9.69119 72.4095C8.93765 73.9926 8.21421 75.6536 7.55408 77.4499C6.91133 79.2698 6.26949 81.1527 5.93331 83.7839L5.89913 84.0093L5.91807 84.0226Z"
                                fill="#263238" />
                            <path
                                d="M43.9545 22.3266C44.4655 24.4158 45.7702 26.0386 47.1299 26.8839C49.179 28.1586 50.7138 26.1911 50.5627 23.6641C50.427 21.3804 49.2051 17.968 46.9448 17.7404C44.7168 17.5073 43.3626 19.9423 43.9443 22.325L43.9545 22.3266Z"
                                fill="#FF8B7B" />
                            <path
                                d="M58.9752 19.4602C58.8255 20.1709 59.0837 20.8178 59.5502 20.92C60.0167 21.0222 60.5103 20.5312 60.6513 19.8087C60.8026 19.0877 60.5428 18.4511 60.0866 18.3505C59.6303 18.2499 59.1265 18.7393 58.9752 19.4602Z"
                                fill="#2E353A" />
                            <path
                                d="M67.006 21.1601C66.8563 21.8708 67.1144 22.5177 67.5707 22.6183C68.027 22.7189 68.5308 22.2296 68.6821 21.5086C68.8318 20.7979 68.5736 20.151 68.1173 20.0504C67.6611 19.9498 67.147 20.4376 67.006 21.1601Z"
                                fill="#2E353A" />
                        </svg>
                        <!-- Shape 2 -->
                        <svg class="shape-2" width="110" height="114" viewBox="0 0 110 114" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M98.6725 21.1219L25.9842 8.51457C20.4006 7.54614 15.0944 11.2834 14.1261 16.8664L4.54537 72.1049C3.57703 77.6879 7.31476 82.9937 12.8983 83.9622L67.7744 93.48C67.3131 102.505 73.6501 110.648 82.7757 112.231C83.184 112.302 83.5772 112.338 83.9806 112.377C81.7908 108.149 80.4154 102.317 80.0133 95.6028L85.5765 96.5677C91.16 97.5361 96.4662 93.7989 97.4346 88.2158L107.015 32.9774C107.984 27.3944 104.246 22.0885 98.6623 21.1201L98.6725 21.1219Z"
                                fill="#DBDBDB" />
                            <path opacity="0.4"
                                d="M98.6725 21.1219L25.9842 8.51457C20.4006 7.54614 15.0944 11.2834 14.1261 16.8664L4.54537 72.1049C3.57703 77.6879 7.31476 82.9937 12.8983 83.9622L67.7744 93.48C67.3131 102.505 73.6501 110.648 82.7757 112.231C83.184 112.302 83.5772 112.338 83.9806 112.377C81.7908 108.149 80.4154 102.317 80.0133 95.6028L85.5765 96.5677C91.16 97.5361 96.4662 93.7989 97.4346 88.2158L107.015 32.9774C107.984 27.3944 104.246 22.0885 98.6623 21.1201L98.6725 21.1219Z"
                                fill="white" />
                            <path
                                d="M67.7846 93.4818C68.4177 85.5276 70.9163 75.6681 70.9163 75.6681C73.3619 65.3262 72.1981 53.4857 70.1747 51.1477C67.2607 47.7615 64.5548 44.5692 62.8212 47.8957C61.8276 49.8051 61.0358 53.1583 60.4234 56.9316C58.9428 66.0741 58.8574 77.782 58.9154 83.2066C58.9385 85.1347 58.6266 91.904 58.6266 91.904L67.7828 93.4921L67.7846 93.4818Z"
                                fill="#039D55" />
                            <path
                                d="M68.5572 51.3192C68.588 49.7475 67.6913 48.3093 66.2718 47.6426C63.8283 46.5143 59.6218 44.6388 55.7239 43.2267C51.1408 41.6433 46.4602 40.3794 41.7007 39.4488C38.7005 38.8022 35.7142 38.3789 33.3332 38.1026C33.054 38.0752 32.7594 38.0767 32.4816 38.1021C30.2864 38.3311 28.6928 40.3047 28.9237 42.4895C31.2292 65.1469 30.6896 75.7142 29.0977 86.7719L58.6385 91.8955C61.7479 82.1524 65.8744 74.4256 67.1373 68.5993C68.9732 60.0757 68.5469 53.9248 68.5554 51.3294L68.5572 51.3192Z"
                                fill="#039D55" />
                            <path opacity="0.8"
                                d="M68.5572 51.3192C68.588 49.7475 67.6913 48.3093 66.2718 47.6426C63.8283 46.5143 59.6218 44.6388 55.7239 43.2267C51.1408 41.6433 46.4602 40.3794 41.7007 39.4488C38.7005 38.8022 35.7142 38.3789 33.3332 38.1026C33.054 38.0752 32.7594 38.0767 32.4816 38.1021C30.2864 38.3311 28.6928 40.3047 28.9237 42.4895C31.2292 65.1469 30.6896 75.7142 29.0977 86.7719L58.6385 91.8955C61.7479 82.1524 65.8744 74.4256 67.1373 68.5993C68.9732 60.0757 68.5469 53.9248 68.5554 51.3294L68.5572 51.3192Z"
                                fill="white" />
                            <path
                                d="M58.2741 38.5278C55.8797 40.8145 53.9125 43.6695 56.3627 47.6691C56.8783 48.5155 57.1477 49.5085 56.9999 50.4816C56.7597 52.0486 55.5994 53.4034 51.0347 49.5311C44.4172 43.915 45.8896 39.1238 45.8896 39.1238C49.9721 38.6228 53.6899 30.8883 55.3954 26.3898L58.2759 38.5176L58.2741 38.5278Z"
                                fill="#FFB573" />
                            <path opacity="0.2"
                                d="M54.5912 33.4522C53.6761 35.3332 55.2301 38.8619 56.6065 40.3833C57.1015 39.7122 57.6625 39.0841 58.2658 38.5158L56.5552 31.3432C55.7647 31.9 55.094 32.6142 54.581 33.4505L54.5912 33.4522Z"
                                fill="black" />
                            <path
                                d="M77.4834 16.6477C79.5061 20.3839 71.952 29.2615 71.6767 27.09C71.2419 23.5345 70.9341 16.458 71.4449 13.6343C72.2438 9.20991 75.4709 12.9132 77.4834 16.6477Z"
                                fill="#263238" />
                            <path
                                d="M55.8075 13.95C59.5513 9.52125 66.1753 8.97742 70.6045 12.721C76.8584 17.9481 74.3733 29.1242 70.6919 35.1934C66.6381 41.9551 57.0368 41.236 53.279 33.8029C50.7533 28.844 51.7259 25.7219 53.6195 18.2597C54.0013 16.6647 54.7519 15.1863 55.8093 13.9398L55.8075 13.95Z"
                                fill="#FFB573" />
                            <path
                                d="M63.59 23.9421C63.4327 24.5457 63.6163 25.1242 64.0055 25.2443C64.3966 25.3542 64.8659 24.9519 65.0333 24.3502C65.2008 23.7484 65.007 23.1681 64.6178 23.048C64.2268 22.9381 63.7828 23.3763 63.59 23.9421Z"
                                fill="#263238" />
                            <path d="M64.4014 23.0841L65.9719 23.0621C65.9719 23.0621 64.9339 23.9544 64.4014 23.0841Z"
                                fill="#263238" />
                            <path
                                d="M71.0282 27.0091C70.871 27.6126 71.0545 28.1912 71.4438 28.3112C71.8348 28.4211 72.3041 28.0189 72.4716 27.4171C72.639 26.8153 72.4453 26.235 72.056 26.1149C71.665 26.0051 71.221 26.4432 71.0282 27.0091Z"
                                fill="#263238" />
                            <path d="M71.8396 26.151L73.4101 26.129C73.4101 26.129 72.3721 27.0214 71.8396 26.151Z"
                                fill="#263238" />
                            <path
                                d="M67.2898 31.1654C67.9632 31.5871 68.7869 31.6879 69.543 31.451C69.0364 30.0069 68.7312 28.4926 68.6391 26.9626L67.2898 31.1654Z"
                                fill="#ED893E" />
                            <path
                                d="M61.5379 29.8944C61.513 29.7955 61.5733 29.6903 61.662 29.6636C61.761 29.6387 61.8662 29.699 61.8929 29.7878C62.423 31.278 63.6332 32.4237 65.1445 32.8645C65.2328 32.9009 65.2901 32.9949 65.2622 33.0952C65.2343 33.1955 65.1318 33.2408 65.0417 33.2147C64.751 33.1327 64.4758 33.0219 64.2042 32.8907C62.9529 32.2846 61.9841 31.2019 61.5397 29.8842L61.5379 29.8944Z"
                                fill="#263238" />
                            <path
                                d="M64.0459 19.9209C63.9517 19.7363 64.0315 19.5188 64.2041 19.4331C66.0635 18.4729 68.2873 19.5946 68.3721 19.6514C68.5554 19.7463 68.6221 19.9681 68.529 20.1412C68.4341 20.3245 68.2122 20.3911 68.0391 20.298C68.0187 20.2945 66.1042 19.2685 64.5559 20.0724C64.4174 20.143 64.2421 20.1231 64.1356 20.01L64.0459 19.9209Z"
                                fill="#263238" />
                            <path
                                d="M74.7428 24.2048C74.3771 23.3423 73.6149 22.7055 72.7015 22.5155C72.4973 22.4801 72.3606 22.2987 72.396 22.0946C72.4314 21.8904 72.6128 21.7537 72.817 21.7891C73.9736 22.0317 74.9511 22.8216 75.426 23.9028C75.5082 24.0958 75.4182 24.3114 75.2372 24.3852C75.1227 24.4389 74.9781 24.4244 74.8746 24.3538C74.8187 24.3126 74.7747 24.2629 74.7428 24.2048Z"
                                fill="#263238" />
                            <path
                                d="M66.8894 14.3161C64.5423 14.3296 62.2321 15.4639 60.7756 17.314C60.0868 18.1934 56.3723 19.7254 55.6396 20.5551C53.3159 23.2221 53.8078 32.0863 52.849 32.5824C51.8903 33.0785 52.6338 30.6105 51.9021 29.979C51.1789 29.3594 50.2894 28.9107 49.6931 28.166C48.8601 27.1489 46.8913 17.282 52.22 12.4447C54.9529 9.96436 58.4677 8.25044 62.1603 8.23905C65.853 8.22766 69.5303 9.75914 72.1223 12.3955C72.9632 13.2458 74.2911 15.4107 71.4938 15.7771C70.7505 15.8795 70.8088 15.3008 70.0955 14.9879C69.0901 14.5401 67.9948 14.3081 66.8911 14.3059L66.8894 14.3161Z"
                                fill="#263238" />
                            <path
                                d="M48.137 19.2538C51.0831 17.2415 54.2271 17.7868 57.0035 18.2683C58.5551 18.5375 59.9025 18.7712 60.9892 18.5075C63.9985 17.7678 66.414 14.0864 66.9486 12.8229C67.4779 11.59 69.112 10.9587 69.6685 11.0237C70.0719 11.0621 71.3537 11.4316 71.8272 12.46C72.2017 13.2714 71.9701 14.3036 71.136 15.5363L71.4938 15.7771C72.4139 14.4122 72.6601 13.2353 72.2168 12.2752C71.6593 11.0641 70.2261 10.6578 69.7122 10.5897C68.96 10.5013 67.1497 11.2387 66.5478 12.6482C66.0531 13.8031 63.6961 17.3895 60.8847 18.0794C59.885 18.3265 58.5784 18.0999 57.0779 17.8397C54.3525 17.367 50.9839 16.7827 47.8941 18.8962L48.137 19.2538Z"
                                fill="#263238" />
                            <path opacity="0.1"
                                d="M48.137 19.2538C51.0831 17.2415 54.2271 17.7868 57.0035 18.2683C58.5551 18.5375 59.9025 18.7712 60.9892 18.5075C63.9985 17.7678 66.414 14.0864 66.9486 12.8229C67.4779 11.59 69.112 10.9587 69.6685 11.0237C70.0719 11.0621 71.3537 11.4316 71.8272 12.46C72.2017 13.2714 71.9701 14.3036 71.136 15.5363L71.4938 15.7771C72.4139 14.4122 72.6601 13.2353 72.2168 12.2752C71.6593 11.0641 70.2261 10.6578 69.7122 10.5897C68.96 10.5013 67.1497 11.2387 66.5478 12.6482C66.0531 13.8031 63.6961 17.3895 60.8847 18.0794C59.885 18.3265 58.5784 18.0999 57.0779 17.8397C54.3525 17.367 50.9839 16.7827 47.8941 18.8962L48.137 19.2538Z"
                                fill="white" />
                            <path
                                d="M49.8053 22.487C50.2245 21.1614 51.6362 20.418 52.974 20.8287C54.8026 21.4402 55.221 24.1202 54.9342 25.7737C54.5969 27.5972 53.0141 28.7209 51.5494 27.405C50.4506 26.4049 49.7905 24.9972 49.7117 23.5116C49.6765 23.1691 49.7061 22.8167 49.8071 22.4768L49.8053 22.487Z"
                                fill="#FFB573" />
                            <path
                                d="M48.4697 50.0115C47.1568 55.1563 38.9049 74.0586 28.3567 72.7968C26.7093 72.5952 25.1637 71.6858 24.0736 70.3928C24.0634 70.391 24.0465 70.367 24.0381 70.3551C16.4864 63.82 27.3828 40.3403 29.3251 39.2053C32.5616 37.338 37.4255 38.6967 38.1716 43.6099C38.5307 42.8731 38.8423 42.1071 39.1131 41.334C40.0158 38.736 42.5398 32.7919 45.2921 32.8067C46.9527 32.8109 50.2968 33.2331 51.0261 34.7264C51.7675 36.2113 50.6291 41.502 48.4679 50.0217L48.4697 50.0115Z"
                                fill="#039D55" />
                            <g opacity="0.2">
                                <path
                                    d="M52.9622 20.8372L52.9318 21.3155L52.6273 25.9203L51.6147 31.7585L53.0128 28.4263C53.3745 27.5533 53.5866 26.6334 53.6235 25.6935L53.8144 21.2583L52.9604 20.8474L52.9622 20.8372Z"
                                    fill="black" />
                            </g>
                            <path
                                d="M45.2902 33.9102L45.6119 24.5983L53.1966 25.8508C53.1966 25.8508 51.3896 32.571 49.0874 34.5688L45.28 33.9085L45.2902 33.9102Z"
                                fill="#FFB573" />
                            <path d="M48.0271 18.6144L53.4696 20.5782L53.1796 25.8268L45.6136 24.5882L48.0271 18.6144Z"
                                fill="#FFB573" />
                            <path opacity="0.2"
                                d="M34.468 51.5047C34.468 51.5047 28.104 61.2195 28.6935 57.0321C29.3229 52.4942 34.468 51.5047 34.468 51.5047Z"
                                fill="black" />
                        </svg>
                        <!-- Shape 3 -->
                        <svg class="shape-3" width="116" height="132" viewBox="0 0 116 132" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M16.3869 31.8622L94.3148 23.2301C100.297 22.5674 105.684 26.8796 106.347 32.8616L112.908 92.0949C113.571 98.0769 109.258 103.464 103.276 104.126L44.4283 110.645C44.3243 120.245 37.0749 128.479 27.2928 129.563C26.8603 129.611 26.4335 129.616 25.9988 129.644C28.6019 125.29 30.4403 119.209 31.2996 112.099L25.3376 112.76C19.3551 113.422 13.968 109.11 13.3053 103.128L6.744 43.8948C6.08137 37.9127 10.3941 32.5261 16.3767 31.8634L16.3869 31.8622Z"
                                fill="#dbdbdb" />
                            <path opacity="0.4"
                                d="M16.3869 31.8622L94.3148 23.2301C100.297 22.5674 105.684 26.8796 106.347 32.8616L112.908 92.0949C113.571 98.0769 109.258 103.464 103.276 104.126L44.4283 110.645C44.3243 120.245 37.0749 128.479 27.2928 129.563C26.8603 129.611 26.4335 129.616 25.9988 129.644C28.6019 125.29 30.4403 119.209 31.2996 112.099L25.3376 112.76C19.3551 113.422 13.968 109.11 13.3053 103.128L6.744 43.8948C6.08137 37.9127 10.3941 32.5261 16.3767 31.8634L16.3869 31.8622Z"
                                fill="white" />
                            <path
                                d="M15.2507 55.2926L10.6788 49.2121L12.6276 44.7855C12.8863 44.2045 12.866 43.5501 12.5744 42.9884L12.3469 42.5341C11.9616 41.7847 11.1506 41.3326 10.304 41.4055L6.51358 41.7212C5.72872 41.7873 5.05471 42.2892 4.74899 43.011L4.1421 44.4957C3.84668 45.2163 3.90705 46.0434 4.31525 46.7173L6.33108 50.048L10.2423 57.7859L15.2599 55.2812L15.2507 55.2926Z"
                                fill="#7F3E3B" />
                            <path
                                d="M45.7989 50.7518L25.578 69.1985L13.099 51.018L7.51144 54.2113C7.51144 54.2113 19.8084 82.5113 24.9287 80.7455C30.0593 78.9786 44.0945 69.9928 48.3764 64.4219C50.535 61.6084 51.873 56.7493 48.8237 51.2401C48.212 50.1406 46.7271 49.909 45.8001 50.7621L45.7989 50.7518Z"
                                fill="#039D55" />
                            <path
                                d="M49.7939 11.7256C49.7939 11.7256 42.2455 14.6254 46.8873 23.5956C46.8873 23.5956 50.6358 22.1485 50.997 19.5759C51.348 17.0044 51.5563 13.4272 51.5563 13.4272L49.8042 11.7244L49.7939 11.7256Z"
                                fill="#263238" />
                            <path opacity="0.3"
                                d="M49.7939 11.7256C49.7939 11.7256 42.2455 14.6254 46.8873 23.5956C46.8873 23.5956 50.6358 22.1485 50.997 19.5759C51.348 17.0044 51.5563 13.4272 51.5563 13.4272L49.8042 11.7244L49.7939 11.7256Z"
                                fill="black" />
                            <path
                                d="M72.2743 46.8915L58.0326 47.9896L52.2579 49.4944L52.6398 60.2809L64.5006 62.813L76.4334 59.0315L75.9302 48.6544L74.8268 46.6921L72.2743 46.8915Z"
                                fill="#7F3E3B" />
                            <path
                                d="M59.5956 108.965L79.6748 106.741C79.0972 99.6443 76.069 62.803 75.8779 63.0535C75.6581 63.328 77.1323 54.9935 77.1323 54.9935L76.7707 51.7297L74.2618 48.464C74.2618 48.464 70.4701 55.9191 62.9454 56.3983C55.8039 56.8558 53.7939 49.9079 53.7939 49.9079L54.099 60.8489L56.1103 87.1928L58.4862 98.1962L59.6071 108.974L59.5956 108.965Z"
                                fill="#039D55" />
                            <path opacity="0.6"
                                d="M59.5956 108.965L79.6748 106.741C79.0972 99.6443 76.069 62.803 75.8779 63.0535C75.6581 63.328 77.1323 54.9935 77.1323 54.9935L76.7707 51.7297L74.2618 48.464C74.2618 48.464 70.4701 55.9191 62.9454 56.3983C55.8039 56.8558 53.7939 49.9079 53.7939 49.9079L54.099 60.8489L56.1103 87.1928L58.4862 98.1962L59.6071 108.974L59.5956 108.965Z"
                                fill="white" />
                            <path
                                d="M51.6053 109.85L62.4893 108.644C63.0617 94.2396 60.4702 68.3039 60.4702 68.3039C60.4702 68.3039 57.0697 59.4359 55.764 53.5772C54.4584 47.7185 63.0196 47.5623 70.5521 47.7181C78.0846 47.8738 66.9709 68.0841 66.9709 68.0841C66.9709 68.0841 68.851 93.5253 72.5907 107.525L99.4144 104.554C97.6572 100.924 92.4178 89.7579 90.5592 81.6363C88.3145 71.8169 93.5551 56.5512 91.7933 49.5862C90.0316 42.6212 66.7346 46.6609 66.7346 46.6609C66.7346 46.6609 51.6999 48.2221 48.3705 48.7473C44.4667 49.3569 44.0535 59.8355 43.1022 68.185C42.1509 76.5345 46.4522 84.2187 49.4404 94.258C51.3991 100.836 51.6556 106.634 51.6053 109.85Z"
                                fill="#263238" />
                            <path
                                d="M56.8139 47.7182C61.705 47.1764 66.7334 46.6507 66.7334 46.6507C66.7334 46.6507 69.7196 46.1323 73.6221 45.7938C75.2945 46.682 77.6162 48.9158 76.556 54.307L73.3028 55.991L74.2913 59.2688C74.2913 59.2688 71.0651 65.9004 67.0118 68.7362C66.9765 68.3232 66.9605 68.0852 66.9605 68.0852C66.9605 68.0852 78.0741 47.875 70.5416 47.7192C63.0091 47.5635 54.448 47.7197 55.7537 53.5784C57.0593 59.4371 60.4598 68.305 60.4598 68.305C60.4598 68.305 60.4712 68.408 60.4906 68.583C58.1939 66.951 56.0464 63.8433 54.3259 60.0734L55.2894 56.0686L52.0339 54.72C52.0339 54.72 52.016 50.1361 56.8151 47.7285L56.8139 47.7182Z"
                                fill="#039D55" />
                            <path
                                d="M57.272 53.358C56.2613 51.3855 57.2046 49.9261 57.2046 49.9261C62.5757 47.4134 61.5978 43.2903 59.8795 39.5409L67.8527 29.3714C67.8578 34.311 68.9065 45.5657 72.532 49.1246L72.6312 50.0204C68.9545 55.5033 63.9364 56.0279 61.1404 55.8165C59.5216 55.6936 58.0152 54.7974 57.272 53.358Z"
                                fill="#7F3E3B" />
                            <path opacity="0.1"
                                d="M59.8794 39.541L66.2089 31.4712L67.9226 31.8859C67.968 32.7667 68.0432 33.7277 68.1344 34.739C67.4336 36.6926 65.5494 39.5382 60.6178 41.4081C60.403 40.7858 60.1458 40.1576 59.86 39.5535L59.8794 39.541Z"
                                fill="black" />
                            <path
                                d="M71.5391 20.7814C70.2868 29.331 69.9401 32.9756 65.2285 37.0203C58.1378 43.1107 47.9098 39.6995 46.5868 30.9558C45.3906 23.0734 47.6374 10.4219 56.3321 7.70783C62.5348 5.7388 69.1577 9.16369 71.1383 15.3749C71.6971 17.1265 71.8292 18.9775 71.5494 20.7803L71.5391 20.7814Z"
                                fill="#7F3E3B" />
                            <path
                                d="M52.027 25.1107C51.2702 26.6537 50.3041 28.0948 49.163 29.3676C49.8424 29.949 50.7347 30.1941 51.6157 30.0548L52.0373 25.1096L52.027 25.1107Z"
                                fill="#630F0F" />
                            <path
                                d="M60.5529 21.0604C60.6147 21.0536 60.6639 21.0273 60.7223 20.9895C60.8767 20.8786 60.9043 20.6567 60.7842 20.5137C60.0203 19.4518 58.785 18.8382 57.4842 18.8573C57.2988 18.8778 57.1603 19.0391 57.1705 19.2255C57.1911 19.4109 57.3421 19.5505 57.5285 19.5402C58.6028 19.5463 59.6186 20.0591 60.2475 20.9379C60.3207 21.034 60.4408 21.0832 60.5541 21.0707L60.5529 21.0604Z"
                                fill="#263238" />
                            <path
                                d="M46.5074 20.0732C46.5692 20.0663 46.6184 20.04 46.6767 20.0023C47.5327 19.3551 48.6471 19.1587 49.6721 19.4725C49.8471 19.5469 50.0462 19.4623 50.1206 19.2873C50.1836 19.1031 50.099 18.9041 49.9149 18.8411C48.6725 18.4472 47.311 18.6709 46.2719 19.4531C46.1163 19.5537 46.067 19.7676 46.178 19.9221C46.2523 20.0285 46.385 20.0972 46.5177 20.072L46.5074 20.0732Z"
                                fill="#263238" />
                            <path
                                d="M55.3393 31.9562C54.9377 32.0006 54.5327 32.0142 54.1334 31.9855C54.0179 31.9775 53.9344 31.8825 53.9322 31.7681C53.9402 31.6525 54.0341 31.5588 54.1496 31.5668C55.948 31.7115 57.7147 31.0051 58.9096 29.6534C58.9829 29.5619 59.1156 29.5368 59.2071 29.61C59.2986 29.6832 59.3237 29.816 59.2504 29.9075C58.265 31.0797 56.8552 31.8091 55.3301 31.9676L55.3393 31.9562Z"
                                fill="#263238" />
                            <path
                                d="M69.4584 27.5884C69.4584 27.5884 66.0282 24.9459 66.0004 19.4251C66.0004 19.4251 62.2752 16.3775 62.0328 12.6836C62.0328 12.6836 61.3682 15.7172 62.5871 17.6875C62.5871 17.6875 53.8371 18.021 53.5583 13.6223C53.5583 13.6223 53.2361 15.8884 54.6601 16.8875C54.6601 16.8875 46.9841 18.0713 47.5919 13.9601C48.1894 9.85006 54.017 7.22427 54.017 7.22427C54.017 7.22427 59.2313 1.69603 68.1478 9.45274C68.1478 9.45274 78.1659 14.2629 72.6055 24.7593L69.4687 27.5873L69.4584 27.5884Z"
                                fill="#263238" />
                            <path
                                d="M72.9991 27.7487C72.39 29.3066 71.1837 30.5554 69.6527 31.2252C67.6125 32.0974 66.3135 30.3444 66.6357 28.266C66.9303 26.4094 68.3396 23.6998 70.5088 23.7097C72.0887 23.764 73.3193 25.0868 73.2638 26.6563C73.2534 27.0326 73.1594 27.4078 73.0094 27.7475L72.9991 27.7487Z"
                                fill="#7F3E3B" />
                            <path
                                d="M58.1461 23.2343C58.1527 23.9527 57.7704 24.5474 57.2911 24.5484C56.8128 24.5597 56.4344 23.9659 56.4369 23.236C56.4394 22.5062 56.8126 21.9229 57.2817 21.923C57.7507 21.9232 58.1384 22.5056 58.1461 23.2343Z"
                                fill="#2E353A" />
                            <path
                                d="M49.9272 23.2797C49.9338 23.9981 49.5515 24.5928 49.0824 24.5927C48.6134 24.5925 48.2257 24.0101 48.218 23.2814C48.2102 22.5527 48.5937 21.9682 49.0627 21.9684C49.5318 21.9686 49.9298 22.5498 49.9272 23.2797Z"
                                fill="#2E353A" />
                            <path d="M49.2652 22.0085L47.5229 21.524C47.5229 21.524 48.4332 22.8719 49.2652 22.0085Z"
                                fill="#2E353A" />
                            <path d="M57.4841 21.9631L55.7407 21.4684C55.7407 21.4684 56.6509 22.8163 57.4841 21.9631Z"
                                fill="#2E353A" />
                            <path
                                d="M69.5679 35.1639C71.1021 34.9939 72.2101 33.6101 72.0401 32.076C71.9626 31.3758 71.631 30.7351 71.1003 30.2728L70.7764 30.6422C71.2145 31.021 71.4923 31.553 71.5562 32.1296C71.6965 33.396 70.7808 34.5397 69.5143 34.68C68.2477 34.8203 67.104 33.9047 66.9637 32.6383C66.8234 31.3719 67.7391 30.2282 69.0056 30.0879C69.3351 30.0514 69.652 30.0893 69.9643 30.1797L70.1109 29.7153C69.7323 29.5905 69.3421 29.5504 68.9509 29.5937C67.4166 29.7637 66.3087 31.1475 66.4786 32.6816C66.6485 34.2157 68.0325 35.3235 69.5667 35.1536L69.5679 35.1639Z"
                                fill="#039D55" />
                            <g opacity="0.6">
                                <path
                                    d="M69.5679 35.1639C71.1021 34.9939 72.2101 33.6101 72.0401 32.076C71.9626 31.3758 71.631 30.7351 71.1003 30.2728L70.7764 30.6422C71.2145 31.021 71.4923 31.553 71.5562 32.1296C71.6965 33.396 70.7808 34.5397 69.5143 34.68C68.2477 34.8203 67.104 33.9047 66.9637 32.6383C66.8234 31.3719 67.7391 30.2282 69.0056 30.0879C69.3351 30.0514 69.652 30.0893 69.9643 30.1797L70.1109 29.7153C69.7323 29.5905 69.3421 29.5504 68.9509 29.5937C67.4166 29.7637 66.3087 31.1475 66.4786 32.6816C66.6485 34.2157 68.0325 35.3235 69.5667 35.1536L69.5679 35.1639Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M72.3104 77.4251L64.7889 78.5918L61.8042 74.7952C61.4154 74.2963 60.8206 74.0078 60.1936 73.9939L59.6925 73.9868C58.8471 73.9763 58.0678 74.4691 57.738 75.256L56.2381 78.7469C55.9324 79.4686 56.0453 80.3003 56.5508 80.9114L57.5743 82.1529C58.0684 82.7548 58.8245 83.0879 59.6116 83.0424L63.5072 82.8298L72.1815 83.0363L72.3425 77.432L72.3104 77.4251Z"
                                fill="#7F3E3B" />
                            <path
                                d="M82.6928 48.3535L89.4359 74.882L67.5135 77.3104L67.6944 83.7418C67.6944 83.7418 98.4484 86.2342 99.3151 80.8853C100.17 75.5272 98.8617 58.913 95.9637 52.5116C94.5015 49.2863 90.844 45.8143 84.5482 45.9072C83.2897 45.9319 82.39 47.1259 82.7019 48.3421L82.6928 48.3535Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 4 -->
                        <svg class="shape-4" width="25" height="23" viewBox="0 0 25 23" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M3.15953 0.268188H21.4744C23.219 0.268188 24.6252 1.6829 24.6252 3.41874V15.2138C24.6252 16.9583 23.2104 18.3643 21.4744 18.3643H16.2056L13.8533 21.4368C13.0808 22.4523 11.5531 22.4523 10.7719 21.4368L8.41961 18.3643H3.15085C1.40617 18.3643 0 16.9496 0 15.2138V3.41874C0 1.67422 1.41484 0.268188 3.15953 0.268188Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M3.15953 0.268188H21.4744C23.219 0.268188 24.6252 1.6829 24.6252 3.41874V15.2138C24.6252 16.9583 23.2104 18.3643 21.4744 18.3643H16.2056L13.8533 21.4368C13.0808 22.4523 11.5531 22.4523 10.7719 21.4368L8.41961 18.3643H3.15085C1.40617 18.3643 0 16.9496 0 15.2138V3.41874C0 1.67422 1.41484 0.268188 3.15953 0.268188Z"
                                fill="white" />
                            <path
                                d="M4.21875 8.37461L10.0778 4.79877V6.94253H12.7599C16.3447 6.94253 19.2525 9.85007 19.2525 13.4346C19.2525 13.9293 19.1918 14.4067 19.0876 14.8667C18.4366 11.9678 15.85 9.80668 12.7599 9.80668H10.0778V11.9504L4.21875 8.37461Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 5 -->
                        <svg class="shape-5" width="34" height="30" viewBox="0 0 34 30" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M29.0932 0H4.44089C2.0939 0 0.194824 1.89892 0.194824 4.24569V20.1267C0.194824 22.4735 2.0939 24.3724 4.44089 24.3724H11.5266L14.6888 28.5106C15.7369 29.8721 17.7883 29.8721 18.8364 28.5106L21.9985 24.3724H29.0843C31.4313 24.3724 33.3303 22.4735 33.3303 20.1267V4.24569C33.3303 1.89892 31.4313 0 29.0843 0H29.0932Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M29.0932 0H4.44089C2.0939 0 0.194824 1.89892 0.194824 4.24569V20.1267C0.194824 22.4735 2.0939 24.3724 4.44089 24.3724H11.5266L14.6888 28.5106C15.7369 29.8721 17.7883 29.8721 18.8364 28.5106L21.9985 24.3724H29.0843C31.4313 24.3724 33.3303 22.4735 33.3303 20.1267V4.24569C33.3303 1.89892 31.4313 0 29.0843 0H29.0932Z"
                                fill="white" />
                            <path
                                d="M27.66 10.9098L19.768 6.09088V8.97508H16.149C11.3206 8.97508 7.40601 12.8893 7.40601 17.7172C7.40601 18.3801 7.48663 19.025 7.62996 19.643C8.50784 15.7467 11.9835 12.8267 16.149 12.8267H19.768V15.7109L27.66 10.8919V10.9098Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 6 -->
                        <svg class="shape-6" width="57" height="49" viewBox="0 0 57 49" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M51.8997 34.0325C51.0552 33.7856 50.5676 32.8995 50.8145 32.055L51.3753 30.1528C51.6221 29.3083 52.5084 28.8208 53.3529 29.0677C54.1974 29.3145 54.685 30.2007 54.4382 31.0451L53.8774 32.9473C53.6305 33.7918 52.7443 34.2793 51.8997 34.0325Z"
                                fill="#039D55" />
                            <path
                                d="M49.5243 24.185C49.5243 24.185 37.8388 22.0059 33.8659 19.595C24.5156 13.926 16.0994 1.38599 14.166 0.823022C11.0116 -0.0965931 6.11327 7.16812 3.20909 17.0667C0.315249 26.9661 0.513582 35.7348 3.66801 36.6544C5.60141 37.2174 19.4567 31.2113 30.3847 31.4778C35.0297 31.5893 46.0431 36.0678 46.0431 36.0678L49.5243 24.185V24.185Z"
                                fill="#039D55" />
                            <path opacity="0.3"
                                d="M49.5243 24.185C49.5243 24.185 37.8388 22.0059 33.8659 19.595C24.5156 13.926 16.0994 1.38599 14.166 0.823022C11.0116 -0.0965931 6.11327 7.16812 3.20909 17.0667C0.315249 26.9661 0.513582 35.7348 3.66801 36.6544C5.60141 37.2174 19.4567 31.2113 30.3847 31.4778C35.0297 31.5893 46.0431 36.0678 46.0431 36.0678L49.5243 24.185V24.185Z"
                                fill="white" />
                            <path
                                d="M14.6249 20.4107C11.731 30.3101 6.82233 37.5741 3.6679 36.6544C0.513477 35.7348 0.304809 26.9654 3.20898 17.0668C6.10283 7.16741 11.0115 -0.0965766 14.1659 0.823039C17.3204 1.74265 17.529 10.5121 14.6249 20.4107V20.4107Z"
                                fill="#039D55" />
                            <path opacity="0.4"
                                d="M14.6249 20.4107C11.731 30.3101 6.82233 37.5741 3.6679 36.6544C0.513477 35.7348 0.304809 26.9654 3.20898 17.0668C6.10283 7.16741 11.0115 -0.0965766 14.1659 0.823039C17.3204 1.74265 17.529 10.5121 14.6249 20.4107V20.4107Z"
                                fill="black" />
                            <path
                                d="M47.7092 22.6854L42.3268 21.1092C40.8615 20.6833 39.3237 21.5712 39.0099 23.0651C38.7264 24.4262 38.3676 25.8235 37.955 27.2482C37.5423 28.6728 37.0816 30.0421 36.5848 31.3361C36.0474 32.7623 36.8593 34.3465 38.3247 34.7724L44.7044 36.6375C48.5299 37.7605 51.5143 35.2202 52.5872 31.3707C53.6202 27.6431 51.4232 23.7693 47.6996 22.6743L47.7092 22.6854Z"
                                fill="#263238" />
                            <path
                                d="M9.14837 17.9659L8.6959 19.5123C8.43504 20.4077 8.85475 21.3721 9.68682 21.7946L13.5481 23.7302C13.9351 22.6673 14.294 21.5607 14.6352 20.4114C14.9661 19.2614 15.2638 18.1402 15.5083 17.0359L11.2196 16.5862C10.2814 16.4885 9.41956 17.0712 9.14837 17.9659Z"
                                fill="#263238" />
                            <path opacity="0.8"
                                d="M9.14837 17.9659L8.6959 19.5123C8.43504 20.4077 8.85475 21.3721 9.68682 21.7946L13.5481 23.7302C13.9351 22.6673 14.294 21.5607 14.6352 20.4114C14.9661 19.2614 15.2638 18.1402 15.5083 17.0359L11.2196 16.5862C10.2814 16.4885 9.41956 17.0712 9.14837 17.9659Z"
                                fill="white" />
                            <path opacity="0.2"
                                d="M12.0403 19.6562C11.7522 20.6431 11.436 21.5865 11.1102 22.5188L13.5377 23.7295C13.9247 22.6665 14.2836 21.56 14.6248 20.4107C14.9557 19.2607 15.2534 18.1395 15.4979 17.0352L12.797 16.7501C12.5738 17.7001 12.3181 18.6685 12.03 19.6554L12.0403 19.6562Z"
                                fill="black" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==== Refer Section Ends Here ==== -->


    <!-- ==== Earn Money Section Starts Here ==== -->
    <section class="earn-money-section z-2">
        <div class="container">
            <div class="section-header wow fadeInUp">
                <h2 class="title">
                    <?php echo e($landing_data['earning_title']); ?>


                </h2>
                <div class="text"><?php echo e($landing_data['earning_sub_title']); ?></div>
            </div>
        </div>
        <div class="container">
            <!-- Earn Money Item -->
            <?php ($join_as_seller = $landing_data['seller_app_earning_links']); ?>
            <div class="earn-item wow fadeInUp">
                <div class="earn-item-img"
                    style="background: url(<?php echo e(\App\CentralLogics\Helpers::get_full_url('earning', isset($landing_data['earning_seller_image']) ? $landing_data['earning_seller_image'] : null, isset($landing_data['earning_seller_image_storage']) ? $landing_data['earning_seller_image_storage'] : 'public')); ?>) no-repeat center center / cover;">
                    <div class="position-relative dropdown text-capitalize z-2">




                        <?php if(isset($join_as_seller['playstore_url_status']) &&
                                $join_as_seller['playstore_url_status'] == '1' &&
                                isset($join_as_seller['apple_store_url_status']) &&
                                $join_as_seller['apple_store_url_status'] == '1'): ?>
                            <button type="button" class="cmn--btn border-0" data-bs-toggle="dropdown">
                                <?php echo e(translate('Seller App')); ?>

                                <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                        fill="#ffffff"></path>
                                </svg>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end p-0">
                                <a href="<?php echo e(isset($join_as_seller['playstore_url']) ? $join_as_seller['playstore_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('google_play')); ?>

                                </a>
                                <a href="<?php echo e(isset($join_as_seller['apple_store_url']) ? $join_as_seller['apple_store_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('apple_store')); ?>

                                </a>
                            </div>
                        <?php elseif(isset($join_as_seller['playstore_url_status']) && $join_as_seller['playstore_url_status'] == '1'): ?>
                            <a type="button" class="cmn--btn border-0"
                                href="<?php echo e(isset($join_as_seller['playstore_url']) ? $join_as_seller['playstore_url'] : ''); ?>">
                                <?php echo e(translate('Seller App')); ?>

                            </a>
                        <?php elseif(isset($join_as_seller['apple_store_url_status']) && $join_as_seller['apple_store_url_status'] == '1'): ?>
                            <a type="button" class="cmn--btn border-0"
                                href="<?php echo e(isset($join_as_seller['apple_store_url']) ? $join_as_seller['apple_store_url'] : ''); ?>">
                                <?php echo e(translate('Seller App')); ?>

                            </a>
                        <?php endif; ?>












                    </div>
                </div>
                <div class="earn-item-cont">
                    <div>
                        <h4 class="subtitle"><?php echo e(translate('messages.Become a best')); ?> </h4>
                        <h3 class="title"><?php echo e(translate('messages.Seller')); ?></h3>
                    </div>
                </div>
            </div>
            <!-- Earn Money Item -->
            <?php ($join_as_dm = $landing_data['dm_app_earning_links']); ?>
            <div class="earn-item wow fadeInUp">
                <div class="earn-item-img"
                    style="background: url(<?php echo e(\App\CentralLogics\Helpers::get_full_url('earning', isset($landing_data['earning_delivery_image']) ? $landing_data['earning_delivery_image'] : null, isset($landing_data['earning_delivery_image_storage']) ? $landing_data['earning_delivery_image_storage'] : 'public')); ?>) no-repeat center center / cover;">
                    <div class="position-relative dropdown text-capitalize z-2">

                        <?php if(isset($join_as_dm['playstore_url_status']) &&
                                $join_as_dm['playstore_url_status'] == '1' &&
                                isset($join_as_dm['apple_store_url_status']) &&
                                $join_as_dm['apple_store_url_status'] == '1'): ?>
                            <button type="button" class="cmn--btn border-0" data-bs-toggle="dropdown">
                                <?php echo e(translate('Deliveryman App')); ?>

                                <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                        fill="#ffffff"></path>
                                </svg>
                            </button>

                            <div class="dropdown-menu p-0">
                                <a href="<?php echo e(isset($join_as_dm['playstore_url']) ? $join_as_dm['playstore_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('google_play')); ?>

                                </a>

                                <a href="<?php echo e(isset($join_as_dm['apple_store_url']) ? $join_as_dm['apple_store_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('apple_store')); ?>

                                </a>
                            </div>
                        <?php elseif(isset($join_as_dm['playstore_url_status']) && $join_as_dm['playstore_url_status'] == '1'): ?>
                            <a type="button"
                                href="<?php echo e(isset($join_as_dm['playstore_url']) ? $join_as_dm['playstore_url'] : ''); ?>"
                                class="cmn--btn border-0">
                                <?php echo e(translate('Deliveryman App')); ?>

                            </a>
                        <?php elseif(isset($join_as_dm['apple_store_url_status']) && $join_as_dm['apple_store_url_status'] == '1'): ?>
                            <a type="button"
                                href="<?php echo e(isset($join_as_dm['apple_store_url']) ? $join_as_dm['apple_store_url'] : ''); ?>"
                                class="cmn--btn border-0">
                                <?php echo e(translate('Deliveryman App')); ?>

                            </a>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="earn-item-cont">
                    <div>
                        <h4 class="subtitle"><?php echo e(translate('messages.Become a smart')); ?></h4>
                        <h3 class="title"><?php echo e(translate('messages.Deliveryman')); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <!-- Shape 1 -->
        <svg class="e-shape-1" width="321" height="1198" viewBox="0 0 321 1198" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g opacity="0.19">
                <g opacity="0.3">
                    <path
                        d="M378.224 594.481C373.917 598.162 367.986 599.453 362.327 599.161C356.683 598.857 351.211 597.12 345.856 595.316C334.069 591.363 323.268 587.609 312.023 582.401C307.382 580.253 301.984 577.016 297.605 574.374C296.199 573.531 294.788 572.62 293.816 571.304C292.843 569.989 292.39 568.17 293.08 566.691C293.845 565.033 295.841 564.224 297.676 564.297C299.498 564.369 301.224 565.129 302.9 565.856C317.001 571.934 332.524 576.055 347.691 573.63C351.932 572.956 356.073 571.773 360.292 571.057C364.525 570.342 368.93 570.092 373.054 571.277C377.179 572.461 381.002 575.252 382.622 579.231C384.749 584.469 382.529 590.826 378.221 594.508L378.224 594.481Z"
                        fill="url(#paint0_linear_28_738)" />
                    <path
                        d="M219.315 746.746C219.537 742.343 221.978 738.289 225.173 735.24C228.366 732.205 232.275 730.038 236.174 727.963C244.72 723.406 252.633 719.298 261.599 715.721C265.304 714.242 270.026 712.927 273.858 711.854C275.083 711.517 276.36 711.2 277.62 711.352C278.881 711.504 280.154 712.223 280.629 713.412C281.156 714.741 280.537 716.296 279.529 717.292C278.507 718.286 277.16 718.85 275.853 719.42C264.862 724.153 254.215 730.732 247.475 740.624C245.594 743.386 244.037 746.363 242.18 749.141C240.324 751.92 238.096 754.546 235.225 756.247C232.354 757.947 228.72 758.613 225.609 757.402C221.494 755.802 219.095 751.136 219.317 746.733L219.315 746.746Z"
                        fill="url(#paint1_linear_28_738)" />
                    <path
                        d="M143.17 601.174C147.418 604.46 151.352 580.886 150.402 568.451C149.454 556.003 133.85 557.917 136.356 575.415C138.863 592.912 141.903 600.186 143.183 601.175L143.17 601.174Z"
                        fill="url(#paint2_linear_28_738)" />
                    <path
                        d="M128.09 732.092C141.591 745.934 162.259 752.709 181.156 748.606C196.029 745.391 208.759 736.169 221.92 728.506C241.322 717.207 262.495 708.962 284.436 704.176C304.83 699.716 333.913 707.479 351.856 696.785C363.632 689.776 373.236 678.789 377.345 665.712C382.497 649.341 376.572 628.712 367.992 618.036C350.588 596.371 308.532 594.489 287.486 576.344C270.44 561.644 268.668 540.627 253.119 524.344C240.139 510.754 219.523 505.223 201.347 509.938C183.17 514.653 168.003 529.237 162.031 547.044C157.823 559.611 157.965 573.161 156.007 586.268L155.98 586.494C154.128 598.604 148.985 609.995 141.233 619.468C139.021 622.177 136.848 624.904 134.725 627.664C123.155 642.776 113.113 659.85 110.741 678.725C108.332 697.918 114.605 718.226 128.106 732.067L128.09 732.092Z"
                        fill="url(#paint3_linear_28_738)" />
                </g>
                <path
                    d="M142.919 1178.36C142.996 1177.82 143.323 1177.54 143.834 1177.37C145.127 1176.95 146.408 1176.48 147.694 1176.04C148.451 1175.78 148.839 1175.98 149.102 1176.74C151.127 1182.6 153.155 1188.47 155.192 1194.33C155.368 1194.83 155.339 1195.25 155.014 1195.66L149.556 1197.54L142.923 1178.35L142.919 1178.36Z"
                    fill="url(#paint4_linear_28_738)" />
                <path
                    d="M186.73 1152.99C186.385 1153.67 186.025 1154.36 185.684 1155.06C182.156 1162.31 178.629 1169.57 175.107 1176.81C174.961 1177.12 174.823 1177.38 174.43 1177.35C173.946 1174.24 171.577 1172.43 168.496 1172.83C167.945 1172.9 167.401 1173.1 166.866 1173.28C165.621 1173.69 164.387 1174.14 163.146 1174.55C162.935 1174.62 162.643 1174.62 162.451 1174.52C157.519 1172.14 152.599 1169.74 147.676 1167.35C147.601 1167.31 147.536 1167.26 147.434 1167.21C147.513 1167.03 147.579 1166.87 147.656 1166.71C148.974 1164.01 150.297 1161.31 151.6 1158.61C152.432 1156.88 151.974 1155.03 150.5 1154.02C149.762 1153.51 148.99 1153.37 148.154 1153.78C147.052 1154.33 145.917 1154.5 144.736 1154.07C143.221 1153.53 142.281 1152.44 142.009 1150.86C141.699 1149.1 142.285 1147.6 143.696 1146.51C146.507 1144.31 150.016 1146.21 150.408 1149.05C150.51 1149.79 150.962 1150.31 151.646 1150.62C153.256 1151.37 155.147 1150.81 156.083 1149.3C156.338 1148.89 156.532 1148.45 156.745 1148.02C157.941 1145.58 159.13 1143.13 160.319 1140.69C160.393 1140.54 160.418 1140.37 160.476 1140.15C162.155 1140.97 163.712 1141.74 165.28 1142.51C166.49 1143.09 167.705 1143.67 168.904 1144.27C169.735 1144.69 170.083 1145.46 169.873 1146.29C169.785 1146.64 169.615 1146.85 169.232 1146.95C166.143 1147.75 164.668 1150.3 164.487 1152.51C164.132 1156.84 168.137 1160.1 172.294 1158.83C175.678 1157.79 177.455 1154.01 176.19 1150.55C176.051 1150.17 175.811 1149.82 176.153 1149.4C176.515 1148.96 176.953 1148.7 177.511 1148.69C177.78 1148.68 178.08 1148.75 178.322 1148.86C181.071 1150.19 183.817 1151.53 186.563 1152.86C186.604 1152.88 186.638 1152.92 186.732 1152.99L186.73 1152.99Z"
                    fill="url(#paint5_linear_28_738)" />
                <path
                    d="M157.011 1194.02L151.077 1176.85C153.072 1175.95 155.1 1175.49 157.246 1176.22C158.943 1176.79 160.666 1177.01 162.426 1176.62C163.283 1176.43 164.107 1176.12 164.943 1175.85C166.173 1175.45 167.382 1174.97 168.632 1174.65C170.35 1174.22 172.24 1175.37 172.55 1176.93C172.589 1177.12 172.581 1177.32 172.587 1177.52C172.6 1177.9 172.434 1178.1 172.056 1178.23C170.189 1178.88 168.315 1179.5 166.483 1180.23C164.766 1180.9 163.505 1182.18 162.474 1183.67C162.21 1184.06 162.307 1184.56 162.642 1184.84C162.996 1185.14 163.519 1185.13 163.857 1184.78C164.024 1184.62 164.15 1184.43 164.287 1184.24C165.25 1182.93 166.513 1182.04 168.045 1181.51C170.619 1180.62 173.186 1179.74 175.747 1178.81C176.266 1178.62 176.738 1178.28 177.182 1177.94C181.691 1174.49 186.188 1171.03 190.689 1167.58C191.769 1166.75 193.045 1167.1 193.378 1168.33C193.538 1168.93 193.322 1169.43 192.945 1169.89C190.489 1172.85 188.041 1175.81 185.592 1178.77C183.931 1180.77 182.265 1182.76 180.623 1184.78C179.796 1185.8 178.782 1186.51 177.534 1186.93C170.878 1189.21 164.234 1191.52 157.585 1193.82L157.008 1194.02L157.011 1194.02Z"
                    fill="url(#paint6_linear_28_738)" />
                <path
                    d="M62.4251 233.406C58.6274 229.168 56.8408 224.464 57.8922 218.932C58.676 214.764 60.8325 211.432 64.2902 208.951C66.7879 207.162 69.5678 206.202 72.619 206.039C75.7092 205.874 78.5871 206.584 81.2875 208.09C83.9662 209.585 85.8582 211.858 87.6107 214.451C88.1494 214.048 88.6446 213.677 89.1398 213.306C93.2755 210.209 98.3434 210.929 101.593 214.942C105.671 219.971 109.851 224.937 113.972 229.934C117.224 233.878 120.476 237.822 123.728 241.767C125.347 243.73 126.976 245.687 128.58 247.648C131.959 251.781 131.296 257.197 127.004 260.412C116.439 268.323 105.874 276.235 95.3092 284.146C91.7643 286.801 87.3347 286.698 84.1152 283.703C82.9684 282.642 82.1348 281.239 81.2401 279.936C78.9775 276.643 76.7735 273.319 74.537 270.007C71.555 265.59 68.5729 261.173 65.5757 256.754C63.3392 253.442 61.1179 250.131 58.8379 246.851C56.2683 243.166 56.5127 238.766 59.6253 235.516C60.3839 234.718 61.4021 234.159 62.4273 233.391L62.4251 233.406ZM83.3513 217.6C80.7569 213.393 77.2807 210.779 72.1729 211.401C67.7743 211.938 64.7675 214.46 63.4047 218.67C61.9589 223.132 63.5635 226.85 66.5828 230.157L83.36 217.594L83.3513 217.6ZM69.7241 241.632C70.5823 242.76 72.2839 242.986 73.3939 242.114C74.5213 241.229 74.7334 239.557 73.8665 238.435C72.9844 237.312 71.298 237.088 70.188 237.96C69.0606 238.844 68.8529 240.487 69.7241 241.632ZM93.4369 223.807C92.5809 222.664 90.9119 222.427 89.7737 223.28C88.6355 224.132 88.4148 225.811 89.2708 226.954C90.1074 228.071 91.8284 228.323 92.9362 227.467C94.0766 226.599 94.3016 224.944 93.4369 223.807Z"
                    fill="url(#paint7_linear_28_738)" />
                <path
                    d="M207.574 591.012C214.605 591.012 221.637 591.012 228.657 591.012C230.435 591.012 232.143 591.377 233.674 592.355C235.394 593.462 236.572 594.981 237.208 596.913C239.292 603.167 241.448 609.386 243.45 615.663C246.077 623.943 241.236 631.988 232.708 633.495C228.786 634.19 225.159 633.213 221.931 630.834C221.649 630.622 221.378 630.386 221.095 630.162C219.682 629.032 218.351 629.008 216.973 630.139C213.993 632.588 210.566 633.755 206.726 633.543C203.64 633.378 200.884 632.282 198.458 630.351C196.691 628.949 195.596 628.949 193.841 630.351C188.717 634.402 181.533 634.709 176.562 631.093C171.686 627.536 169.79 621.376 171.78 615.322C173.771 609.256 175.797 603.202 177.846 597.16C179.189 593.191 182.275 591.012 186.503 591C193.534 591 200.566 591 207.586 591L207.574 591.012Z"
                    fill="url(#paint8_linear_28_738)" />
                <path
                    d="M176.197 637.971C177.94 638.43 179.53 638.949 181.144 639.255C186.185 640.221 190.896 639.231 195.266 636.616C195.925 636.216 196.385 636.228 197.021 636.616C200.213 638.572 203.722 639.537 207.444 639.561C211.319 639.584 214.971 638.572 218.292 636.534C218.775 636.239 219.128 636.181 219.658 636.499C225.524 640.115 231.684 640.621 238.103 638.148C238.327 638.065 238.539 637.983 238.88 637.853C238.904 638.159 238.951 638.407 238.951 638.654C238.951 646.451 238.974 654.26 238.951 662.057C238.939 666.356 236.312 669.725 232.296 670.655C231.578 670.82 230.824 670.902 230.094 670.914C227.679 670.95 225.265 670.903 222.862 670.938C222.143 670.938 221.943 670.726 221.955 670.019C221.99 666.474 221.979 662.929 221.955 659.384C221.943 654.755 218.115 650.915 213.487 650.903C209.553 650.903 205.631 650.903 201.697 650.903C197.068 650.915 193.228 654.755 193.216 659.372C193.216 662.917 193.193 666.462 193.216 670.007C193.216 670.691 193.051 670.961 192.321 670.938C189.412 670.855 186.491 670.938 183.582 670.738C179.978 670.502 176.692 667.157 176.362 663.577C176.268 662.516 176.209 661.445 176.209 660.373C176.197 653.224 176.209 646.074 176.209 638.937V637.971H176.197Z"
                    fill="url(#paint9_linear_28_738)" />
                <path
                    d="M199.011 670.914C199.011 667.039 198.988 663.223 199.011 659.407C199.023 657.935 200.236 656.733 201.708 656.722C205.607 656.686 209.517 656.686 213.416 656.722C214.876 656.722 216.101 657.947 216.113 659.407C216.148 663.223 216.113 667.027 216.113 670.914H198.988H199.011Z"
                    fill="url(#paint10_linear_28_738)" />
                <path
                    d="M123.324 447.264H201.685C201.144 449.169 200.616 451.035 200.089 452.889C196.729 464.55 193.357 476.212 190.023 487.873C189.779 488.722 189.47 489.044 188.53 489.031C171.154 488.993 153.777 489.006 136.388 489.031C135.577 489.031 135.217 488.838 134.985 488.015C131.188 474.731 127.352 461.448 123.53 448.165C123.452 447.895 123.401 447.598 123.324 447.264ZM190.191 455.926C189.959 455.604 189.714 454.961 189.29 454.781C188.852 454.588 188.157 454.729 187.681 454.961C187.385 455.102 187.204 455.63 187.101 456.029C185.647 461.783 184.218 467.549 182.777 473.303C182.236 475.478 181.683 477.64 181.181 479.828C180.975 480.755 181.425 481.437 182.223 481.618C183.073 481.811 183.716 481.437 184.025 480.549C184.089 480.369 184.128 480.176 184.167 479.983C185.647 474.101 187.127 468.218 188.594 462.336C189.109 460.29 189.598 458.243 190.165 455.939L190.191 455.926ZM136.607 454.588C135.127 454.613 134.638 455.514 134.998 456.956C136.556 463.186 138.1 469.428 139.67 475.658C140.082 477.293 140.481 478.94 140.932 480.562C141.189 481.463 141.897 481.836 142.721 481.63C143.506 481.437 143.905 480.807 143.789 479.918C143.751 479.661 143.686 479.404 143.635 479.159C142.76 475.632 141.884 472.106 140.996 468.579C139.954 464.396 138.911 460.2 137.868 456.016C137.662 455.18 137.251 454.588 136.607 454.588ZM157.806 480.227C157.446 475.735 157.124 471.694 156.789 467.652C156.48 463.829 156.159 460.019 155.824 456.197C155.734 455.102 155.103 454.523 154.138 454.613C153.237 454.691 152.761 455.334 152.838 456.428C152.902 457.329 152.992 458.243 153.069 459.144C153.649 466.107 154.241 473.058 154.833 480.021C154.923 481.154 155.515 481.746 156.442 481.682C157.356 481.618 157.845 480.948 157.819 480.24L157.806 480.227ZM172.042 457.471C172.132 455.463 171.9 454.897 171.154 454.652C170.047 454.292 169.223 455.038 169.107 456.428C168.747 460.869 168.361 465.297 168 469.737C167.717 473.135 167.421 476.533 167.177 479.944C167.099 481 167.678 481.669 168.567 481.708C169.455 481.746 170.047 481.141 170.137 480.099C170.356 477.602 170.549 475.105 170.768 472.62C171.218 467.369 171.656 462.13 172.055 457.484L172.042 457.471Z"
                    fill="url(#paint11_linear_28_738)" />
                <path
                    d="M162.517 435.306C177.126 435.306 191.735 435.306 206.344 435.306C209.626 435.306 211.84 438.357 210.694 441.317C209.986 443.132 208.583 444.059 206.666 444.239C206.472 444.252 206.279 444.239 206.086 444.239C177.036 444.239 147.972 444.239 118.921 444.239C117.712 444.239 116.605 443.981 115.652 443.209C114.185 442.012 113.631 440.03 114.249 438.279C114.893 436.452 116.527 435.293 118.497 435.293C130.338 435.293 142.18 435.293 154.022 435.293C156.853 435.293 159.685 435.293 162.517 435.293V435.306Z"
                    fill="url(#paint12_linear_28_738)" />
                <path
                    d="M146.029 432.32H144.935C140.25 432.32 135.564 432.307 130.879 432.333C130.21 432.333 129.837 432.127 129.489 431.548C126.747 426.94 124.431 422.152 123.555 416.823C123.246 414.957 123.195 412.987 123.452 411.121C123.89 407.877 126.027 406.629 129.232 407.465C132.295 408.263 134.805 410.065 137.173 412.073C140.468 414.866 143.21 418.162 145.656 421.714C145.836 421.972 146.016 422.293 146.016 422.589C146.042 425.769 146.029 428.961 146.029 432.307V432.32ZM133.183 428.51C133.634 428.394 133.878 428.381 134.058 428.266C136.208 426.875 138.37 425.498 140.468 424.044C141.138 423.58 141.189 422.821 140.687 422.139C140.211 421.482 139.516 421.225 138.808 421.663C136.671 423.001 134.535 424.366 132.488 425.846C132.128 426.103 131.96 426.978 132.089 427.48C132.205 427.918 132.849 428.227 133.17 428.523L133.183 428.51ZM131.651 423.259C132.038 423.194 132.192 423.207 132.282 423.143C133.801 422.165 135.358 421.225 136.813 420.144C137.366 419.732 137.315 418.96 136.89 418.367C136.478 417.788 135.835 417.467 135.191 417.853C133.724 418.728 132.269 419.655 130.905 420.697C130.57 420.955 130.442 421.791 130.596 422.242C130.75 422.692 131.355 422.988 131.639 423.259H131.651Z"
                    fill="url(#paint13_linear_28_738)" />
                <path d="M191.993 414.442V432.256H172.004V414.442H191.993Z" fill="url(#paint14_linear_28_738)" />
                <path
                    d="M168.926 432.268H149.066C149.04 431.934 149.014 431.651 149.014 431.368C149.014 426.451 149.014 421.534 149.014 416.63C149.014 414.969 149.632 414.352 151.318 414.352C156.428 414.352 161.538 414.352 166.648 414.352C168.334 414.352 168.926 414.956 168.926 416.655C168.926 421.534 168.926 426.425 168.926 431.303V432.281V432.268ZM152.979 423.632C152.979 426.901 155.682 429.604 158.938 429.617C162.22 429.643 165.001 426.863 164.975 423.593C164.962 420.272 162.233 417.595 158.9 417.634C155.605 417.672 152.953 420.35 152.966 423.632H152.979Z"
                    fill="url(#paint15_linear_28_738)" />
                <path
                    d="M202.096 432.256H195.068V431.252C195.068 425.563 195.055 419.861 195.094 414.171C195.094 413.631 195.287 413.026 195.57 412.563C196.51 411.057 197.539 409.602 198.608 408.032C199.805 409.808 200.937 411.456 202.044 413.129C202.173 413.322 202.16 413.631 202.16 413.888C202.16 419.783 202.16 425.666 202.16 431.561C202.16 431.78 202.109 431.998 202.083 432.269L202.096 432.256Z"
                    fill="url(#paint16_linear_28_738)" />
                <path
                    d="M195.738 406.925C194.773 408.341 193.872 409.705 192.932 411.056C192.829 411.211 192.546 411.314 192.353 411.314C186.084 411.327 179.803 411.314 173.303 411.314C174.333 409.782 175.26 408.392 176.212 407.028C176.328 406.873 176.676 406.809 176.907 406.809C183.06 406.809 189.199 406.809 195.352 406.809C195.442 406.809 195.519 406.86 195.738 406.925Z"
                    fill="url(#paint17_linear_28_738)" />
                <path d="M192.494 400V403.784H181.682V400H192.494Z" fill="url(#paint18_linear_28_738)" />
                <path d="M154.897 411.262V408.173H163.032V411.262H154.897Z" fill="url(#paint19_linear_28_738)" />
                <path
                    d="M156.004 423.632C155.992 421.959 157.266 420.659 158.926 420.646C160.6 420.646 161.912 421.894 161.964 423.542C162.003 425.202 160.638 426.618 158.978 426.631C157.382 426.631 156.017 425.266 156.004 423.632Z"
                    fill="url(#paint20_linear_28_738)" />
                <path
                    d="M292 262.524C291.495 261.388 290.63 260.983 289.386 261.001C285.402 261.055 281.41 261.019 277.417 261.019C273.992 261.019 271.423 263.587 271.189 266.994C271.009 269.644 270.621 272.285 270.333 274.935C270.242 275.746 270.152 276.557 270.053 277.422H269.134C254.253 277.422 239.364 277.44 224.484 277.395C222.663 277.395 221.771 278.675 222.05 280.288C223.141 286.426 224.114 292.582 225.142 298.72C225.295 299.639 225.421 300.568 225.646 301.469C226.349 304.29 228.72 306.128 231.622 306.128C243.997 306.128 256.372 306.128 268.755 306.128C269.747 306.128 270.558 306.408 271.009 307.345C271.621 308.625 270.738 310.085 269.278 310.229C269.026 310.256 268.773 310.238 268.53 310.238C257.814 310.238 247.106 310.238 236.39 310.238C232.866 310.238 230.171 312.978 230.198 316.502C230.216 319.549 232.622 322.208 235.66 322.523C238.778 322.857 241.771 320.766 242.329 317.719C242.528 316.656 242.356 315.52 242.356 314.375H255.11C254.425 316.809 254.857 318.981 256.66 320.784C257.976 322.09 259.598 322.631 261.446 322.532C264.33 322.37 268.178 319.378 266.827 314.33C267.593 314.33 268.332 314.33 269.08 314.33C272 314.321 274.488 312.402 275.146 309.662C275.812 306.886 274.569 304.101 272 302.749C271.558 302.514 271.423 302.271 271.477 301.802C271.829 298.747 272.171 295.701 272.514 292.645C272.856 289.59 273.19 286.534 273.532 283.488C273.875 280.387 274.226 277.287 274.569 274.196C274.821 271.915 275.091 269.626 275.308 267.337C275.443 265.904 276.245 265.101 277.696 265.101C281.59 265.101 285.492 265.065 289.386 265.12C290.63 265.138 291.495 264.732 292 263.596V262.506V262.524ZM263.005 291.807C263.005 293.078 263.005 294.358 263.005 295.628C263.005 296.989 262.131 297.954 260.941 297.945C259.769 297.936 258.904 296.98 258.904 295.673C258.904 293.078 258.895 290.482 258.904 287.886C258.904 286.579 259.796 285.633 260.968 285.642C262.14 285.651 262.996 286.606 263.005 287.913C263.005 289.211 263.005 290.509 263.005 291.807ZM246.592 291.825C246.592 290.527 246.592 289.229 246.592 287.931C246.592 286.579 247.494 285.615 248.683 285.642C249.855 285.669 250.693 286.615 250.702 287.94C250.702 290.509 250.702 293.087 250.702 295.655C250.702 296.98 249.855 297.927 248.683 297.954C247.494 297.981 246.601 297.007 246.601 295.655C246.601 294.385 246.601 293.105 246.601 291.834L246.592 291.825ZM238.391 291.726C238.391 293.042 238.391 294.367 238.391 295.682C238.382 296.989 237.507 297.945 236.336 297.945C235.164 297.945 234.29 296.989 234.29 295.682C234.29 293.087 234.281 290.491 234.29 287.895C234.29 286.588 235.173 285.633 236.345 285.633C237.516 285.633 238.382 286.588 238.391 287.895C238.391 289.166 238.391 290.446 238.391 291.717V291.726Z"
                    fill="url(#paint21_linear_28_738)" />
                <path
                    d="M246.593 273.267C246.593 269.779 246.611 266.336 246.584 262.902C246.584 261.812 245.646 261.019 244.475 261.019C240.302 261.019 236.138 261.019 231.965 261.019C230.667 261.019 229.369 261.001 228.071 261.019C227.008 261.037 226.106 261.866 226.106 262.902C226.079 266.336 226.097 269.779 226.097 273.267H246.602H246.593Z"
                    fill="url(#paint22_linear_28_738)" />
                <path
                    d="M263.005 273.267C263.005 271.14 263.023 269.067 263.005 267.003C262.996 266.048 262.176 265.156 261.23 265.147C257.751 265.111 254.263 265.129 250.748 265.129V273.267H263.014H263.005Z"
                    fill="url(#paint23_linear_28_738)" />
                <path
                    d="M13.0455 561.155C15.8171 549.48 25.9828 544.5 34.8062 546.091C36.1148 546.332 37.4124 546.71 38.6784 547.14C41.6749 548.168 44.6428 549.276 47.6229 550.349C49.504 551.027 49.7757 552.085 48.427 553.519C47.1675 554.883 45.8709 556.208 44.6527 557.6C41.7312 560.913 42.291 566.005 46.2655 567.872C50.338 569.787 54.6802 571.415 59.0746 572.294C64.4658 573.391 69.2404 569.375 70.4993 563.748C71.4809 559.352 72.6253 555.002 73.7017 550.628C74.0056 549.393 74.3095 548.158 74.6275 546.814C75.636 547.177 76.5743 547.451 77.4368 547.864C77.6552 547.968 77.768 548.508 77.7598 548.851C77.5095 554.521 77.2212 560.191 76.9441 565.865C76.8632 567.653 76.7708 569.438 76.688 571.303C76.402 571.315 76.1427 571.324 75.8834 571.333C71.5931 571.516 68.0241 573.072 65.5739 576.747C64.5937 578.224 64.2031 579.735 65.492 581.275C65.5994 581.403 65.5839 581.73 65.5073 581.908C65.3345 582.281 65.0825 582.625 64.8091 583.064L63.9592 582.758C55.1094 579.57 46.2482 576.379 37.3984 573.191C36.8771 573.003 36.5771 572.806 36.4897 572.16C36.2185 570.283 35.0901 569.044 33.2997 568.399C26.8861 566.089 20.4612 563.775 14.0477 561.465L13.0505 561.106L13.0455 561.155ZM28.3454 560.047C26.4531 559.366 24.5607 558.684 22.6797 558.007C21.6032 557.619 20.7265 557.956 20.4154 558.855C20.1247 559.698 20.5656 560.535 21.5968 560.907C25.3434 562.269 29.0941 563.62 32.8488 564.96C33.88 565.331 34.7381 564.974 35.0483 564.113C35.3748 563.207 34.9403 562.423 33.8411 562.027C32.0054 561.366 30.1811 560.709 28.3454 560.047ZM30.7858 557.573C32.2136 558.087 33.6332 558.624 35.0804 559.119C36.0631 559.448 36.88 559.063 37.1707 558.221C37.4768 557.371 37.069 556.584 36.0945 556.233C33.2616 555.213 30.441 554.158 27.5991 553.199C27.1345 553.031 26.4124 553.117 25.9985 553.377C24.9613 554.054 25.2539 555.516 26.5139 556.034C27.9212 556.605 29.3653 557.074 30.7931 557.588L30.7858 557.573Z"
                    fill="url(#paint24_linear_28_738)" />
                <path
                    d="M40.4522 544.489C40.1308 544.386 39.8126 544.31 39.5067 544.199C31.7447 541.404 23.9827 538.608 16.2207 535.812C14.453 535.175 14.2033 534.624 14.84 532.857C16.9256 527.066 19.0072 521.287 21.0928 515.497L21.4438 514.522L25.8858 516.122C25.7103 516.61 25.5162 517.077 25.3674 517.562C25.1157 518.367 25.4628 519.145 26.1789 519.467C26.8724 519.781 27.7287 519.5 28.1236 518.759C28.3866 518.278 28.559 517.764 28.8052 517.187L40.5105 521.403C40.3881 521.743 40.2452 522.14 40.1064 522.525C39.7536 523.575 40.1084 524.51 40.9777 524.797C41.8244 525.077 42.6472 524.605 43.0218 523.6C43.1524 523.238 43.2871 522.864 43.4381 522.445L47.812 524.02L40.4408 544.485L40.4522 544.489Z"
                    fill="url(#paint25_linear_28_738)" />
                <path
                    d="M84.7288 592.197C82.6583 596.88 77.7715 599.216 73.0757 597.716C67.2232 595.839 64.7282 588.834 68.0639 583.66C68.4674 583.037 68.8228 582.833 69.6006 583.126C74.5361 584.954 79.4879 586.738 84.4561 588.476C85.1926 588.742 85.3934 589.108 85.2319 589.806C85.0491 590.597 84.9003 591.401 84.7247 592.209L84.7288 592.197Z"
                    fill="url(#paint26_linear_28_738)" />
                <path
                    d="M16.4303 565.69L17.3255 566.012C22.2207 567.775 27.1159 569.538 32.011 571.302C33.4388 571.816 33.8085 572.602 33.2158 573.963C31.1027 578.835 25.5958 580.973 20.7347 578.902C16.3939 577.057 14.0591 571.633 15.7842 567.057C15.9474 566.604 16.1973 566.195 16.4417 565.694L16.4303 565.69Z"
                    fill="url(#paint27_linear_28_738)" />
                <path
                    d="M88.322 586.592L67.8008 579.2C68.4012 577.675 69.4888 576.646 70.8139 575.882C73.3367 574.422 76.0098 574.002 78.795 574.942C80.5977 575.552 82.4927 576.12 84.0918 577.118C87.2105 579.086 88.84 581.99 88.5007 585.811C88.4798 586.047 88.3982 586.274 88.322 586.592Z"
                    fill="url(#paint28_linear_28_738)" />
                <path
                    d="M22.5463 511.463C22.9055 510.466 23.2216 509.518 23.583 508.585C23.8996 507.777 24.6589 507.411 25.4961 507.61C25.7308 507.669 25.9493 507.773 26.1873 507.859C33.598 510.528 41.0201 513.202 48.4308 515.871C50.0965 516.471 50.3825 517.099 49.7856 518.791C49.5285 519.505 49.2714 520.219 48.9857 521.012L22.5382 511.486L22.5463 511.463Z"
                    fill="url(#paint29_linear_28_738)" />
                <path
                    d="M84.967 540.642L82.8773 546.444C82.6085 546.372 82.3697 546.325 82.1544 546.247C79.5255 545.3 76.8812 544.361 74.2564 543.402C72.432 542.745 71.5625 541.037 72.1552 539.356C72.7561 537.652 74.5535 536.891 76.4118 537.56C79.2447 538.581 82.0662 539.597 84.967 540.642Z"
                    fill="url(#paint30_linear_28_738)" />
                <path
                    d="M43.4206 545.596C43.8247 544.474 44.1376 543.499 44.5226 542.537C44.8659 541.726 45.5482 541.396 46.3794 541.682C48.1934 542.297 49.9951 542.946 51.7804 543.64C52.8447 544.062 53.3567 545.271 53.0564 546.353C52.7357 547.492 51.6391 548.262 50.4756 548.009C49.5015 547.799 48.5619 547.422 47.6173 547.095C46.2421 546.612 44.8751 546.107 43.4134 545.581L43.4206 545.596Z"
                    fill="url(#paint31_linear_28_738)" />
                <path
                    d="M256.215 1071.04C250.678 1071.57 245.854 1069.42 241.198 1066.85C234.933 1063.38 229.449 1058.95 224.899 1053.38C215.57 1041.94 218.908 1025.19 230.932 1017.67C242.182 1010.63 257.268 1013.98 264.342 1025.2C264.453 1025.38 264.619 1025.54 264.754 1025.71L267.302 1031.82C267.483 1032.96 267.71 1034.09 267.841 1035.24C268.754 1043 267.841 1050.59 265.521 1058.02C264.077 1062.63 262.256 1067.08 258.249 1070.2L256.211 1071.05L256.215 1071.04ZM235.217 1041.85C237.192 1046.59 242.674 1048.88 247.417 1046.92C252.141 1044.96 254.435 1039.44 252.481 1034.7C250.531 1029.98 245.004 1027.69 240.269 1029.65C235.533 1031.6 233.255 1037.12 235.228 1041.85L235.217 1041.85Z"
                    fill="url(#paint32_linear_28_738)" />
                <path
                    d="M184.236 1006.79C184.401 1007.18 184.53 1007.49 184.656 1007.8C186.942 1013.28 189.228 1018.77 191.521 1024.26C192.154 1025.78 193.157 1026.46 194.52 1026.13C195.122 1025.98 195.733 1025.52 196.161 1025.05C198.039 1022.94 199.87 1020.78 201.688 1018.61C202.016 1018.22 202.326 1018.09 202.835 1018.14C205.624 1018.37 208.411 1018.57 211.202 1018.76C213.712 1018.94 214.951 1017.24 213.987 1014.9C211.727 1009.43 209.438 1003.98 207.162 998.514C207.023 998.181 206.884 997.847 206.723 997.46C207.019 997.318 207.234 997.201 207.466 997.104C212.459 995.025 217.451 992.946 222.444 990.867C223.979 990.227 225.36 990.771 225.993 992.29C228.476 998.252 230.956 1004.21 233.438 1010.17C233.493 1010.3 233.529 1010.43 233.609 1010.64C223.779 1014.74 217.31 1021.83 215.11 1032.32C212.905 1042.82 216.132 1051.83 223.612 1059.57L222.659 1059.97C212.883 1064.04 203.108 1068.11 193.332 1072.18C191.433 1072.97 190.192 1072.46 189.404 1070.57C181.982 1052.75 174.556 1034.92 167.133 1017.1C166.365 1015.25 166.884 1014.01 168.736 1013.23C173.597 1011.21 178.458 1009.19 183.318 1007.16C183.597 1007.05 183.876 1006.93 184.233 1006.78L184.236 1006.79Z"
                    fill="url(#paint33_linear_28_738)" />
                <path
                    d="M207.815 1013.41C207.485 1013.4 207.213 1013.4 206.951 1013.38C205.149 1013.25 203.346 1013.14 201.546 1012.99C200.472 1012.9 199.624 1013.24 198.934 1014.08C197.773 1015.46 196.594 1016.82 195.416 1018.19C195.239 1018.4 195.045 1018.59 194.798 1018.85L188.98 1004.88L202.011 999.449L207.823 1013.4L207.815 1013.41Z"
                    fill="url(#paint34_linear_28_738)" />
                <path
                    d="M239.903 1039.89C238.994 1037.68 240.008 1035.27 242.228 1034.35C244.414 1033.44 246.873 1034.47 247.778 1036.67C248.678 1038.85 247.65 1041.3 245.438 1042.21C243.244 1043.13 240.808 1042.1 239.903 1039.89Z"
                    fill="url(#paint35_linear_28_738)" />
                <path
                    d="M262.225 870.569C261.71 867.189 262.741 864.329 265.184 861.984C268.428 858.873 273.708 858.591 277.355 861.307C277.665 861.537 277.891 861.433 278.149 861.292C279.732 860.408 281.312 859.52 282.896 858.628C284.105 857.95 285.298 857.247 286.519 856.597C287.492 856.082 288.536 856.083 289.597 856.276C296.858 857.591 304.122 858.891 311.384 860.198C311.766 860.269 312.155 860.328 312.541 860.404C313.483 860.584 313.767 860.998 313.589 861.932C312.546 867.361 311.503 872.781 310.456 878.205C310.238 879.333 310.022 880.467 309.796 881.594C309.628 882.405 309.178 882.722 308.367 882.575C300.626 881.183 292.881 879.786 285.14 878.394C283.884 878.169 282.912 877.545 282.147 876.526C281.507 875.668 280.798 874.857 280.119 874.025C280.035 873.924 279.926 873.839 279.793 873.72C278.876 875.14 277.747 876.284 276.216 877.168C276.092 876.47 275.95 875.872 275.895 875.265C275.883 875.099 276.097 874.894 276.234 874.734C276.884 873.97 277.548 873.216 278.199 872.443C278.426 872.172 278.398 871.93 278.135 871.632C277.263 870.636 276.428 869.599 275.592 868.571C274.388 867.092 274.356 864.743 275.505 863.164C275.605 863.024 275.707 862.888 275.81 862.752C274.053 861.175 270.579 860.993 267.992 862.326C265.421 863.649 263.744 866.772 264.077 869.675C264.264 869.641 264.449 869.615 264.631 869.563C268.808 868.53 273.078 870.326 275.168 874.089C275.887 875.379 275.927 875.068 274.618 875.728C273.561 876.258 272.394 876.428 271.207 876.387C270.643 876.369 270.242 876.672 270.125 877.188C270.058 877.481 270.155 877.907 270.347 878.123C270.532 878.33 270.928 878.42 271.238 878.439C272.849 878.515 274.327 878.146 276.124 877.267C276.166 877.413 276.226 877.553 276.243 877.694C276.574 880.88 275.875 883.738 273.555 886.071C273.254 886.371 273.282 886.656 273.403 887.023C275.46 893.23 277.494 899.446 279.556 905.65C279.743 906.217 279.722 906.674 279.453 907.199C278.942 908.188 278.495 909.205 278.025 910.21C277.707 910.877 277.547 910.929 276.893 910.61C275.883 910.121 274.867 909.644 273.852 909.159C273.764 909.031 273.677 908.902 273.589 908.774C273.84 908.211 274.064 907.629 274.355 907.081C274.613 906.592 274.507 906.288 274.029 906.036C273.563 905.791 273.128 905.495 272.662 905.249C272.195 905.012 272.131 904.686 272.33 904.237C272.564 903.722 272.757 903.19 272.987 902.67C273.164 902.273 273.064 902.001 272.69 901.794C272.18 901.505 271.684 901.194 271.173 900.914C270.79 900.705 270.705 900.423 270.862 900.04C271.076 899.516 271.258 898.978 271.511 898.471C271.779 897.932 271.609 897.599 271.122 897.324C270.578 897.016 270.069 896.655 269.523 896.356C269.085 896.12 268.834 895.785 268.668 895.311C267.925 893.183 267.132 891.066 266.388 888.938C266.245 888.529 266.029 888.351 265.614 888.295C261.634 887.757 258.999 885.513 257.804 881.745C256.615 877.994 257.571 874.656 260.348 871.879C260.891 871.34 261.608 870.979 262.245 870.534C262.447 871.178 262.63 871.835 262.86 872.475C262.984 872.825 263.009 873.083 262.773 873.426C261.829 874.807 262.021 876.502 263.199 877.701C264.272 878.799 266.078 879.023 267.405 878.221C268.925 877.309 269.555 875.702 269.016 874.114C268.51 872.627 266.983 871.66 265.392 871.824C265.187 871.842 264.979 871.876 264.732 871.908L264.171 870.024L262.235 870.562L262.225 870.569ZM301.063 873.974C301.232 873.67 301.42 873.468 301.471 873.237C301.922 870.999 302.352 868.754 302.764 866.513C302.857 866.015 302.636 865.63 302.135 865.459C301.654 865.297 301.238 865.43 300.953 865.85C300.84 866.022 300.798 866.247 300.759 866.454C300.364 868.487 299.974 870.517 299.587 872.551C299.554 872.726 299.469 872.929 299.534 873.066C299.668 873.366 299.818 873.733 300.074 873.884C300.33 874.035 300.723 873.953 301.063 873.974ZM293.389 864.018C293.228 864.418 293.063 864.705 292.998 865.011C292.588 867.076 292.198 869.148 291.805 871.216C291.666 871.964 291.933 872.469 292.522 872.587C293.127 872.708 293.586 872.321 293.736 871.558C293.941 870.526 294.138 869.492 294.334 868.458C294.538 867.383 294.746 866.312 294.945 865.24C295.032 864.775 294.936 864.34 294.486 864.149C294.179 864.019 293.802 864.06 293.387 864.026L293.389 864.018Z"
                    fill="url(#paint36_linear_28_738)" />
                <path
                    d="M264.743 874.068C265.413 873.608 266.394 873.79 266.871 874.463C267.317 875.092 267.128 876.085 266.474 876.548C265.812 877.009 264.792 876.832 264.326 876.174C263.842 875.491 264.024 874.562 264.738 874.071L264.743 874.068Z"
                    fill="url(#paint37_linear_28_738)" />
                <g opacity="0.3">
                    <path
                        d="M248.281 100.98C252.645 100.88 256.815 102.997 260.051 105.927C263.272 108.857 265.693 112.559 268.012 116.244C273.123 124.343 277.744 131.844 281.922 140.428C283.646 143.971 285.293 148.532 286.621 152.242C287.05 153.43 287.449 154.661 287.388 155.92C287.328 157.178 286.713 158.485 285.581 159.032C284.317 159.649 282.731 159.161 281.671 158.223C280.618 157.293 279.958 155.999 279.312 154.749C273.852 144.254 266.592 134.235 256.356 128.297C253.496 126.634 250.448 125.324 247.58 123.697C244.705 122.063 241.954 120.067 240.068 117.351C238.182 114.636 237.259 111.108 238.229 107.944C239.51 103.78 243.931 101.066 248.296 100.966L248.281 100.98Z"
                        fill="url(#paint38_linear_28_738)" />
                    <path
                        d="M464.624 140.626C463.303 125.788 454.264 111.679 440.984 104.927C430.539 99.6039 418.448 98.9112 406.86 97.0772C389.774 94.3755 373.119 88.9872 357.689 81.1603C343.342 73.8925 329.759 55.0958 313.84 52.7437C303.396 51.1933 292.312 53.0758 283.492 58.8824C272.444 66.1476 265.936 81.3487 265.859 91.9002C265.7 113.309 289.892 134.912 293.621 155.993C296.64 173.069 287.463 186.48 288.817 203.773C289.949 218.207 299.564 231.547 312.711 237.583C325.859 243.62 342.016 242.298 354.252 234.575C362.884 229.122 369.397 220.963 376.948 214.091L377.074 213.97C384.077 207.641 392.694 203.345 401.935 201.465C404.575 200.924 407.2 200.355 409.812 199.741C424.078 196.352 438.387 191.049 448.994 180.935C459.779 170.65 465.922 155.471 464.602 140.633L464.624 140.626Z"
                        fill="url(#paint39_linear_28_738)" />
                </g>
            </g>
            <defs>
                <linearGradient id="paint0_linear_28_738" x1="335.695" y1="596.025" x2="339.204"
                    y2="566.937" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_738" x1="246.492" y1="760.202" x2="252.747"
                    y2="708.351" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint2_linear_28_738" x1="140.076" y1="601.021" x2="144.957"
                    y2="560.561" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint3_linear_28_738" x1="234.044" y1="757.929" x2="263.495"
                    y2="513.798" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint4_linear_28_738" x1="145.729" y1="1176.71" x2="152.567"
                    y2="1196.5" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint5_linear_28_738" x1="160.221" y1="1140.24" x2="173.208"
                    y2="1177.83" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint6_linear_28_738" x1="171.269" y1="1169.81" x2="177.223"
                    y2="1187.04" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint7_linear_28_738" x1="63.96" y1="209.194" x2="111.185"
                    y2="272.258" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint8_linear_28_738" x1="207.582" y1="591" x2="207.582"
                    y2="633.714" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint9_linear_28_738" x1="207.579" y1="636.285" x2="207.579"
                    y2="670.939" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint10_linear_28_738" x1="207.558" y1="656.695" x2="207.558"
                    y2="670.914" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint11_linear_28_738" x1="162.504" y1="447.264" x2="162.504"
                    y2="489.032" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint12_linear_28_738" x1="162.5" y1="435.293" x2="162.5"
                    y2="444.245" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint13_linear_28_738" x1="134.66" y1="407.213" x2="134.66"
                    y2="432.333" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint14_linear_28_738" x1="181.998" y1="414.442" x2="181.998"
                    y2="432.256" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint15_linear_28_738" x1="158.97" y1="414.352" x2="158.97"
                    y2="432.281" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint16_linear_28_738" x1="198.613" y1="408.032" x2="198.613"
                    y2="432.269" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint17_linear_28_738" x1="184.521" y1="406.809" x2="184.521"
                    y2="411.32" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint18_linear_28_738" x1="187.088" y1="400" x2="187.088"
                    y2="403.784" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint19_linear_28_738" x1="158.964" y1="408.173" x2="158.964"
                    y2="411.262" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint20_linear_28_738" x1="158.985" y1="420.646" x2="158.985"
                    y2="426.631" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint21_linear_28_738" x1="257" y1="261" x2="257"
                    y2="322.558" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint22_linear_28_738" x1="236.347" y1="261.011" x2="236.347"
                    y2="273.267" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint23_linear_28_738" x1="256.881" y1="265.124" x2="256.881"
                    y2="273.267" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint24_linear_28_738" x1="54.4097" y1="539.512" x2="41.7181"
                    y2="574.747" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint25_linear_28_738" x1="34.6336" y1="519.273" x2="27.2461"
                    y2="539.783" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint26_linear_28_738" x1="77.0332" y1="585.802" x2="72.7781"
                    y2="597.616" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint27_linear_28_738" x1="25.1143" y1="568.818" x2="21.3905"
                    y2="579.156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint28_linear_28_738" x1="80.6957" y1="575.583" x2="78.0614"
                    y2="582.896" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint29_linear_28_738" x1="37.336" y1="511.863" x2="35.7569"
                    y2="516.247" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint30_linear_28_738" x1="79.0917" y1="538.526" x2="76.9797"
                    y2="544.389" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint31_linear_28_738" x1="49.3977" y1="542.742" x2="47.8013"
                    y2="547.174" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint32_linear_28_738" x1="234.42" y1="1015.86" x2="257.227"
                    y2="1070.62" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint33_linear_28_738" x1="195.481" y1="1002.1" x2="220.039"
                    y2="1061.06" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint34_linear_28_738" x1="195.496" y1="1002.16" x2="201.314"
                    y2="1016.13" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint35_linear_28_738" x1="242.209" y1="1034.36" x2="245.473"
                    y2="1042.2" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint36_linear_28_738" x1="273.731" y1="855.976" x2="300.543"
                    y2="895.036" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint37_linear_28_738" x1="264.741" y1="874.07" x2="266.452"
                    y2="876.563" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint38_linear_28_738" x1="274.423" y1="120.768" x2="258.164"
                    y2="136.425" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint39_linear_28_738" x1="413.949" y1="73.6075" x2="277.487"
                    y2="205.016" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 2 -->
        <svg class="e-shape-2" width="428" height="1099" viewBox="0 0 428 1099" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g opacity="0.19">
                <path
                    d="M107.949 872.983C133.798 879.164 142.061 835.876 129.39 812.949C116.72 789.998 30.0039 793.046 54.4198 825.342C78.8357 857.637 100.233 871.125 108.025 872.986L107.949 872.983Z"
                    fill="url(#paint0_linear_28_690)" />
                <path
                    d="M151.662 852.461L151.354 853.568C147.766 866.472 144.174 879.388 140.611 892.298C140.399 893.061 140.059 893.377 139.29 893.521C124.559 896.409 109.834 899.324 95.1122 902.227C94.7759 902.293 94.4308 902.343 93.9421 902.432L94.2191 901.436C97.8244 888.471 101.433 875.493 105.038 862.528C105.209 861.913 105.414 861.559 106.114 861.423C120.969 858.517 135.835 855.574 150.685 852.64C150.965 852.585 151.238 852.555 151.655 852.486L151.662 852.461Z"
                    fill="url(#paint1_linear_28_690)" />
                <path
                    d="M91.6613 901.771C90.95 901.136 90.3146 900.562 89.6791 899.988C78.8993 890.192 68.1318 880.399 57.3486 870.616C56.9372 870.236 56.7159 869.936 56.8869 869.321C60.5681 856.178 64.2157 843.013 67.8723 829.864C67.9202 829.691 67.9961 829.514 68.087 829.234C68.387 829.49 68.6391 829.679 68.8598 829.886C72.6478 833.325 76.4324 836.776 80.2396 840.194C80.739 840.637 80.8715 841.019 80.6779 841.667C79.413 846.073 78.2097 850.496 76.9817 854.912L76.6568 856.08C77.9114 856.429 79.0896 856.863 80.3046 857.068C82.0131 857.358 83.075 858.21 83.814 859.793C84.6883 861.653 85.8073 863.396 86.9118 865.333L91.1054 850.252C91.3555 850.401 91.5209 850.473 91.6357 850.585C95.2665 853.874 98.8885 857.147 102.497 860.47C102.751 860.699 102.937 861.268 102.848 861.588C99.2117 874.809 95.5223 888.029 91.8487 901.24C91.8076 901.388 91.742 901.529 91.649 901.768L91.6613 901.771Z"
                    fill="url(#paint2_linear_28_690)" />
                <path
                    d="M150.947 850.221C145.227 851.347 139.675 852.441 134.107 853.543C124.657 855.407 115.207 857.272 105.762 859.164C104.974 859.33 104.476 859.165 103.899 858.62C100.515 855.492 97.0925 852.407 93.6891 849.301C93.4773 849.109 93.2812 848.909 92.9546 848.606C94.7214 848.209 96.3638 847.831 98.0028 847.465C111.087 844.544 124.183 841.626 137.261 838.676C137.896 838.535 138.327 838.655 138.786 839.1C142.61 842.602 146.452 846.082 150.292 849.575C150.482 849.747 150.641 849.937 150.943 850.233L150.947 850.221Z"
                    fill="url(#paint3_linear_28_690)" />
                <path
                    d="M69.8291 827.638C71.3177 827.337 72.6976 827.044 74.0864 826.768C87.7715 824.067 101.457 821.366 115.148 818.64C115.809 818.505 116.262 818.591 116.779 819.067C120.396 822.405 124.052 825.701 127.797 829.101C127.488 829.214 127.266 829.298 127.038 829.354C112.511 832.603 97.9937 835.868 83.4617 839.089C83.1063 839.175 82.5555 839.155 82.3259 838.932C78.1799 835.208 74.0687 831.454 69.8359 827.614L69.8291 827.638Z"
                    fill="url(#paint4_linear_28_690)" />
                <path
                    d="M57.4236 103.09C46.5997 103.09 35.7757 103.059 24.9517 103.12C23.2825 103.12 21.9308 102.014 22.0025 100.14C22.1151 97.3754 22.0332 94.6003 22.0332 91.8252C22.0332 87.9339 23.3337 84.5239 25.9041 81.6156C28.1262 79.0965 30.42 76.6184 32.6831 74.13C33.9939 72.6963 35.6118 72 37.5677 72C51.1873 72.0102 64.8069 72.0102 78.4367 72C80.5154 72 82.2153 72.7578 83.5158 74.3655C85.6151 76.9665 87.7348 79.5471 89.7727 82.1891C91.8617 84.8925 92.8755 87.9953 92.8755 91.4258C92.8755 94.4262 92.8755 97.4368 92.8755 100.437C92.8755 102.086 91.8719 103.079 90.2027 103.079C79.2764 103.079 68.35 103.079 57.4134 103.079L57.4236 103.09ZM48.1357 100.591C48.1357 100.243 48.1357 99.9662 48.1357 99.6897C48.1357 96.6381 48.1357 93.5865 48.1357 90.5349C48.1357 90.0434 48.1664 89.5519 48.2278 89.0706C48.617 85.7834 49.6513 82.6806 50.8596 79.629C51.5355 77.9291 52.2727 76.26 53.0203 74.4986C51.4433 74.4986 49.9175 74.4884 48.4019 74.5191C48.2278 74.5191 48.0128 74.7444 47.9104 74.9185C45.2991 79.2296 43.6402 83.8787 43.333 88.9169C43.1077 92.6854 43.1999 96.464 43.1589 100.243C43.1589 100.366 43.2101 100.478 43.2408 100.601H48.1357V100.591ZM63.1684 74.4986C64.1105 76.8129 65.0629 79.0146 65.9128 81.2572C67.3567 85.0564 68.2476 88.9477 68.0428 93.0643C67.9301 95.3069 68.0223 97.5597 68.0223 99.8126C68.0223 100.058 68.0428 100.314 68.053 100.56H72.9991C72.9991 98.9012 72.9991 97.3037 72.9991 95.7062C72.9991 92.6342 73.0913 89.5518 72.5588 86.5002C71.8419 82.3836 70.439 78.5333 68.2681 74.9595C68.1452 74.7546 67.8585 74.5294 67.6434 74.5294C66.1688 74.4884 64.6942 74.5089 63.1787 74.5089L63.1684 74.4986Z"
                    fill="url(#paint5_linear_28_690)" />
                <path
                    d="M28.249 106.848H87.9089V107.667C87.9089 115.613 87.9089 123.56 87.9089 131.517C87.9089 135.93 84.6832 139.146 80.2594 139.146C75.8049 139.146 71.3606 139.146 66.7832 139.146C66.7832 138.849 66.7832 138.572 66.7832 138.306C66.7832 134.087 66.8037 129.868 66.7832 125.649C66.7525 121.512 64.1207 118.061 60.3113 117.088C54.6894 115.654 49.4362 119.751 49.385 125.639C49.3543 129.837 49.385 134.026 49.385 138.224C49.385 138.501 49.385 138.787 49.385 139.115C49.0778 139.125 48.8217 139.156 48.576 139.156C44.3263 139.156 40.0868 139.156 35.8371 139.156C31.5259 139.156 28.2593 135.91 28.2593 131.609C28.2593 123.611 28.2593 115.613 28.2593 107.606V106.858L28.249 106.848Z"
                    fill="url(#paint6_linear_28_690)" />
                <path
                    d="M117.649 307.678C110.337 304.947 103.021 302.228 95.7141 299.486C90.7932 297.635 88.0863 293.155 88.7256 288.036C88.9464 286.297 89.6566 284.754 90.6445 283.328C91.3686 282.286 92.0574 281.23 92.7889 280.204C94.0466 278.45 94.6564 276.495 94.7372 274.342C95.2236 260.486 95.7217 246.635 96.2199 232.784C96.2835 230.999 95.6728 230.088 93.9963 229.449C91.9157 228.672 89.8351 227.895 87.7544 227.118C85.568 226.301 84.4797 224.086 85.2097 221.988C85.988 219.761 88.2555 218.639 90.4977 219.449C94.2842 220.823 98.0575 222.232 101.818 223.677C103.659 224.378 104.586 225.876 104.529 227.93C104.419 231.667 104.274 235.39 104.153 239.122C104.078 241.331 104.557 242.059 106.625 242.831C126.538 250.268 146.451 257.704 166.376 265.145C167.057 265.4 167.763 265.663 168.323 266.1C170.225 267.534 170.421 270.058 168.813 272.069C165.331 276.408 161.821 280.749 158.327 285.084C154.842 289.394 151.361 293.693 147.888 298.008C146.227 300.054 144.791 300.455 142.287 299.52C129.145 294.612 116.015 289.708 102.873 284.801C100.745 284.006 99.9055 284.282 98.6156 286.157C98.0924 286.913 97.55 287.648 97.0458 288.424C96.3189 289.546 96.6644 290.88 97.8328 291.518C98.2458 291.739 98.7042 291.91 99.1392 292.072C113.762 297.533 128.385 302.994 143.008 308.456C143.631 308.688 144.266 308.925 144.813 309.29C146.406 310.367 146.922 312.502 146.096 314.283C145.266 316.076 143.367 317.001 141.451 316.5C141.022 316.393 140.599 316.235 140.187 316.081C132.664 313.272 125.153 310.467 117.63 307.657L117.649 307.678Z"
                    fill="url(#paint7_linear_28_690)" />
                <path
                    d="M90.2811 301.77C94.5086 303.469 96.5549 308.212 94.8349 312.351C93.0534 316.655 88.4636 318.544 84.0598 316.779C79.9807 315.148 78.1149 310.353 79.8728 306.04C81.458 302.118 86.2651 300.15 90.2811 301.77Z"
                    fill="url(#paint8_linear_28_690)" />
                <path
                    d="M140.585 329.182C139.067 333.357 134.418 335.545 130.291 334.044C125.976 332.473 123.758 327.867 125.301 323.662C126.893 319.327 131.533 317.162 135.8 318.756C139.996 320.323 142.114 324.945 140.578 329.166L140.585 329.182Z"
                    fill="url(#paint9_linear_28_690)" />
                <path
                    d="M285.822 57.9025C289.578 61.3222 293.233 64.6505 296.888 67.9788C299.833 70.6597 300.525 74.6211 298.463 77.9771C297.813 79.0276 296.839 79.9965 295.793 80.6572C287.646 85.7575 279.446 90.7804 271.255 95.8108C268.039 97.7804 264.331 97.4164 261.546 94.8802C250.003 84.3698 238.452 73.8518 226.909 63.3415C224.157 60.8357 223.423 57.1555 225.055 53.8345C229.319 45.1524 233.583 36.4703 237.897 27.818C240.279 23.0348 246.368 21.9928 250.34 25.5946C253.853 28.7934 257.358 31.9846 260.871 35.1834L261.465 35.7241C261.7 35.4663 261.897 35.2501 262.101 35.0256C264.38 32.5223 266.66 30.019 268.939 27.5158C274.393 21.5597 283.575 20.5655 290.267 25.2134C298.555 30.9647 299.906 42.4179 293.184 49.8348C290.965 52.2716 288.738 54.7166 286.52 57.1534L285.838 57.9018L285.822 57.9025ZM281.788 54.1837C283.689 52.0963 285.537 50.083 287.362 48.0628C288.292 47.0239 289.24 46.0003 290.054 44.8707C293.289 40.3934 292.232 33.5738 287.823 30.1988C283.083 26.5669 276.776 27.0916 272.769 31.4591C270.519 33.9132 268.286 36.3825 266.052 38.8359C265.885 39.0188 265.751 39.2163 265.585 39.4152L281.796 54.1754L281.788 54.1837ZM277.861 69.9725C278.905 68.793 278.927 67.3229 278.126 66.3043C277.24 65.1936 275.835 64.8721 274.61 65.6125C269.944 68.4682 265.287 71.3314 260.647 74.2258C259.083 75.2047 259.051 77.4575 260.513 78.5908C261.526 79.3766 262.653 79.383 263.923 78.5927C268.045 76.0483 272.159 73.4964 276.281 70.9521C276.877 70.5826 277.481 70.2047 277.845 69.9732L277.861 69.9725ZM254.174 44.5552C252.867 43.3352 250.759 43.6674 249.908 45.3414C247.473 50.1668 245.079 55.0303 242.709 59.8848C242.057 61.2228 242.685 62.768 244.019 63.4359C245.305 64.074 246.892 63.5571 247.586 62.2413C248.191 61.089 248.756 59.9145 249.329 58.7476C251.1 55.1729 252.886 51.5976 254.649 48.0153C255.295 46.7174 255.095 45.4249 254.174 44.5552Z"
                    fill="url(#paint10_linear_28_690)" />
                <path
                    d="M122.816 638.694L124.553 637.261C125.572 638.119 126.621 638.939 127.585 639.851C127.852 640.101 127.882 640.609 128.048 640.98C129.333 643.899 130.642 646.812 131.902 649.748C132.327 650.738 132.657 651.765 132.998 652.793C133.102 653.097 133.102 653.425 133.165 653.82C129.069 653.888 125.554 655.262 122.638 658.066C119.721 660.879 118.204 664.332 118.09 668.523L117.113 668.328C110.342 666.98 103.578 665.59 96.8043 664.307C94.5743 663.885 92.9695 662.845 92.0187 660.768C91.4318 659.494 90.6414 658.365 89.2679 657.808C88.8751 657.643 88.4509 657.525 88.031 657.442C83.1804 656.422 78.3403 655.404 73.4877 654.394C72.1354 654.114 71.7654 653.56 72.0224 652.214C73.4056 644.882 78.8996 639.928 86.0415 639.636C87.1646 639.587 88.3152 639.674 89.4302 639.885C94.3731 640.826 99.3139 641.831 104.248 642.813C105.435 643.049 105.744 643.58 105.596 644.762C105.458 645.892 104.93 646.518 103.83 646.889C102.18 647.444 100.699 648.361 99.4489 649.597C98.0918 650.931 97.3774 652.546 97.2321 654.427C97.0558 656.793 98.4095 658.656 100.778 659.15C105.389 660.111 110.013 661.01 114.637 661.909C115.571 662.095 116.398 661.833 117.09 661.153C119.066 659.232 121.053 657.313 123.029 655.393C123.597 654.84 123.85 654.17 123.848 653.362C123.825 649.636 123.845 645.917 123.835 642.183C123.837 641.845 123.757 641.479 123.658 641.154C123.397 640.327 123.111 639.517 122.827 638.696L122.816 638.694Z"
                    fill="url(#paint11_linear_28_690)" />
                <path
                    d="M112.312 654.122L106.989 653.062L110.504 635.403L109.528 635.209C105.633 634.433 101.744 633.572 97.8257 632.912C94.9322 632.423 93.1352 630.155 94.4232 626.646C94.6667 626.684 94.9355 626.704 95.1875 626.754C100.762 627.864 106.327 628.972 111.902 630.082C114.884 630.675 116.523 633.076 115.932 636.047C114.786 641.855 113.618 647.669 112.462 653.475C112.421 653.685 112.36 653.88 112.301 654.12L112.312 654.122Z"
                    fill="url(#paint12_linear_28_690)" />
                <path
                    d="M121.602 630.757L120.604 630.559C117.182 629.877 113.769 629.144 110.332 628.536C107.991 628.124 106.184 627.055 105.11 624.887C105.061 624.801 104.99 624.722 104.851 624.541L104.487 625.986L94.9121 624.08C94.9329 623.866 94.9306 623.658 94.9703 623.458C95.4928 620.834 96.0153 618.209 96.5399 615.574C96.774 614.398 97.3505 613.476 98.4648 612.923C98.8404 612.735 99.1175 612.714 99.4495 613.075C100.944 614.671 102.79 615.377 104.981 615.224C105.225 615.207 105.607 615.48 105.746 615.715C107.008 617.985 108.244 620.272 109.435 622.572C109.758 623.193 110.181 623.485 110.855 623.608C113.192 624.04 115.533 624.507 117.857 625.002C120.497 625.56 122.214 628.172 121.57 630.751L121.602 630.757Z"
                    fill="url(#paint13_linear_28_690)" />
                <path
                    d="M123.708 670.514C120.758 669.927 120.253 669.171 120.843 666.211C121.837 661.213 126.133 657.179 131.232 656.458C136.287 655.74 141.311 658.301 143.721 662.808C144.022 663.381 144.165 663.922 143.697 664.462C143.284 664.948 142.766 665.03 142.161 664.833C136.323 662.907 129.997 664.911 126.388 669.934C125.816 670.726 125.312 671.008 124.43 670.669C124.208 670.581 123.958 670.575 123.716 670.527L123.708 670.514Z"
                    fill="url(#paint14_linear_28_690)" />
                <path
                    d="M137.378 666.49C138.543 666.667 139.746 666.71 140.867 667.054C142.052 667.409 143.171 667.599 144.388 667.078C144.805 668.492 144.785 669.853 144.495 671.203C143.725 674.848 140.74 677.725 137.09 678.406C133.362 679.094 129.601 677.483 127.532 674.332C127.162 673.778 127.113 673.364 127.487 672.751C128.543 671.007 129.833 669.518 131.566 668.433C131.803 668.284 132.068 668.162 132.351 668C132.162 670.374 132.732 671.623 134.21 672.146C135.657 672.664 137.122 672.213 137.951 671.014C138.856 669.699 138.656 668.294 137.384 666.513L137.378 666.49Z"
                    fill="url(#paint15_linear_28_690)" />
                <path
                    d="M72.8369 656.786L78.8003 657.973C79.1133 660.458 79.8804 661.43 81.619 661.688C83.114 661.909 84.3057 661.132 85.0789 659.386C86.0658 659.583 87.0904 659.699 88.0564 660.001C89.3605 660.413 89.6913 661.713 90.2423 662.783C90.3138 662.917 90.1209 663.228 90.0035 663.434C87.8884 666.931 83.7625 668.74 79.7118 667.65C75.3691 666.491 72.6177 662.767 72.7125 658.453C72.7267 657.943 72.7829 657.441 72.8348 656.796L72.8369 656.786Z"
                    fill="url(#paint16_linear_28_690)" />
                <path
                    d="M111.539 607.284L104.914 605.966L103.604 612.548C101.593 612.563 99.1702 610.476 98.3766 608.102C97.4524 605.342 98.4175 602.249 100.744 600.486C103.161 598.653 106.381 598.595 108.844 600.319C111.093 601.902 112.257 604.829 111.529 607.282L111.539 607.284Z"
                    fill="url(#paint17_linear_28_690)" />
                <path
                    d="M89.106 629.397C88.6755 631.559 88.2742 633.63 87.852 635.696C87.7036 636.441 87.1078 636.858 86.3498 636.718C82.7129 636.016 79.0698 635.29 75.4413 634.546C74.7904 634.417 74.305 633.949 74.4283 633.275C74.8063 631.102 75.2704 628.935 75.7093 626.73L89.1165 629.399L89.106 629.397Z"
                    fill="url(#paint18_linear_28_690)" />
                <path
                    d="M133.094 633.776C132.856 634.973 132.618 636.17 132.382 637.357C132.215 638.196 131.841 638.428 130.993 638.303C128.99 638.002 127.383 637.136 126.571 635.185C125.862 633.483 126.06 631.83 127.192 630.364C128.385 628.811 129.997 628.226 131.922 628.479C133.921 628.745 134.056 628.947 133.665 630.91C133.475 631.866 133.285 632.821 133.094 633.776Z"
                    fill="url(#paint19_linear_28_690)" />
                <path
                    d="M99.2495 635.684C101.286 636.089 103.334 636.497 105.37 636.902C106.62 637.151 107.263 637.977 107.052 639.038C106.841 640.098 105.92 640.613 104.67 640.365C100.565 639.548 96.4495 638.728 92.3444 637.911C91.095 637.662 90.454 636.825 90.6651 635.765C90.8741 634.715 91.7952 634.2 93.0446 634.449C95.1129 634.86 97.1812 635.272 99.2495 635.684Z"
                    fill="url(#paint20_linear_28_690)" />
                <path
                    d="M89.6033 626.898L76.1961 624.229C76.3592 623.41 76.4655 622.601 76.6937 621.839C76.8904 621.18 77.4843 620.938 78.1248 621.065C81.7616 621.767 85.3942 622.491 89.0227 623.235C89.8311 623.396 90.1676 624.008 90.0171 624.819C89.896 625.482 89.7538 626.142 89.6033 626.898Z"
                    fill="url(#paint21_linear_28_690)" />
                <path
                    d="M105.231 657.449L105.896 654.11C106.662 654.263 107.397 654.409 108.132 654.556C109.434 654.815 110.74 655.053 112.027 655.331C113.959 655.77 114.964 657.466 114.357 659.255L105.233 657.439L105.231 657.449Z"
                    fill="url(#paint22_linear_28_690)" />
                <path
                    d="M70.5095 648.354C69.722 648.088 69.499 647.564 69.616 646.921C69.9105 645.277 70.2281 643.627 70.5962 641.997C70.7781 641.193 71.3174 640.896 72.109 641.032C73.0265 641.193 73.9358 641.396 75.0172 641.611C72.9552 643.58 71.4834 645.765 70.499 648.352L70.5095 648.354Z"
                    fill="url(#paint23_linear_28_690)" />
                <path
                    d="M121.005 622.572L122.355 615.79C123.367 615.915 124.039 616.485 124.359 617.346C124.944 618.903 124.561 620.388 123.653 621.713C123.068 622.568 122.055 622.836 121.003 622.583L121.005 622.572Z"
                    fill="url(#paint24_linear_28_690)" />
                <path
                    d="M121.286 632.452C122.41 632.675 123.158 633.741 122.949 634.846C122.73 635.948 121.647 636.671 120.524 636.448C119.39 636.222 118.686 635.154 118.92 634.033C119.16 632.934 120.18 632.253 121.284 632.462L121.286 632.452Z"
                    fill="url(#paint25_linear_28_690)" />
                <path d="M110.712 609.685C110.21 611.768 108.259 613.071 106.176 612.733L106.933 608.932L110.712 609.685Z"
                    fill="url(#paint26_linear_28_690)" />
                <path
                    d="M125.011 623.937L126.251 622.427C126.97 623.585 127.664 624.705 128.334 625.832C128.532 626.155 128.492 626.409 128.083 626.601C127.493 626.876 126.954 627.227 126.266 627.614C126.859 626.008 125.439 625.19 125.011 623.937Z"
                    fill="url(#paint27_linear_28_690)" />
                <path
                    d="M134.941 637.331L136.183 631.095C137.107 631.824 137.398 632.723 137.233 633.77C137.005 635.242 136.794 636.739 134.941 637.331Z"
                    fill="url(#paint28_linear_28_690)" />
                <path
                    d="M39.6917 449.595C40.2996 447.964 41.4723 447.321 43.2019 447.24C48.6167 446.974 54.0243 446.594 59.4331 446.233C61.4064 446.109 62.5614 444.737 62.3193 442.856C62.1324 441.399 61.1647 440.636 59.4711 440.686C58.033 440.729 56.6091 440.848 55.174 440.938C51.8317 441.15 48.4894 441.361 45.1471 441.572C43.306 441.688 41.9745 440.569 41.8853 438.859C41.7998 437.205 42.9827 435.974 44.776 435.851C45.824 435.785 46.8626 435.719 48.0144 435.646C47.8831 433.569 47.7572 431.577 47.6313 429.585C47.509 427.649 48.5874 426.415 50.504 426.294C67.4705 425.222 84.4369 424.149 101.403 423.077L102.253 423.023L102.323 424.128C102.651 429.321 102.979 434.504 103.307 439.697C103.45 441.963 104.654 443.015 106.93 442.871C114.001 442.424 121.064 441.978 128.135 441.531C132.261 441.27 136.2 443.751 137.415 447.371C137.661 448.114 137.816 448.919 137.875 449.702C138.266 455.432 138.618 461.163 138.971 466.895C139.093 468.821 138.005 470.046 136.078 470.168C134.521 470.266 132.963 470.365 131.631 470.449C130.919 472.068 130.46 473.661 129.577 474.987C127.084 478.737 123.465 480.425 118.992 479.846C114.606 479.279 111.63 476.747 110.033 472.62C109.851 472.138 109.745 471.813 109.084 471.855C99.7575 472.473 90.4287 473.053 81.1004 473.643C81.006 473.649 80.9128 473.674 80.8007 473.7C79.4574 479.292 76.1275 482.849 70.2087 483.09C64.5738 483.323 60.9949 480.241 59.0727 475.026C57.2505 475.141 55.4378 475.255 53.625 475.37C51.7083 475.491 50.4831 474.403 50.3607 472.467C50.1877 469.729 50.0146 466.991 49.832 464.102L47.5566 464.246C46.4708 464.314 45.3809 464.317 44.3099 464.47C42.5816 464.721 41.3307 464.127 40.5223 462.586L40.4257 461.057C41.0335 459.426 42.2056 458.773 43.9358 458.702C47.5384 458.559 51.1226 458.276 54.7198 458.049C59.3934 457.753 64.077 457.467 68.75 457.162C70.5155 457.05 71.7302 455.722 71.6282 454.108C71.5267 452.503 70.1563 451.366 68.3877 451.431C68.1328 451.447 67.8779 451.463 67.6229 451.479C59.6071 451.986 51.5888 452.455 43.5772 453.027C41.85 453.146 40.6062 452.665 39.7984 451.133L39.7018 449.604L39.6917 449.595ZM69.4691 466.889C66.5623 467.092 64.3175 469.67 64.5361 472.529C64.7535 475.368 67.2902 477.559 70.1516 477.387C72.9652 477.209 75.22 474.64 75.0309 471.799C74.8513 468.957 72.2815 466.693 69.4596 466.89L69.4691 466.889ZM120.796 474.186C123.619 474.008 125.854 471.421 125.665 468.58C125.466 465.729 122.896 463.475 120.085 463.69C117.217 463.9 114.996 466.41 115.166 469.253C115.338 472.123 117.907 474.378 120.805 474.186L120.796 474.186Z"
                    fill="url(#paint29_linear_28_690)" />
                <path d="M108.933 436.915L108.071 423.281C116.031 424.295 120.588 429.656 124.596 435.925L108.933 436.915Z"
                    fill="url(#paint30_linear_28_690)" />
                <path
                    d="M392.451 1041.91C392.982 1042.18 393.521 1042.44 394.049 1042.73C397.556 1044.62 399.744 1048.94 399.357 1052.92C399.127 1055.32 397.967 1057.22 396.448 1058.96C393.725 1062.07 390.491 1064.61 387.141 1067.01C386.717 1067.32 386.298 1067.63 385.86 1067.91C385.03 1068.46 384.042 1068.22 383.596 1067.34C381.536 1063.21 379.657 1059.01 378.652 1054.48C378.299 1052.9 378.066 1051.31 378.38 1049.69C378.772 1047.69 379.694 1045.96 381.128 1044.54C383.611 1042.07 386.607 1041 390.104 1041.4C390.18 1041.41 390.255 1041.38 390.33 1041.37C391.035 1041.55 391.74 1041.73 392.445 1041.91L392.451 1041.91ZM393.138 1053.09C393.758 1050.65 392.367 1048.21 389.864 1047.55C387.452 1046.91 384.975 1048.41 384.361 1050.82C383.741 1053.24 385.109 1055.7 387.641 1056.36C390.058 1057 392.517 1055.5 393.144 1053.09L393.138 1053.09Z"
                    fill="url(#paint31_linear_28_690)" />
                <path
                    d="M379.226 1065.29C379.487 1065.83 379.737 1066.36 380 1066.9C380.298 1067.51 380.594 1068.12 380.912 1068.73C382.225 1071.23 385.276 1071.98 387.608 1070.38C391.111 1067.98 394.475 1065.41 397.434 1062.34C397.632 1062.13 397.81 1062.12 398.06 1062.19C402.351 1063.3 406.651 1064.4 410.943 1065.5C411.762 1065.71 412.219 1066.2 412.272 1066.91C412.33 1067.63 411.927 1068.21 411.116 1068.51C409.085 1069.26 407.05 1070.01 405.014 1070.76C394.613 1074.61 384.207 1078.45 373.805 1082.3C372.833 1082.66 372.183 1082.58 371.717 1082.01C371.259 1081.45 371.242 1080.84 371.55 1080.23C374.06 1075.27 376.582 1070.32 379.103 1065.37C379.109 1065.34 379.154 1065.33 379.227 1065.28L379.226 1065.29Z"
                    fill="url(#paint32_linear_28_690)" />
                <path
                    d="M391.958 1092.02C386.574 1090.63 381.196 1089.25 375.811 1087.87C374.737 1087.59 374.244 1086.7 374.628 1085.75C374.832 1085.24 375.271 1084.99 375.759 1084.82C379.617 1083.39 383.475 1081.96 387.332 1080.54C388.832 1079.98 390.339 1079.45 391.823 1078.86C392.652 1078.54 393.322 1078.67 393.99 1079.28C399.158 1084 404.343 1088.71 409.514 1093.42C410.487 1094.3 410.453 1095.5 409.438 1096.07C408.991 1096.33 408.537 1096.28 408.06 1096.15C402.693 1094.77 397.325 1093.4 391.958 1092.02Z"
                    fill="url(#paint33_linear_28_690)" />
                <path
                    d="M416.633 1092.6C416.391 1093.74 415.179 1094.23 414.3 1093.64C414.145 1093.54 414.001 1093.41 413.858 1093.29C408.691 1088.58 403.529 1083.88 398.367 1079.18C398.3 1079.11 398.225 1079.05 398.157 1078.98C397.241 1078.09 397.485 1076.81 398.677 1076.35C400.124 1075.79 401.585 1075.26 403.038 1074.73C407.043 1073.25 411.049 1071.76 415.058 1070.29C415.962 1069.96 416.751 1070.17 417.125 1070.88C417.271 1071.16 417.344 1071.51 417.335 1071.83C417.187 1076.77 417.027 1081.71 416.862 1086.65C416.801 1088.46 416.741 1090.27 416.681 1092.09C416.677 1092.29 416.648 1092.5 416.64 1092.6L416.633 1092.6Z"
                    fill="url(#paint34_linear_28_690)" />
                <path
                    d="M100.699 1043.71C101.184 1042.33 101.56 1040.92 102.157 1039.59C105.493 1032.14 108.909 1024.74 112.23 1017.3C113.182 1015.18 114.667 1014 116.948 1013.61C131.844 1011 146.72 1008.35 161.605 1005.68C163.53 1005.34 165.161 1005.72 166.73 1006.91C174.284 1012.62 181.875 1018.29 189.478 1023.94C189.998 1024.32 190.67 1024.56 191.305 1024.69C197.955 1025.96 204.611 1027.18 211.273 1028.43C218.477 1029.78 222.672 1034.25 224.184 1041.45C225.309 1046.8 222.737 1048.84 218.681 1049.27C216.632 1049.49 214.614 1049.96 212.873 1050.27C212.131 1052.59 211.681 1054.83 210.723 1056.83C206.486 1065.78 194.101 1067.97 187.072 1061.03C185.69 1059.66 184.662 1057.91 183.568 1056.27C183.229 1055.76 182.974 1055.55 182.365 1055.66C169.629 1057.94 156.887 1060.18 144.151 1062.46C144.038 1062.48 143.932 1062.54 144.151 1062.46C143.386 1064.81 142.922 1067.05 141.978 1069.05C137.808 1077.88 125.504 1080.13 118.491 1073.36C117.116 1072.03 116.071 1070.34 115.01 1068.72C114.551 1068.02 114.232 1067.63 113.36 1067.9C112.682 1068.11 111.954 1068.12 111.256 1068.3C108.376 1069.02 106.098 1068.28 104.576 1065.63L100.682 1043.7L100.699 1043.71ZM143.636 1031.93L176.12 1026.16C175.988 1026 175.942 1025.9 175.856 1025.83C171.428 1022.52 167.027 1019.19 162.562 1015.92C162.192 1015.65 161.516 1015.62 161.034 1015.7C154.858 1016.77 148.701 1017.87 142.532 1018.98C142.15 1019.04 141.79 1019.15 141.382 1019.24L143.633 1031.92L143.636 1031.93ZM133.954 1033.65L131.69 1020.9C127.982 1021.56 124.356 1022.19 120.74 1022.88C120.414 1022.93 120.088 1023.4 119.934 1023.77C118.015 1027.92 116.141 1032.09 114.253 1036.25C114.126 1036.53 114.032 1036.82 113.883 1037.22L133.954 1033.65ZM198.157 1055.38C201.158 1054.85 203.168 1052.02 202.689 1049C202.21 1045.97 199.288 1043.91 196.228 1044.43C193.213 1044.97 191.206 1047.81 191.711 1050.81C192.209 1053.87 195.114 1055.92 198.171 1055.38L198.157 1055.38ZM129.537 1067.56C132.566 1067.03 134.579 1064.22 134.074 1061.21C133.551 1058.1 130.741 1056.09 127.667 1056.62C124.579 1057.16 122.602 1060 123.165 1063.09C123.72 1066.13 126.522 1068.1 129.551 1067.56L129.537 1067.56Z"
                    fill="url(#paint35_linear_28_690)" />
                <g opacity="0.3">
                    <path
                        d="M272.321 815.467C266.54 820.407 258.582 822.139 250.988 821.747C243.414 821.339 236.072 819.008 228.886 816.587C213.07 811.282 198.576 806.245 183.486 799.257C177.259 796.374 170.015 792.031 164.138 788.485C162.252 787.354 160.358 786.132 159.054 784.366C157.749 782.601 157.14 780.16 158.066 778.176C159.093 775.951 161.771 774.865 164.234 774.963C166.679 775.059 168.995 776.08 171.244 777.056C190.166 785.211 210.995 790.741 231.349 787.487C237.04 786.583 242.596 784.995 248.258 784.034C253.937 783.075 259.849 782.74 265.383 784.329C270.918 785.918 276.048 789.663 278.222 795.002C281.077 802.032 278.097 810.562 272.316 815.502L272.321 815.467Z"
                        fill="url(#paint36_linear_28_690)" />
                    <path
                        d="M59.0824 1019.79C59.3797 1013.88 62.6554 1008.44 66.9423 1004.35C71.227 1000.28 76.4733 997.369 81.7045 994.585C93.1722 988.47 103.791 982.958 115.822 978.157C120.794 976.173 127.131 974.408 132.272 972.969C133.917 972.517 135.63 972.091 137.321 972.295C139.013 972.499 140.721 973.464 141.359 975.059C142.065 976.842 141.236 978.928 139.882 980.265C138.511 981.599 136.704 982.357 134.949 983.121C120.202 989.473 105.914 998.301 96.87 1011.57C94.3455 1015.28 92.2559 1019.27 89.7649 1023C87.2738 1026.73 84.2836 1030.26 80.4316 1032.54C76.5797 1034.82 71.703 1035.71 67.5274 1034.09C62.006 1031.94 58.7872 1025.68 59.0845 1019.77L59.0824 1019.79Z"
                        fill="url(#paint37_linear_28_690)" />
                    <path
                        d="M-63.3317 1000.13C-45.2142 1018.7 -17.4807 1027.79 7.87705 1022.29C27.8344 1017.97 44.9167 1005.6 62.5774 995.313C88.6125 980.151 117.025 969.088 146.468 962.666C173.834 956.68 212.86 967.098 236.937 952.747C252.739 943.342 265.627 928.599 271.14 911.051C278.054 889.083 270.103 861.4 258.59 847.074C235.236 818.003 178.802 815.478 150.561 791.129C127.687 771.403 125.308 743.201 104.443 721.35C87.0255 703.114 59.3615 695.693 34.9704 702.02C10.5794 708.346 -9.77335 727.917 -17.7863 751.812C-23.4334 768.675 -23.2424 786.857 -25.8701 804.446L-25.9066 804.749C-28.3909 821 -35.2928 836.284 -45.6958 848.996C-48.6633 852.631 -51.5795 856.291 -54.4289 859.994C-69.9537 880.274 -83.4297 903.185 -86.6116 928.512C-89.8451 954.268 -81.4271 981.519 -63.3096 1000.09L-63.3317 1000.13Z"
                        fill="url(#paint38_linear_28_690)" />
                </g>
            </g>
            <defs>
                <linearGradient id="paint0_linear_28_690" x1="133.527" y1="874.518" x2="37.4054"
                    y2="822.459" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#CFFFE9" />
                    <stop offset="0.328125" stop-color="#A3F0CC" stop-opacity="0.67" />
                    <stop offset="0.796875" stop-color="#AEFCD8" stop-opacity="0.15" />
                    <stop offset="1" stop-color="white" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_690" x1="131.335" y1="846.809" x2="114.294"
                    y2="908.091" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint2_linear_28_690" x1="88.3844" y1="834.878" x2="71.3536"
                    y2="896.124" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint3_linear_28_690" x1="125.883" y1="835.274" x2="118.201"
                    y2="862.899" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint4_linear_28_690" x1="102.564" y1="814.883" x2="94.8852"
                    y2="842.495" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint5_linear_28_690" x1="57.4376" y1="72" x2="57.4376"
                    y2="103.12" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint6_linear_28_690" x1="58.079" y1="106.848" x2="58.079"
                    y2="139.156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint7_linear_28_690" x1="131.715" y1="234.812" x2="106.11"
                    y2="303.374" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint8_linear_28_690" x1="90.1474" y1="301.717" x2="84.465"
                    y2="316.933" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint9_linear_28_690" x1="135.806" y1="318.758" x2="130.121"
                    y2="333.981" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint10_linear_28_690" x1="292.008" y1="26.5939" x2="244.206"
                    y2="79.0915" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint11_linear_28_690" x1="106.447" y1="633.657" x2="100.211"
                    y2="664.986" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint12_linear_28_690" x1="105.633" y1="628.834" x2="101.045"
                    y2="651.879" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint13_linear_28_690" x1="110.672" y1="615.12" x2="108.09"
                    y2="628.092" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint14_linear_28_690" x1="134.147" y1="656.344" x2="131.026"
                    y2="672.019" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint15_linear_28_690" x1="137.189" y1="665.645" x2="134.611"
                    y2="678.595" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint16_linear_28_690" x1="81.7989" y1="658.57" x2="79.9766"
                    y2="667.724" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint17_linear_28_690" x1="106.202" y1="599.192" x2="103.533"
                    y2="612.6" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint18_linear_28_690" x1="82.4082" y1="628.063" x2="80.8982"
                    y2="635.649" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint19_linear_28_690" x1="130.641" y1="628.19" x2="128.716"
                    y2="637.86" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint20_linear_28_690" x1="99.2023" y1="635.674" x2="98.5126"
                    y2="639.139" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint21_linear_28_690" x1="83.5754" y1="622.134" x2="82.893"
                    y2="625.562" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint22_linear_28_690" x1="110.474" y1="655.012" x2="109.807"
                    y2="658.36" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint23_linear_28_690" x1="72.9159" y1="641.183" x2="71.451"
                    y2="648.542" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint24_linear_28_690" x1="123.786" y1="616.066" x2="122.432"
                    y2="622.87" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint25_linear_28_690" x1="121.328" y1="632.46" x2="120.534"
                    y2="636.45" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint26_linear_28_690" x1="108.823" y1="609.308" x2="108.066"
                    y2="613.109" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint27_linear_28_690" x1="127.219" y1="622.619" x2="126.226"
                    y2="627.606" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint28_linear_28_690" x1="136.957" y1="631.249" x2="135.715"
                    y2="637.485" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint29_linear_28_690" x1="87.1702" y1="423.977" x2="90.8294"
                    y2="481.867" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint30_linear_28_690" x1="115.903" y1="422.786" x2="116.764"
                    y2="436.42" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint31_linear_28_690" x1="391.397" y1="1041.64" x2="384.582"
                    y2="1068.16" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint32_linear_28_690" x1="395.053" y1="1061.42" x2="388.574"
                    y2="1086.63" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint33_linear_28_690" x1="395.26" y1="1079.31" x2="391.992"
                    y2="1092.02" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint34_linear_28_690" x1="411.281" y1="1068.91" x2="405.484"
                    y2="1091.46" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint35_linear_28_690" x1="156.06" y1="1006.67" x2="167.425"
                    y2="1070.66" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint36_linear_28_690" x1="215.251" y1="817.538" x2="219.96"
                    y2="778.506" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint37_linear_28_690" x1="95.5501" y1="1037.85" x2="103.944"
                    y2="968.268" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint38_linear_28_690" x1="78.8463" y1="1034.8" x2="118.367"
                    y2="707.199" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 3 -->
        <svg class="e-shape-3" viewBox="0 0 567 122" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
                d="M0.771484 56.7829C2.51171 39.3589 24.7719 26.9408 54.061 19.8095C83.3362 12.7292 119.288 10.3136 155.143 8.25515C233.743 3.70573 306.53 -0.0574563 389.079 0.0314772C423.192 0.0674218 466.707 2.41053 502.013 4.2893C513.305 4.91499 525.072 5.70358 536.723 8.36127C548.374 11.019 560.178 15.9867 564.655 21.558C569.606 27.7792 564.004 33.0555 554.76 35.4425C545.392 37.8016 532.993 37.8981 520.962 38.0786C419.801 39.3776 321.934 48.6861 260.387 77.7089C243.206 85.8148 229.033 95.3111 212.083 103.524C195.134 111.737 174.739 118.73 148.349 120.944C121.96 123.157 88.4465 119.954 59.6276 110.022C21.5201 96.887 -0.954816 74.1559 0.785346 56.7319L0.771484 56.7829Z"
                fill="url(#paint1_linear_28_12)" />
            <defs>
                <linearGradient id="paint0_linear_28_12" x1="775.34" y1="173.511" x2="99.211"
                    y2="-856.565" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#CFFFE9" />
                    <stop offset="0.328125" stop-color="#A3F0CC" stop-opacity="0.67" />
                    <stop offset="0.796875" stop-color="#AEFCD8" stop-opacity="0.15" />
                    <stop offset="1" stop-color="white" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_12" x1="542.96" y1="113.435" x2="6.2657"
                    y2="-32.4356" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" />
                    <stop offset="1" stop-color="#D6FFEC" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 4 -->
        <svg class="e-shape-4" width="567" height="122" viewBox="0 0 567 122" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M0.771494 56.7829C2.51169 39.3589 24.7719 26.9408 54.061 19.8095C83.3362 12.7292 119.288 10.3136 155.143 8.25516C233.743 3.70574 306.53 -0.0574518 389.079 0.0314811C423.192 0.0674279 466.707 2.41053 502.013 4.2893C513.305 4.91499 525.072 5.70357 536.723 8.36126C548.374 11.0189 560.178 15.9867 564.655 21.558C569.606 27.7792 564.004 33.0555 554.76 35.4425C545.392 37.8015 532.993 37.8981 520.962 38.0786C419.802 39.3776 321.934 48.6861 260.387 77.7089C243.206 85.8148 229.033 95.3111 212.083 103.524C195.134 111.737 174.739 118.73 148.349 120.944C121.96 123.157 88.4465 119.954 59.6276 110.022C21.5201 96.887 -0.954838 74.1559 0.785356 56.7319L0.771494 56.7829Z"
                fill="url(#paint0_linear_28_689)" />
            <defs>
                <linearGradient id="paint0_linear_28_689" x1="542.96" y1="113.435" x2="6.2657"
                    y2="-32.4356" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" />
                    <stop offset="1" stop-color="#D6FFEC" />
                </linearGradient>
            </defs>
        </svg>


    </section>
    <!-- ==== Earn Money Section Ends Here ==== -->

    <!-- ==== Special Feature Section Starts Here ==== -->
    <?php ($special = $landing_data['criterias']); ?>
    <?php if($special && count($special) > 0): ?>
        <section class="special-feature-section pt-80 pb-80 overflow-hidden position-relative">
            <div class="container">
                <div class="section-header wow fadeInUp">
                    <h2 class="title">
                        <?php echo e($landing_data['why_choose_title']); ?>


                    </h2>
                </div>
                <div class="special-feature-wrapper wow fadeInUp">
                    <?php $__currentLoopData = $special; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->status == '1'): ?>
                            <div class="feature-card">
                                <div class="feature-card-icon">
                                    <img src="<?php echo e($item['image_full_url']); ?>" alt="<?php echo e($item['title']); ?>"
                                        class="onerror-image"
                                        data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>">
                                </div>
                                <div class="feature-card-cont">
                                    <h4 class="subtitle">
                                        <?php ($arr = explode(' ', trim($item['title']))); ?>
                                        <?php if(isset($arr[0])): ?>
                                            <?php echo e($arr[0]); ?>

                                        <?php endif; ?>
                                        <br>
                                        <?php if(count($arr) > 1): ?>
                                            <?php (array_shift($arr)); ?>
                                            <?php echo e(implode(' ', $arr)); ?>

                                        <?php endif; ?>
                                    </h4>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <!-- Shape 1 -->
            <svg class="s-shape-1" width="152" height="537" viewBox="0 0 152 537" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M83.2873 13.7046C81.6228 5.40203 89.5703 -1.589 97.5928 1.12076L143.54 16.6403C151.563 19.3501 153.643 29.7283 147.285 35.3212L110.871 67.3528C104.513 72.9456 94.4851 69.5584 92.8206 61.2558L83.2873 13.7046Z"
                    fill="url(#paint0_linear_28_12)" />
                <path
                    d="M12.2376 276.382C3.78116 276.82 -1.97923 267.94 1.86888 260.398L23.9081 217.197C27.7562 209.654 38.3267 209.106 42.935 216.21L69.3281 256.896C73.9364 264 69.1262 273.429 60.6698 273.868L12.2376 276.382Z"
                    fill="url(#paint1_linear_28_12)" />
                <path
                    d="M123.58 527.141C122.616 535.553 112.907 539.768 106.103 534.727L43.806 488.572C37.0021 483.531 38.2067 473.015 45.9742 469.643L117.095 438.77C124.862 435.398 133.367 441.699 132.403 450.112L123.58 527.141Z"
                    fill="url(#paint2_linear_28_12)" />
                <defs>
                    <linearGradient id="paint0_linear_28_12" x1="79.5421" y1="-4.97621" x2="145.59"
                        y2="70.108" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint1_linear_28_12" x1="-6.78937" y1="277.369" x2="77.1052"
                        y2="222.948" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint2_linear_28_12" x1="121.412" y1="546.069" x2="68.2419"
                        y2="423.585" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                </defs>
            </svg>
            <!-- Shape 2 -->
            <svg class="s-shape-2" width="151" height="537" viewBox="0 0 151 537" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M67.845 13.7046C69.5095 5.40203 61.562 -1.589 53.5395 1.12076L7.59235 16.6403C-0.430176 19.3501 -2.51085 29.7283 3.84714 35.3212L40.2611 67.3528C46.6191 72.9456 56.6472 69.5584 58.3117 61.2558L67.845 13.7046Z"
                    fill="url(#paint0_linear_28_12)" />
                <path
                    d="M138.895 276.382C147.351 276.82 153.112 267.94 149.263 260.398L127.224 217.197C123.376 209.654 112.806 209.106 108.197 216.21L81.8043 256.896C77.1959 264 82.0061 273.429 90.4625 273.868L138.895 276.382Z"
                    fill="url(#paint1_linear_28_12)" />
                <path
                    d="M27.5523 527.141C28.5159 535.553 38.2253 539.768 45.0292 534.727L107.326 488.572C114.13 483.531 112.926 473.015 105.158 469.643L34.0377 438.77C26.2702 435.398 17.7654 441.699 18.729 450.112L27.5523 527.141Z"
                    fill="url(#paint2_linear_28_12)" />
                <defs>
                    <linearGradient id="paint0_linear_28_12" x1="71.5902" y1="-4.97621" x2="5.54207"
                        y2="70.108" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint1_linear_28_12" x1="157.922" y1="277.369" x2="74.0271"
                        y2="222.948" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint2_linear_28_12" x1="29.7205" y1="546.069" x2="82.8904"
                        y2="423.585" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                </defs>
            </svg>
        </section>
    <?php endif; ?>
    <!-- ==== Special Feature Section Ends Here ==== -->

    <!-- ==== Counter Section Starts Here ==== -->
    <?php ($counter = $landing_data['counter_section']); ?>
    <?php if(isset($counter) && $counter['status'] == '1'): ?>
        <section class="counter-section  mb--186px">
            <div class="container">
                <div class="counter-wrapper position-relative">
                    <div class="contact-wrapper-inner">
                        <div class="left-side">
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="35" viewBox="0 0 32 35" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M1.72825 34.2238C1.23767 34.0386 0.764414 33.8361 0.441208 33.3906C0.175717 33.0319 0.00256513 32.6384 0.00256513 32.1871C-0.00320641 29.3462 0.00256513 26.5053 0.00256513 23.6643C0.00256513 23.6354 0.0141075 23.6007 0.0198791 23.5486H4.25619V29.919H27.7291V23.5428H32V23.9305C32 26.5689 32 29.2131 32 31.8515C32 33.0955 31.521 33.7667 30.3493 34.1659C30.3205 34.1775 30.2974 34.2006 30.2685 34.2238H1.72825Z"
                                            fill="#6DEBB0" />
                                        <path
                                            d="M12.7978 14.9741V14.5286C12.7978 10.1081 12.7978 5.68184 12.7978 1.26134C12.7978 0.387657 13.1845 0 14.056 0C15.3777 0 16.6994 0 18.0211 0C18.7771 0 19.1927 0.422373 19.1927 1.18034C19.1927 5.63555 19.1927 10.0908 19.1927 14.546V14.9741H19.5794C20.826 14.9741 22.0669 14.9857 23.3136 14.9741C23.8215 14.9741 24.2139 15.1419 24.4275 15.6048C24.6468 16.0735 24.5025 16.4901 24.1735 16.8604C22.696 18.5499 21.2185 20.2452 19.741 21.9405C18.8176 22.9993 17.8999 24.0523 16.9764 25.1112C16.3069 25.8749 15.6894 25.8807 15.0256 25.1228C12.6478 22.4033 10.2641 19.6781 7.89778 16.9472C7.70732 16.7273 7.53417 16.4496 7.48223 16.1718C7.36102 15.5354 7.88046 14.9857 8.5615 14.9799C9.83701 14.9741 11.1183 14.9799 12.3938 14.9799C12.515 14.9799 12.6362 14.9799 12.7978 14.9799V14.9741Z"
                                            fill="#6DEBB0" />
                                    </svg>
                                </div>
                                <h4 class="title text-right"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['app_download_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Download')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="36" viewBox="0 0 32 36" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M15.9963 0.00515352C19.0717 0.00515352 22.147 0.00515352 25.2172 0.00515352C25.9951 0.00515352 26.742 0.165252 27.4117 0.593884C28.1638 1.07932 28.6789 1.74551 28.9571 2.59244C29.8689 5.33465 30.8116 8.06136 31.6873 10.8139C32.8361 14.4444 30.7189 17.9715 26.9893 18.6326C25.2739 18.9373 23.6873 18.5086 22.2758 17.4654C22.1522 17.3725 22.0337 17.2692 21.91 17.1711C21.2919 16.6753 20.7098 16.665 20.1071 17.1608C18.8038 18.2349 17.3047 18.7462 15.6254 18.6532C14.2758 18.5809 13.0703 18.1006 12.0092 17.2537C11.2365 16.6392 10.7574 16.6392 9.98983 17.2537C7.749 19.0302 4.60667 19.1645 2.4328 17.5791C0.300147 16.0195 -0.52922 13.3186 0.341358 10.6641C1.21194 8.00457 2.09797 5.35014 2.9943 2.70089C3.58156 0.960538 4.93121 0.00516424 6.78054 0C9.8559 0 12.9313 0 16.0015 0L15.9963 0.00515352Z"
                                            fill="#7FBDF4" />
                                        <path
                                            d="M2.2771 20.5944C3.0395 20.7958 3.73493 21.0231 4.44067 21.1573C6.64544 21.5808 8.70598 21.147 10.6171 20.0005C10.9056 19.825 11.1065 19.8301 11.3847 20.0005C12.7807 20.8578 14.3158 21.2813 15.9436 21.2916C17.6384 21.3019 19.2353 20.8578 20.688 19.9644C20.8992 19.8353 21.0538 19.8095 21.2856 19.9489C23.851 21.5343 26.5451 21.7564 29.3526 20.6719C29.4505 20.6358 29.5432 20.5996 29.6926 20.5428C29.7029 20.6771 29.7235 20.7855 29.7235 20.894C29.7235 24.3127 29.7338 27.7366 29.7235 31.1553C29.7183 33.0402 28.5696 34.5172 26.813 34.9252C26.4987 34.9975 26.1691 35.0336 25.8497 35.0388C24.7937 35.0543 23.7376 35.0336 22.6867 35.0491C22.3725 35.0491 22.2849 34.9562 22.2901 34.6463C22.3055 33.0919 22.3004 31.5375 22.2901 29.983C22.2849 27.9535 20.6108 26.2699 18.5863 26.2648C16.8657 26.2648 15.1503 26.2648 13.4298 26.2648C11.4053 26.2699 9.72595 27.9535 9.7208 29.9779C9.7208 31.5323 9.7105 33.0867 9.7208 34.6412C9.7208 34.9407 9.64868 35.0595 9.3293 35.0491C8.05691 35.013 6.77938 35.0491 5.507 34.9613C3.93068 34.8581 2.49346 33.3914 2.34922 31.8215C2.30801 31.3567 2.28225 30.8868 2.28225 30.4168C2.2771 27.2821 2.28225 24.1474 2.28225 21.0179V20.5944H2.2771Z"
                                            fill="#7FBDF4" />
                                        <path
                                            d="M12.2562 35.043C12.2562 33.344 12.2458 31.6707 12.2562 29.9975C12.2613 29.352 12.7919 28.8253 13.4358 28.8201C15.1409 28.8046 16.8512 28.8046 18.5563 28.8201C19.195 28.8201 19.7308 29.3572 19.7359 29.9975C19.7514 31.6707 19.7359 33.3388 19.7359 35.043H12.2458H12.2562Z"
                                            fill="#7FBDF4" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['seller_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Seller')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="26" viewBox="0 0 32 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M2.89821 20.0516C2.40405 15.6726 5.28959 12.687 8.5281 12.1385C9.00902 12.0589 9.50318 12.0279 9.99293 12.0191C11.1533 12.0014 12.3137 12.0147 13.4741 12.0147C14.2065 12.0147 14.4315 12.3464 14.1448 13.0099C13.88 13.638 13.5976 14.2572 13.3506 14.8897C12.7549 16.398 13.58 18.0877 15.1816 18.2381C16.8229 18.3929 18.5216 18.415 20.1453 18.1717C22.1395 17.8798 23.2867 15.8982 23.022 13.7972C22.8146 12.1562 22.669 10.5108 22.4969 8.86535C22.4484 8.40092 22.3999 7.93648 22.3425 7.43224C22.7352 7.43224 23.0926 7.41013 23.4411 7.44551C23.5294 7.45436 23.6353 7.62686 23.675 7.74629C24.2927 9.73672 24.8971 11.7316 25.506 13.7264C25.7001 14.3545 25.8899 14.9826 26.0928 15.6372C25.9958 15.677 25.9075 15.7124 25.8193 15.7478C24.3633 16.3449 23.3264 17.3269 22.9381 18.9015C22.7837 19.5341 22.8367 20.1047 23.472 20.4762C23.525 20.5072 23.5603 20.6222 23.5558 20.6929C23.5426 20.8433 23.4985 20.9937 23.4588 21.1795H23.1279C19.682 21.1795 16.2317 21.1795 12.7858 21.1795C12.5829 21.1795 12.4549 21.1485 12.3446 20.9362C12.0181 20.3214 11.4754 20.0339 10.7783 20.0339C8.28102 20.0339 5.77934 20.0339 3.28206 20.0339H2.8938L2.89821 20.0516ZM8.03394 17.7648C7.29711 17.7648 6.56028 17.7648 5.82787 17.7648C5.40872 17.7648 5.1484 17.9904 5.15281 18.3398C5.15722 18.6671 5.41313 18.9015 5.81463 18.9015C7.27505 18.906 8.73547 18.906 10.1959 18.9015C10.5974 18.9015 10.8489 18.6715 10.8489 18.3354C10.8489 17.9815 10.6018 17.7648 10.1738 17.7648C9.45906 17.7648 8.7487 17.7648 8.03394 17.7648ZM8.56781 16.6059C9.12374 16.6059 9.67967 16.6148 10.24 16.6059C10.6195 16.5971 10.8533 16.3626 10.8489 16.0353C10.8489 15.7036 10.6106 15.4824 10.2312 15.4824C9.12815 15.4824 8.02511 15.4692 6.92649 15.4913C6.74559 15.4913 6.50734 15.6107 6.39703 15.7522C6.12348 16.1149 6.40586 16.5838 6.90443 16.6059C7.46036 16.628 8.01629 16.6103 8.57222 16.6103L8.56781 16.6059Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M10.2756 10.8829C10.1521 10.8873 10.0329 10.9006 9.91381 10.9006C6.8915 10.9006 3.86918 10.9006 0.846869 10.9006C0.158575 10.9006 0.00415039 10.7414 0.00415039 10.0514C0.00415039 7.79112 0.00415039 5.53529 0.00415039 3.27505V2.89465H1.73371C1.73371 3.08485 1.72488 3.27062 1.73371 3.4564C1.74694 3.76602 1.96314 3.9916 2.24993 4.01372C2.52789 4.03583 2.78821 3.83237 2.83233 3.52717C2.86322 3.32813 2.8588 3.12908 2.87204 2.89908H7.42978C7.42978 3.03177 7.42978 3.18658 7.42978 3.33697C7.4386 3.7439 7.67686 4.02256 8.01218 4.01372C8.33868 4.00487 8.5637 3.73948 8.56811 3.34582C8.56811 3.20428 8.56811 3.05831 8.56811 2.89465H10.2712V10.8829H10.2756Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.4645 21.8582C31.3322 23.7336 29.9379 25.1491 28.1334 25.2154C25.8832 25.295 24.1536 23.1852 24.661 20.9824C24.7228 20.717 24.8199 20.602 25.1243 20.6064C27.0524 20.6241 28.9805 20.6241 30.9086 20.6064C31.1954 20.6064 31.3101 20.7082 31.341 20.9691C31.3763 21.2655 31.4248 21.5619 31.4645 21.8626V21.8582Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M4.62678 21.1986H4.97534C6.88138 21.1986 8.78743 21.1986 10.6935 21.1986C11.2494 21.1986 11.4744 21.4242 11.4391 21.9682C11.3156 23.9144 9.68309 25.3387 7.75058 25.2281C6.02543 25.1308 4.54736 23.5473 4.57384 21.7515C4.57384 21.5746 4.60913 21.4021 4.63119 21.1986H4.62678Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.9999 19.4743H24.0095C24.0272 18.8727 24.2743 18.3817 24.636 17.9527C25.3243 17.1344 26.1935 16.6567 27.2701 16.6346C27.9672 16.6213 28.6908 16.5815 29.3659 16.7275C30.6851 17.0194 31.6072 17.82 31.9646 19.1823C31.9867 19.2664 31.9867 19.3548 31.9999 19.4743Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M0.0039219 1.70243C0.0039219 1.31319 -0.00490238 0.946069 0.0039219 0.578945C0.0127462 0.260476 0.228941 0.0393172 0.542203 0.00393172C0.630445 -0.00491465 0.718688 0.00393172 0.811343 0.00393172C3.69688 0.00393172 6.58683 0.00393172 9.47237 0.00393172C10.121 0.00393172 10.2974 0.185282 10.3019 0.844336C10.3019 1.123 10.3019 1.40166 10.3019 1.71128H0.0039219V1.70243Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M25.1394 4.01562V6.28029C25.0379 6.28914 24.9497 6.30241 24.8658 6.30241C23.8422 6.30241 22.8142 6.30683 21.7906 6.30241C21.0802 6.30241 20.5684 5.82028 20.564 5.16565C20.5596 4.50217 21.0846 4.01562 21.8082 4.01562C22.9113 4.01562 24.0099 4.01562 25.1394 4.01562Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M11.4383 10.8974C11.4383 10.4595 11.425 10.0836 11.4383 9.70318C11.4559 9.38028 11.65 9.18124 11.9721 9.17682C12.6737 9.16355 13.3752 9.16355 14.0767 9.18124C14.4959 9.19451 14.8224 9.54836 14.8533 9.95972C14.8841 10.3932 14.6018 10.7957 14.1694 10.8532C13.8076 10.9019 13.437 10.8886 13.0707 10.893C12.5369 10.8974 12.003 10.893 11.4338 10.893L11.4383 10.8974Z"
                                            fill="#F9AD76" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['deliveryman_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Deliveryman')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="26" viewBox="0 0 32 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M2.89821 20.0516C2.40405 15.6726 5.28959 12.687 8.5281 12.1385C9.00902 12.0589 9.50318 12.0279 9.99293 12.0191C11.1533 12.0014 12.3137 12.0147 13.4741 12.0147C14.2065 12.0147 14.4315 12.3464 14.1448 13.0099C13.88 13.638 13.5976 14.2572 13.3506 14.8897C12.7549 16.398 13.58 18.0877 15.1816 18.2381C16.8229 18.3929 18.5216 18.415 20.1453 18.1717C22.1395 17.8798 23.2867 15.8982 23.022 13.7972C22.8146 12.1562 22.669 10.5108 22.4969 8.86535C22.4484 8.40092 22.3999 7.93648 22.3425 7.43224C22.7352 7.43224 23.0926 7.41013 23.4411 7.44551C23.5294 7.45436 23.6353 7.62686 23.675 7.74629C24.2927 9.73672 24.8971 11.7316 25.506 13.7264C25.7001 14.3545 25.8899 14.9826 26.0928 15.6372C25.9958 15.677 25.9075 15.7124 25.8193 15.7478C24.3633 16.3449 23.3264 17.3269 22.9381 18.9015C22.7837 19.5341 22.8367 20.1047 23.472 20.4762C23.525 20.5072 23.5603 20.6222 23.5558 20.6929C23.5426 20.8433 23.4985 20.9937 23.4588 21.1795H23.1279C19.682 21.1795 16.2317 21.1795 12.7858 21.1795C12.5829 21.1795 12.4549 21.1485 12.3446 20.9362C12.0181 20.3214 11.4754 20.0339 10.7783 20.0339C8.28102 20.0339 5.77934 20.0339 3.28206 20.0339H2.8938L2.89821 20.0516ZM8.03394 17.7648C7.29711 17.7648 6.56028 17.7648 5.82787 17.7648C5.40872 17.7648 5.1484 17.9904 5.15281 18.3398C5.15722 18.6671 5.41313 18.9015 5.81463 18.9015C7.27505 18.906 8.73547 18.906 10.1959 18.9015C10.5974 18.9015 10.8489 18.6715 10.8489 18.3354C10.8489 17.9815 10.6018 17.7648 10.1738 17.7648C9.45906 17.7648 8.7487 17.7648 8.03394 17.7648ZM8.56781 16.6059C9.12374 16.6059 9.67967 16.6148 10.24 16.6059C10.6195 16.5971 10.8533 16.3626 10.8489 16.0353C10.8489 15.7036 10.6106 15.4824 10.2312 15.4824C9.12815 15.4824 8.02511 15.4692 6.92649 15.4913C6.74559 15.4913 6.50734 15.6107 6.39703 15.7522C6.12348 16.1149 6.40586 16.5838 6.90443 16.6059C7.46036 16.628 8.01629 16.6103 8.57222 16.6103L8.56781 16.6059Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M10.2756 10.8829C10.1521 10.8873 10.0329 10.9006 9.91381 10.9006C6.8915 10.9006 3.86918 10.9006 0.846869 10.9006C0.158575 10.9006 0.00415039 10.7414 0.00415039 10.0514C0.00415039 7.79112 0.00415039 5.53529 0.00415039 3.27505V2.89465H1.73371C1.73371 3.08485 1.72488 3.27062 1.73371 3.4564C1.74694 3.76602 1.96314 3.9916 2.24993 4.01372C2.52789 4.03583 2.78821 3.83237 2.83233 3.52717C2.86322 3.32813 2.8588 3.12908 2.87204 2.89908H7.42978C7.42978 3.03177 7.42978 3.18658 7.42978 3.33697C7.4386 3.7439 7.67686 4.02256 8.01218 4.01372C8.33868 4.00487 8.5637 3.73948 8.56811 3.34582C8.56811 3.20428 8.56811 3.05831 8.56811 2.89465H10.2712V10.8829H10.2756Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.4645 21.8582C31.3322 23.7336 29.9379 25.1491 28.1334 25.2154C25.8832 25.295 24.1536 23.1852 24.661 20.9824C24.7228 20.717 24.8199 20.602 25.1243 20.6064C27.0524 20.6241 28.9805 20.6241 30.9086 20.6064C31.1954 20.6064 31.3101 20.7082 31.341 20.9691C31.3763 21.2655 31.4248 21.5619 31.4645 21.8626V21.8582Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M4.62678 21.1986H4.97534C6.88138 21.1986 8.78743 21.1986 10.6935 21.1986C11.2494 21.1986 11.4744 21.4242 11.4391 21.9682C11.3156 23.9144 9.68309 25.3387 7.75058 25.2281C6.02543 25.1308 4.54736 23.5473 4.57384 21.7515C4.57384 21.5746 4.60913 21.4021 4.63119 21.1986H4.62678Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.9999 19.4743H24.0095C24.0272 18.8727 24.2743 18.3817 24.636 17.9527C25.3243 17.1344 26.1935 16.6567 27.2701 16.6346C27.9672 16.6213 28.6908 16.5815 29.3659 16.7275C30.6851 17.0194 31.6072 17.82 31.9646 19.1823C31.9867 19.2664 31.9867 19.3548 31.9999 19.4743Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M0.0039219 1.70243C0.0039219 1.31319 -0.00490238 0.946069 0.0039219 0.578945C0.0127462 0.260476 0.228941 0.0393172 0.542203 0.00393172C0.630445 -0.00491465 0.718688 0.00393172 0.811343 0.00393172C3.69688 0.00393172 6.58683 0.00393172 9.47237 0.00393172C10.121 0.00393172 10.2974 0.185282 10.3019 0.844336C10.3019 1.123 10.3019 1.40166 10.3019 1.71128H0.0039219V1.70243Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M25.1394 4.01562V6.28029C25.0379 6.28914 24.9497 6.30241 24.8658 6.30241C23.8422 6.30241 22.8142 6.30683 21.7906 6.30241C21.0802 6.30241 20.5684 5.82028 20.564 5.16565C20.5596 4.50217 21.0846 4.01562 21.8082 4.01562C22.9113 4.01562 24.0099 4.01562 25.1394 4.01562Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M11.4383 10.8974C11.4383 10.4595 11.425 10.0836 11.4383 9.70318C11.4559 9.38028 11.65 9.18124 11.9721 9.17682C12.6737 9.16355 13.3752 9.16355 14.0767 9.18124C14.4959 9.19451 14.8224 9.54836 14.8533 9.95972C14.8841 10.3932 14.6018 10.7957 14.1694 10.8532C13.8076 10.9019 13.437 10.8886 13.0707 10.893C12.5369 10.8974 12.003 10.893 11.4338 10.893L11.4383 10.8974Z"
                                            fill="#F9AD76" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['customer_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.customer')); ?></div>
                            </div>
                        </div>

                        <div class="right-side d-flex word-nowrap align-items-center">
                            <img class="onerror-image"
                                data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>"
                                src="<?php echo e(\App\CentralLogics\Helpers::iconFullUrl()); ?>"
                                alt="image">
                            <?php echo e(translate('messages.Still increasing')); ?>

                        </div>
                    </div>
                    <div class="counter-bg"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Counter Section Ends Here ==== -->

    <!-- ==== Download App Starts Here ==== -->
    <?php ($landing_page_links = $landing_data['download_user_app_links']); ?>
    <?php if(
        (isset($landing_page_links['playstore_url_status']) && $landing_page_links['playstore_url_status'] == '1') ||
            (isset($landing_page_links['apple_store_url_status']) && $landing_page_links['apple_store_url_status'] == '1')): ?>
       <section class="download-app-section">
            <div class="container">
                <div class="row justify-content-center align-items-center g-4">
                    <div class="col-lg-6 col-md-9">
                        <div class="download-app-content wow fadeInUp">
                            <h2 class="title">
                                
                                <div class="primary-color">
                                    <?php echo e(translate('Lets')); ?>

                                </div>
                                <?php echo e(translate('Manage_your_business')); ?>

                                <div class="primary-color">
                                    <?php echo e(translate('Smartly_or_Earn')); ?>

                                </div>
                            </h2>
                            
                            <div class="btn-grp">
                            </div>
                            <div class="position-relative dropdown text-capitalize">
                                <button type="button" class="cmn--btn border-0 w-75 w-sm-50 d-flex justify-content-between align-items-center"
                                    data-bs-toggle="dropdown">
                                    <?php echo e(translate('User App')); ?>

                                    <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                            fill="#ffffff"></path>
                                    </svg>
                                </button>
                                <div class="dropdown-menu p-0 w-75 w-sm-50">
                                    <?php if(isset($landing_page_links['playstore_url_status']) && $landing_page_links['playstore_url_status'] == '1'): ?>
                                        <a href="<?php echo e($landing_page_links['playstore_url']); ?>" class="dropdown-item">
                                            <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                                alt="">
                                            <?php echo e(translate('google_play')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(isset($landing_page_links['apple_store_url_status']) && $landing_page_links['apple_store_url_status'] == '1'): ?>
                                        <a href="<?php echo e($landing_page_links['apple_store_url']); ?>" class="dropdown-item">
                                            <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                                alt="">
                                            <?php echo e(translate('apple_store')); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-9">
                        <img class="mw-100"
                            src="<?php echo e(\App\CentralLogics\Helpers::get_full_url('download_user_app_image', isset($landing_data['download_user_app_image']) ? $landing_data['download_user_app_image'] : null, isset($landing_data['download_user_app_image_storage']) ? $landing_data['download_user_app_image_storage'] : 'public')); ?>"
                            alt="">
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Download App Ends Here ==== -->

    <!-- ==== Testimonial Starts Here ==== -->
    <?php ($testimonial = $landing_data['testimonials']); ?>
    <?php if($testimonial && count($testimonial) > 0): ?>
        <section class="testimonial-section overflow-hidden position-relative pt-80 pb-80">
            <div class="container">
                <div class="section-header wow fadeInUp mb-0">
                    <h2 class="title mb-0">
                        <?php echo e($landing_data['testimonial_title']); ?>


                    </h2>
                </div>
                <div class="testimonial-slider overflow-hidden owl-theme owl-carousel wow fadeInUp">
                    <?php $__currentLoopData = $testimonial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="testimonial-item">
                            <svg width="24" height="20" viewBox="0 0 24 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M14.1 19.5V11.24C14.1 8.25333 15.0333 5.87333 16.9 4.1C18.8133 2.28 21.0767 1.16 23.69 0.739996V4.03C22.43 4.45 21.31 5.22 20.33 6.34C19.3967 7.46 18.93 8.81333 18.93 10.4H23.55V19.5H14.1ZM0.24 19.5V11.24C0.24 8.25333 1.17333 5.87333 3.04 4.1C4.95333 2.28 7.21667 1.16 9.83 0.739996V4.03C8.57 4.45 7.45 5.22 6.47 6.34C5.53667 7.46 5.07 8.81333 5.07 10.4H9.69V19.5H0.24Z"
                                    fill="#71DAA6" />
                            </svg>
                            <blockquote>
                                <?php echo e($data['review']); ?>

                            </blockquote>
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="user">
                                    <img src="<?php echo e($data['reviewer_image_full_url']); ?>" alt="image">
                                    <div>
                                        <h6 class="name"><?php echo e($data['name']); ?></h6>
                                        <span class="designation"><?php echo e($data['designation']); ?></span>
                                    </div>
                                </div>
                                <?php if(isset($data['company_image'])): ?>
                                    <img style="max-height: 35px; max-width:75px"
                                        src="<?php echo e($data['company_image_full_url']); ?>" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <svg class="testimonial-shape" viewBox="0 0 1362 379" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M213.286 24.3464L208.81 15.9086C207.191 12.8576 206.852 9.92199 207.793 7.10169C208.756 4.2085 210.454 1.84123 212.889 -0.000116383L214.672 3.3607C213.616 4.47068 212.892 5.86253 212.501 7.53626C212.157 9.18476 212.415 10.8194 213.275 12.4402L217.981 9.94347L222.913 19.2394L213.286 24.3464ZM199.166 31.8367L194.69 23.3989C193.072 20.3479 192.733 17.4123 193.673 14.592C194.636 11.6988 196.335 9.33153 198.77 7.49017L200.552 10.851C199.496 11.961 198.773 13.3528 198.381 15.0265C198.037 16.6751 198.295 18.3097 199.155 19.9305L203.862 17.4338L208.793 26.7296L199.166 31.8367Z"
                        fill="url(#paint0_linear_28_12)" />
                    <path
                        d="M490 59.723L473.339 54.2489C467.315 52.2695 463.131 48.8148 460.788 43.8848C458.382 38.8299 457.618 33.5349 458.498 27.9998L465.134 30.1802C465.149 32.993 465.962 35.7562 467.573 38.4698C469.215 41.0894 471.637 42.925 474.837 43.9765L477.89 34.6833L496.246 40.7141L490 59.723ZM480.84 87.6026L464.179 82.1285C458.155 80.1492 453.971 76.6945 451.628 71.7644C449.221 66.7096 448.458 61.4146 449.338 55.8795L455.974 58.0598C455.989 60.8727 456.802 63.6359 458.413 66.3494C460.055 68.9691 462.476 70.8047 465.677 71.8562L468.73 62.563L487.085 68.5938L480.84 87.6026Z"
                        fill="url(#paint1_linear_28_12)" />
                    <path
                        d="M445.754 314.114C444.951 313.941 444.324 313.504 443.875 312.801C443.541 312.124 443.461 311.38 443.635 310.569C443.809 309.759 444.181 308.869 444.749 307.901L458.987 286.067C459.86 284.801 460.703 283.953 461.515 283.522C462.353 282.975 463.461 282.85 464.837 283.146L470.517 284.367C471.435 284.564 472.106 285.072 472.53 285.89C472.775 286.428 472.822 287.044 472.673 287.738C472.598 288.086 472.466 288.421 472.277 288.743L463.187 312.593C462.006 315.852 460.038 317.186 457.285 316.594L445.754 314.114ZM473.291 320.036C472.487 319.863 471.861 319.425 471.412 318.723C471.078 318.045 470.998 317.301 471.172 316.491C471.421 315.333 471.792 314.443 472.286 313.823L486.524 291.989C487.397 290.723 488.239 289.874 489.052 289.443C489.89 288.897 490.998 288.771 492.374 289.067L498.054 290.289C498.972 290.486 499.643 290.994 500.067 291.812C500.312 292.349 500.359 292.965 500.21 293.66C500.135 294.007 500.003 294.342 499.814 294.665L490.724 318.514C489.543 321.774 487.575 323.107 484.822 322.515L473.291 320.036Z"
                        fill="url(#paint2_linear_28_12)" />
                    <path
                        d="M824.939 377.026C824.784 377.539 824.467 377.922 823.986 378.177C823.528 378.358 823.04 378.371 822.522 378.214C822.005 378.058 821.446 377.769 820.847 377.348L807.411 366.93C806.635 366.296 806.128 365.703 805.891 365.152C805.58 364.578 805.558 363.851 805.823 362.972L806.92 359.345C807.097 358.759 807.463 358.35 808.017 358.117C808.379 357.987 808.782 357.989 809.226 358.123C809.448 358.19 809.658 358.293 809.858 358.434L824.878 365.612C826.934 366.553 827.696 367.903 827.165 369.662L824.939 377.026ZM830.254 359.44C830.099 359.953 829.781 360.337 829.301 360.591C828.843 360.773 828.355 360.785 827.837 360.629C827.097 360.405 826.539 360.117 826.162 359.763L812.726 349.345C811.949 348.71 811.443 348.117 811.206 347.566C810.895 346.992 810.872 346.266 811.138 345.386L812.234 341.759C812.412 341.173 812.777 340.764 813.332 340.532C813.694 340.401 814.097 340.403 814.541 340.537C814.762 340.604 814.973 340.708 815.173 340.848L830.193 348.026C832.249 348.968 833.011 350.317 832.48 352.076L830.254 359.44Z"
                        fill="url(#paint3_linear_28_12)" />
                    <path
                        d="M258.024 329.025C257.706 329.406 257.296 329.619 256.793 329.662C256.336 329.651 255.915 329.485 255.53 329.163C255.144 328.842 254.772 328.393 254.413 327.817L246.718 314.052C246.285 313.229 246.067 312.539 246.065 311.982C246.007 311.379 246.251 310.751 246.797 310.097L249.048 307.397C249.411 306.961 249.872 306.744 250.43 306.747C250.786 306.767 251.129 306.914 251.46 307.19C251.625 307.327 251.767 307.492 251.887 307.684L262.109 319.257C263.523 320.806 263.685 322.235 262.594 323.544L258.024 329.025ZM268.936 315.936C268.618 316.318 268.208 316.531 267.705 316.574C267.248 316.562 266.827 316.396 266.442 316.075C265.891 315.616 265.519 315.167 265.325 314.728L257.63 300.964C257.197 300.14 256.979 299.45 256.977 298.894C256.919 298.291 257.163 297.663 257.709 297.008L259.96 294.309C260.323 293.872 260.784 293.656 261.342 293.658C261.698 293.678 262.041 293.826 262.372 294.101C262.537 294.239 262.679 294.404 262.799 294.596L273.021 306.169C274.435 307.718 274.597 309.147 273.506 310.456L268.936 315.936Z"
                        fill="url(#paint4_linear_28_12)" />
                    <path
                        d="M1083 309V297.283C1083 293.762 1083.63 290.132 1084.9 286.391C1086.23 282.595 1088.02 279.02 1090.29 275.664C1092.55 272.253 1095.06 269.365 1097.82 267L1108.34 273.271C1106.24 276.682 1104.48 280.285 1103.04 284.081C1101.61 287.876 1100.89 292.25 1100.89 297.2V309H1083ZM1110.66 309V297.283C1110.66 293.762 1111.29 290.132 1112.56 286.391C1113.89 282.595 1115.68 279.02 1117.95 275.664C1120.21 272.253 1122.72 269.365 1125.48 267L1136 273.271C1133.9 276.682 1132.14 280.285 1130.7 284.081C1129.26 287.876 1128.55 292.25 1128.55 297.2V309H1110.66Z"
                        fill="url(#paint5_linear_28_12)" />
                    <path
                        d="M1333.27 72.5454L1330.13 67.2076C1329.18 65.6038 1328.6 63.7173 1328.39 61.5481C1328.19 59.3337 1328.35 57.0476 1328.86 54.6899C1329.35 52.3071 1330.13 50.0714 1331.21 47.9827L1339.43 46.9874C1339.05 49.3095 1338.92 51.5981 1339.04 53.8529C1339.17 56.1078 1339.9 58.363 1341.23 60.6184L1344.39 65.9937L1333.27 72.5454ZM1350.47 62.4146L1347.32 57.0768C1346.38 55.473 1345.8 53.5865 1345.58 51.4173C1345.39 49.2029 1345.54 46.9168 1346.05 44.5591C1346.54 42.1763 1347.33 39.9406 1348.41 37.8519L1356.63 36.8566C1356.24 39.1787 1356.11 41.4672 1356.23 43.7221C1356.36 45.977 1357.09 48.2322 1358.42 50.4876L1361.59 55.8629L1350.47 62.4146Z"
                        fill="url(#paint6_linear_28_12)" />
                    <path
                        d="M1061.7 52.7623L1053.97 50.8621C1051.65 50.2912 1049.36 49.2837 1047.1 47.8397C1044.81 46.3504 1042.74 44.5874 1040.9 42.5505C1039.01 40.5047 1037.52 38.3799 1036.4 36.1759L1042.24 30.2574C1044.15 32.194 1046.24 33.9433 1048.51 35.5054C1050.78 37.0675 1053.55 38.25 1056.82 39.0529L1064.6 40.9664L1061.7 52.7623ZM1066.18 34.5224L1058.46 32.6223C1056.13 32.0513 1053.84 31.0439 1051.58 29.5999C1049.29 28.1106 1047.23 26.3475 1045.38 24.3107C1043.5 22.2649 1042 20.14 1040.89 17.9361L1046.73 12.0176C1048.64 13.9541 1050.73 15.7035 1053 17.2656C1055.27 18.8277 1058.04 20.0102 1061.3 20.8131L1069.08 22.7266L1066.18 34.5224Z"
                        fill="url(#paint7_linear_28_12)" />
                    <path
                        d="M14.6967 358.762L6.96991 356.862C4.64825 356.291 2.357 355.284 0.0961517 353.84C-2.19202 352.35 -4.25898 350.587 -6.10473 348.551C-7.98677 346.505 -9.48389 344.38 -10.5961 342.176L-4.75508 336.257C-2.84619 338.194 -0.756616 339.943 1.51364 341.505C3.7839 343.068 6.55145 344.25 9.81629 345.053L17.5975 346.966L14.6967 358.762ZM19.1822 340.522L11.4554 338.622C9.13373 338.051 6.84248 337.044 4.58164 335.6C2.29347 334.111 0.22651 332.348 -1.61925 330.311C-3.50128 328.265 -4.9984 326.14 -6.11061 323.936L-0.269597 318.018C1.63929 319.954 3.72887 321.703 5.99913 323.266C8.26939 324.828 11.0369 326.01 14.3018 326.813L22.083 328.727L19.1822 340.522Z"
                        fill="url(#paint8_linear_28_12)" />
                    <defs>
                        <linearGradient id="paint0_linear_28_12" x1="200.945" y1="6.33637" x2="211.111"
                            y2="25.5002" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint1_linear_28_12" x1="450.749" y1="51.5849" x2="488.589"
                            y2="64.0176" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint2_linear_28_12" x1="475.508" y1="285.44" x2="468.299"
                            y2="318.962" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint3_linear_28_12" x1="807.883" y1="356.158" x2="829.291"
                            y2="362.627" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint4_linear_28_12" x1="251.025" y1="305.025" x2="266.958"
                            y2="318.309" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint5_linear_28_12" x1="1109.5" y1="267" x2="1109.5"
                            y2="309" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint6_linear_28_12" x1="1338.47" y1="43.7059" x2="1349.75"
                            y2="62.8392" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint7_linear_28_12" x1="1038.3" y1="28.4759" x2="1065.99"
                            y2="35.287" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint8_linear_28_12" x1="-8.70253" y1="334.476" x2="18.9942"
                            y2="341.287" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>

        </section>
    <?php endif; ?>
    <!-- ==== Testimonial Ends Here ==== -->

    <?php if(isset($new_user) && $new_user == true): ?>
        <!-- Modal -->
        <div class="modal fade show" id="welcome-modal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0">
                    <div class="modal-header border-0 pt-4 px-4">
                        <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-sm-5 pb-5">
                        <div class="text-center">
                            <img src="<?php echo e(asset('/public/assets/landing/img/welcome.svg')); ?>" class="mw-100 mb-3"
                                alt="">
                            <h5 class="mb-3"><?php echo e(translate('Welcome_to')); ?> <?php echo e($business_name); ?>!</h5>
                            <p class="m-0 mb-4">
                                <?php echo e(translate('Thanks for joining us! Your registration is under review. Hang tight, we’ll notify you once approved!')); ?>

                            </p>
                            <button type="button" class="border-0 outline-0 shadow-none cmn--btn"
                                data-bs-dismiss="modal">
                                <?php echo e(translate('okay')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).ready(function() {
            $('#welcome-modal').modal('show');
        });
    </script>
    <script>
        "use strict";
        $(document).ready(function() {
            "use strict";
            $('.onerror-image').on('error', function() {
                let img = $(this).data('onerror-image')
                $(this).attr('src', img);
            });
        });
    </script>
    <script>
        var tooltipTriggerList = [].slice.call(
            document.querySelectorAll('[data-bs-toggle="tooltip"]')
        );
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))

        var popoverList = popoverTriggerList.map(function(popoverTriggerEl) {
            return new bootstrap.Popover(popoverTriggerEl)
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.landing.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\6ammart37\resources\views/home.blade.php ENDPATH**/ ?>