<?php $__env->startSection('title', translate('messages.add_store_name')); ?>



<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/store.png')); ?>" class="w--26" alt="">
                </span>
                <span>
                    <?php echo e(translate('messages.add_new_store')); ?>

                </span>
            </h1>
        </div>

        <?php ($language = \App\CentralLogics\Helpers::get_business_settings('language')); ?>
        <!-- End Page Header -->
         <form class="validate-form global-ajax-form" action="<?php echo e(route('admin.store.store')); ?>" method="post" enctype="multipart/form-data">
            <div class="card mb-20">
                <div class="card-header">
                    <div class="mb-0">
                        <h3 class="mb-1">
                            <?php echo e(translate('Basic Information')); ?>

                        </h3>
                        <p class="mb-0 fs-12">
                            <?php echo e(translate('Here you setup your all business information.')); ?>

                        </p>
                    </div>
                </div>
                <div class="card-body p-xxl-20 p-3">
                    <div class="row g-3">
                        <div class="col-lg-7">
                            <div class="shadow-sm p-xxl-20 p-sm-3 p-0">
                                <div class="bg-light2 rounded p-3 mb-20">
                                    <?php if($language): ?>
                                        <ul class="nav nav-tabs mb-4">
                                            <li class="nav-item">
                                                <a class="nav-link lang_link active" href="#"
                                                    id="default-link"><?php echo e(translate('Default')); ?></a>
                                            </li>
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="nav-item">
                                                    <a class="nav-link lang_link" href="#"
                                                        id="<?php echo e($lang); ?>-link"><?php echo e(\App\CentralLogics\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')'); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                    <?php if($language): ?>
                                        <div class="lang_form" id="default-form">
                                            <div class="form-group error-wrapper">
                                                <label class="input-label" for="default_name"><?php echo e(translate('messages.Business name')); ?>

                                                    (<?php echo e(translate('messages.Default')); ?>) <span
                                                        class="form-label-secondary text-danger" data-toggle="tooltip"
                                                        data-placement="right"
                                                        data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                                    </span>
                                                </label>
                                                <input type="text" name="name[]" id="default_name" class="form-control"
                                                    placeholder="<?php echo e(translate('Business name')); ?>" required>
                                            </div>
                                            <input type="hidden" name="lang[]" value="default">
                                            <div class="form-group mb-0 error-wrapper">
                                                <label class="input-label"
                                                    for="exampleFormControlInput1"><?php echo e(translate('messages.Business address')); ?>

                                                    (<?php echo e(translate('messages.default')); ?>)<span
                                                        class="form-label-secondary text-danger" data-toggle="tooltip"
                                                        data-placement="right"
                                                        data-original-title="<?php echo e(translate('Add your store’s official address for accurate location and delivery.')); ?>"> *
                                                        <i class="tio-info text-muted"></i>
                                                    </span>




                                                </label>
                                                <textarea required type="text" id="address" name="address[]" placeholder="<?php echo e(translate('messages.Business address')); ?>"
                                                    class="form-control min-h-90px"></textarea>

                                            </div>
                                        </div>
                                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="d-none lang_form" id="<?php echo e($lang); ?>-form">
                                                <div class="form-group error-wrapper">
                                                    <label class="input-label"
                                                        for="<?php echo e($lang); ?>_name"><?php echo e(translate('messages.Business name')); ?>

                                                        (<?php echo e(strtoupper($lang)); ?>)
                                                    </label>
                                                    <input type="text" name="name[]" id="<?php echo e($lang); ?>_name"
                                                        class="form-control" placeholder="<?php echo e(translate('Business name')); ?>">
                                                </div>
                                                <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                                                <div class="form-group mb-0 error-wrapper">
                                                    <label class="input-label"
                                                        for="exampleFormControlInput1"><?php echo e(translate('messages.Business address')); ?>

                                                        (<?php echo e(strtoupper($lang)); ?>) <span
                                                        class="form-label-secondary text-danger" data-toggle="tooltip"
                                                        data-placement="right"
                                                        data-original-title="<?php echo e(translate('Add your store’s official address for accurate location and delivery.')); ?>">
                                                        <i class="tio-info text-muted"></i>
                                                    </span></label>
                                                    <textarea type="text" name="address[]" placeholder="<?php echo e(translate('messages.Business address')); ?>"
                                                        class="form-control min-h-90px"></textarea>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php endif; ?>
                                </div>
                                <div class="form-group error-wrapper">
                                    <label class="input-label"
                                        for="choice_zones"><?php echo e(translate('messages.Business zone')); ?><span
                                            class="form-label-secondary" data-toggle="tooltip" data-placement="right"
                                            data-original-title="<?php echo e(translate('messages.select_zone_for_map')); ?>"></span>
                                        <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                            data-placement="right"
                                            data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                        </span>
                                    </label>
                                    <select name="zone_id" id="choice_zones" required
                                        class="form-control js-select2-custom"
                                        data-placeholder="<?php echo e(translate('messages.select_zone')); ?>">
                                        <option value="" selected disabled>
                                            <?php echo e(translate('messages.select_zone')); ?></option>
                                        <?php $__currentLoopData = \App\Models\Zone::active()->get(['id', 'name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset(auth('admin')->user()->zone_id)): ?>
                                                <?php if(auth('admin')->user()->zone_id == $zone->id): ?>
                                                    <option value="<?php echo e($zone->id); ?>"><?php echo e($zone->name); ?></option>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <option value="<?php echo e($zone->id); ?>"><?php echo e($zone->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="position-relative">
                                    <label class="input-label"
                                        for="tax"><?php echo e(translate('Estimated Delivery Time ( Min & Maximum Time)')); ?>

                                        <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                            data-placement="right"
                                            data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                        </span></label>

                                    <div class="floating--date-inner time-delivery-vendor bg-white rounded border d-flex align-items-center">
                                        <div class="item error-wrapper w-100">
                                            <input id="minimum_delivery_time" type="number"
                                                name="minimum_delivery_time" class="form-control w-100 h--45px border-0 outline-0"
                                                placeholder="<?php echo e(translate('messages.Ex :')); ?> 30"
                                                pattern="^[0-9]{2}$" required
                                                value="<?php echo e(old('minimum_delivery_time')); ?>">
                                        </div>
                                        <div class="item error-wrapper border-left w-100">
                                            <input id="maximum_delivery_time" type="number"
                                                name="maximum_delivery_time" class="form-control w-100 h--45px border-0 outline-0"
                                                placeholder="<?php echo e(translate('messages.Ex :')); ?> 60"
                                                pattern="[0-9]{2}" required
                                                value="<?php echo e(old('maximum_delivery_time')); ?>">
                                        </div>
                                        <div class="item smaller">
                                            <select name="delivery_time_type" id="delivery_time_type"
                                                class="custom-select min-w-90 bg-light2 h--45px border-0 outline-0">
                                                <option value="min"><?php echo e(translate('messages.minutes')); ?>

                                                </option>
                                                <option value="hours"><?php echo e(translate('messages.hours')); ?>

                                                </option>
                                                <option value="days"><?php echo e(translate('messages.days')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="bg-light2 rounded p-xxl-20 p-3">
                                <div class="mb-15">
                                    <h4 class="mb-1">
                                        <?php echo e(translate('Set Business Location on Map')); ?>

                                    </h4>
                                    <p class="mb-0 fs-12">
                                        <?php echo e(translate('Please mark the exact business location to help customers find it easily.')); ?>

                                    </p>
                                </div>
                                <div class="map-for-vndor map_custom-controls position-relative">
                                    <input id="pac-input" class="controls rounded initial-8" title="<?php echo e(translate('messages.search_your_location_here')); ?>" type="text" placeholder="<?php echo e(translate('messages.search_here')); ?>"/>
                                   <div id="map"></div>


                                   <div class="d-flex bg-white align-items-center gap-1 laglng-controller">
                                                <div id="latlng" class="d-flex">
                                                    <input type="text" id="latitude" name="latitude" class="border-0 p-0 m-0 text-center outline-0"
                                                placeholder="<?php echo e(translate('messages.Ex:')); ?> -94.22213"
                                                value="<?php echo e(old('latitude')); ?>" readonly>
                                                    <span class="text-gray1">|</span>
                                                    <input type="text" name="longitude" class="border-0 p-0 m-0 text-center outline-0"
                                                placeholder="<?php echo e(translate('messages.Ex:')); ?> 103.344322" id="longitude"
                                                value="<?php echo e(old('longitude')); ?>" readonly>
                                                </div>
                                    </div>
                                   <div id="outOfZone" class="map-alert bg-dark d-flex align-items-center rounded-8 py-2 px-2 fs-12 text-white mb-2">
                                        <img class="" src="<?php echo e(asset('public/assets/admin/img/icons/warning-cus.png')); ?>" alt="img"> <?php echo e(translate('Please place the marker inside the available zones.')); ?>

                                   </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mb-20">
                <div class="card-header">
                    <div class="mb-0">
                        <h3 class="mb-1">
                            <?php echo e(translate('General Setup')); ?>

                        </h3>
                        <p class="mb-0 fs-12">
                            <?php echo e(translate('Setup your all business general settings')); ?>

                        </p>
                    </div>
                </div>
                <div class="card-body p-xxl-20 p-3">
                    <div class="shadow-sm p-xxl-20 p-sm-3 p-0 mb-20">
                        <div class="mb-15">
                            <h4 class="mb-1">
                                <?php echo e(translate('Business Logo & Covers')); ?>

                            </h4>
                            <p class="mb-0 fs-12">
                                <?php echo e(translate('Format : Jpg, jpeg, png, gif, webp. Less Than 2MB')); ?>

                            </p>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="bg-light2 rounded p-20">
                                    <div class="mb-15 text-center">
                                        <h4 class="mb-0"><?php echo e(translate('Business Cover')); ?> <span class="text-danger">*</span></h4>
                                    </div>
                                    <div class="mx-auto text-center error-wrapper">
                                        <div class="upload-file_custom ratio-2-1 h-100px">
                                            <input type="file" name="cover_photo"
                                                    class="upload-file__input single_file_input"
                                                    accept=".webp, .jpg, .jpeg, .png, .gif" required>
                                            <label class="upload-file__wrapper w-100 h-100 m-0">
                                                <div class="upload-file-textbox text-center" style="">
                                                    <img width="22" class="svg"
                                                            src="<?php echo e(asset('public/assets/admin/img/document-upload.svg')); ?>"
                                                            alt="img">
                                                    <h6
                                                        class="mt-1 color-656566 fw-medium fs-10 lh-base text-center">
                                                        <span class="theme-clr"><?php echo e(translate('Add Image')); ?></span>
                                                        <br class="mb-1">
                                                         <?php echo e(translate('Ratio (2:1)')); ?>

                                                    </h6>
                                                </div>
                                                <img class="upload-file-img" loading="lazy" src=""
                                                        data-default-src="" alt="" style="display: none;">
                                            </label>
                                            <div class="overlay">
                                                <div
                                                    class="d-flex gap-1 justify-content-center align-items-center h-100">
                                                    <button type="button"
                                                            class="btn btn-outline-info icon-btn view_btn">
                                                        <i class="tio-invisible"></i>
                                                    </button>
                                                    <button type="button"
                                                            class="btn btn-outline-info icon-btn edit_btn">
                                                        <i class="tio-edit"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="bg-light2 rounded p-20">
                                    <div class="mb-15 text-center">
                                        <h4 class="mb-0"><?php echo e(translate('Business Logo')); ?> <span class="text-danger">*</span></h4>
                                    </div>
                                    <div class="mx-auto text-center error-wrapper">
                                        <div class="upload-file_custom ratio-1 h-100px">
                                            <input type="file" name="logo"
                                                    class="upload-file__input single_file_input"
                                                    accept=".webp, .jpg, .jpeg, .png, .gif" required>
                                            <label class="upload-file__wrapper w-100 h-100 m-0">
                                                <div class="upload-file-textbox text-center" style="">
                                                    <img width="22" class="svg"
                                                            src="<?php echo e(asset('public/assets/admin/img/document-upload.svg')); ?>"
                                                            alt="img">
                                                    <h6
                                                        class="mt-1 color-656566 fw-medium fs-10 lh-base text-center">
                                                        <span class="theme-clr"><?php echo e(translate('Add Image')); ?></span>
                                                        <br class="mb-1">
                                                       <?php echo e(translate('Ratio (1:1)')); ?>

                                                    </h6>
                                                </div>
                                                <img class="upload-file-img" loading="lazy" src=""
                                                        data-default-src="" alt="" style="display: none;">
                                            </label>
                                            <div class="overlay">
                                                <div
                                                    class="d-flex gap-1 justify-content-center align-items-center h-100">
                                                    <button type="button"
                                                            class="btn btn-outline-info icon-btn view_btn">
                                                        <i class="tio-invisible"></i>
                                                    </button>
                                                    <button type="button"
                                                            class="btn btn-outline-info icon-btn edit_btn">
                                                        <i class="tio-edit"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="shadow-sm p-xxl-20 p-sm-3 p-0 mb-20">
                        <div class="mb-20">
                            <h4 class="mb-1">
                                <?php echo e(translate('Business Owner Info')); ?>

                            </h4>
                            <p class="mb-0 fs-12">
                                <?php echo e(translate('Setup your business information')); ?>

                            </p>
                        </div>
                        <div class="bg-light2 rounded p-xxl-20 p-3">
                            <div class="row g-3">
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group mb-0 error-wrapper">
                                        <label class="input-label" for="f_name"><?php echo e(translate('messages.first_name')); ?>

                                            <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <input type="text" name="f_name" class="form-control"
                                            placeholder="<?php echo e(translate('messages.first_name')); ?>"
                                            value="<?php echo e(old('f_name')); ?>" required>

                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group mb-0 error-wrapper">
                                        <label class="input-label"
                                            for="l_name"><?php echo e(translate('messages.last_name')); ?><span
                                                class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <input type="text" name="l_name" class="form-control"
                                            placeholder="<?php echo e(translate('messages.last_name')); ?>"
                                            value="<?php echo e(old('l_name')); ?>" required>

                                    </div>

                                </div>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-group mb-0 error-wrapper">
                                        <label class="input-label" for="phone"><?php echo e(translate('messages.phone')); ?><span
                                                class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <input type="tel" id="phone" name="phone" class="form-control"
                                            placeholder="<?php echo e(translate('messages.Ex:')); ?> 017********" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="shadow-sm p-xxl-20 p-sm-3 p-0 mb-20">
                        <div class="mb-20">
                            <h4 class="mb-1">
                                <?php echo e(translate('Account Information')); ?>

                            </h4>
                            <p class="mb-0 fs-12">
                                <?php echo e(translate('Setup your account credentials')); ?>

                            </p>
                        </div>
                        <div class="bg-light2 rounded p-xxl-20 p-3">
                            <div class="row g-3">
                                <div class="col-md-4 col-12">
                                    <div class="form-group mb-0 error-wrapper">
                                        <label class="input-label" for="email"><?php echo e(translate('messages.email')); ?><span
                                                class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <input type="email" name="email" class="form-control"
                                            placeholder="<?php echo e(translate('messages.Ex:')); ?> ex@example.com"
                                            value="<?php echo e(old('email')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4 col-12">
                                    <div class="form-group error-wrapper mb-0">
                                        <label class="input-label"
                                            for="signupSrPassword"><?php echo e(translate('messages.password')); ?><span
                                                class="form-label-secondary" data-toggle="tooltip" data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Must_contain_at_least_one_number_and_one_uppercase_and_lowercase_letter_and_symbol,_and_at_least_8_or_more_characters')); ?>"><img
                                                    src="<?php echo e(asset('/public/assets/admin/img/info-circle.svg')); ?>"
                                                    alt="<?php echo e(translate('messages.Must_contain_at_least_one_number_and_one_uppercase_and_lowercase_letter_and_symbol,_and_at_least_8_or_more_characters')); ?>"></span>
                                            <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>

                                        <div class="input-group input-group-merge">
                                            <input type="password" class="js-toggle-password form-control"
                                                name="password" id="signupSrPassword"
                                                pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}"
                                                title="<?php echo e(translate('messages.Must_contain_at_least_one_number_and_one_uppercase_and_lowercase_letter_and_symbol,_and_at_least_8_or_more_characters')); ?>"
                                                placeholder="<?php echo e(translate('messages.password_length_placeholder', ['length' => '8+'])); ?>"
                                                aria-label="8+ characters required" required
                                                data-msg="Your password is invalid. Please try again."
                                                data-hs-toggle-password-options='{
                                            "target": [".js-toggle-password-target-1", ".js-toggle-password-target-2"],
                                            "defaultClass": "tio-hidden-outlined",
                                            "showClass": "tio-visible-outlined",
                                            "classChangeTarget": ".js-toggle-passowrd-show-icon-1"
                                            }'>
                                            <div class="js-toggle-password-target-1 input-group-append">
                                                <a class="input-group-text" href="javascript:">
                                                    <i class="js-toggle-passowrd-show-icon-1 tio-visible-outlined"></i>
                                                </a>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-4 col-12">
                                    <div class="form-group error-wrapper mb-0">
                                        <label class="input-label"
                                            for="signupSrConfirmPassword"><?php echo e(translate('messages.confirm_password')); ?><span
                                                class="form-label-secondary text-danger" data-toggle="tooltip"
                                                data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <div class="input-group input-group-merge">
                                            <input type="password" class="js-toggle-password form-control"
                                                name="confirmPassword" id="signupSrConfirmPassword"
                                                pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}"
                                                title="<?php echo e(translate('messages.Must_contain_at_least_one_number_and_one_uppercase_and_lowercase_letter_and_symbol,_and_at_least_8_or_more_characters')); ?>"
                                                placeholder="<?php echo e(translate('messages.password_length_placeholder', ['length' => '8+'])); ?>"
                                                aria-label="8+ characters required" required
                                                data-msg="Password does not match the confirm password."
                                                data-hs-toggle-password-options='{
                                                    "target": [".js-toggle-password-target-1", ".js-toggle-password-target-2"],
                                                    "defaultClass": "tio-hidden-outlined",
                                                    "showClass": "tio-visible-outlined",
                                                    "classChangeTarget": ".js-toggle-passowrd-show-icon-2"
                                                    }'>
                                            <div class="js-toggle-password-target-2 input-group-append">
                                                <a class="input-group-text" href="javascript:">
                                                    <i class="js-toggle-passowrd-show-icon-2 tio-visible-outlined"></i>
                                                </a>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="shadow-sm p-xxl-20 p-sm-3 p-0">
                        <div class="mb-20">
                            <h4 class="mb-1">
                                <?php echo e(translate('Business TIN')); ?>

                            </h4>
                            <p class="mb-0 fs-12">
                                <?php echo e(translate('Setup your Business TIN')); ?>

                            </p>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-8 col-xxl-9">
                                <div class="bg-light2 rounded p-xxl-20 p-3 h-100">
                                    <div class="form-group  error-wrapper">
                                        <label class="input-label mb-2 d-block title-clr fw-normal"
                                            for="exampleFormControlInput1"><?php echo e(translate('Taxpayer Identification Number(TIN)')); ?>

                                        </label>
                                        <input type="text" name="tin"
                                            placeholder="<?php echo e(translate('Type Your Taxpayer Identification Number(TIN)')); ?>"
                                            class="form-control">
                                    </div>
                                    <div class="form-group mb-0  error-wrapper">
                                        <label class="input-label mb-2 d-block title-clr fw-normal"
                                            for="exampleFormControlInput1"><?php echo e(translate('Expire Date')); ?> </label>
                                        <input type="date"  name="tin_expire_date" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-xxl-3">
                                <div class="bg-light2 rounded p-xxl-20 p-3 h-100 single-document-uploaderwrap">
                                    <div class="d-flex align-items-center gap-1 justify-content-center text-center mb-20">
                                        <div>
                                            <h4 class="mb-1 fz--14px"><?php echo e(translate('TIN Certificate')); ?></h4>
                                            <p class="fz-12px mb-0">
                                                <?php echo e(translate('pdf, doc, jpg. File size : max 2 MB')); ?></p>
                                        </div>
                                        <!-- <div class="d-flex gap-3 align-items-center">
                                            <button type="button" id="doc_edit_btn"
                                                class="w-30px h-30 rounded d-flex align-items-center justify-content-center btn--primary btn px-3 icon-btn">
                                                <i class="tio-edit"></i>
                                            </button>
                                        </div> -->
                                    </div>
                                    <div class="form-group max-w-280 mx-auto error-wrapper position-relative">
                                        <button type="button" id="doc_edit_btn"
                                            class="w-30px h-30 rounded d-flex align-items-center justify-content-center btn--primary btn px-3 icon-btn position-absolute edit__icon-fortin ">
                                            <i class="tio-edit"></i>
                                            
                                        </button>
                                        
                                        <div id="file-assets"
                                            data-picture-icon="<?php echo e(asset('public/assets/admin/img/picture.svg')); ?>"
                                            data-document-icon="<?php echo e(asset('public/assets/admin/img/document.svg')); ?>"
                                            data-blank-thumbnail="<?php echo e(asset('public/assets/admin/img/picture.svg')); ?>">
                                        </div>
                                        <!-- Upload box -->
                                        <div class="d-flex justify-content-center mb-2" id="pdf-container">
                                            <div class="document-upload-wrapper" id="doc-upload-wrapper">
                                                <input type="file" name="tin_certificate_image"
                                                    class="document_input" accept=".doc, .pdf, .jpg, .png, .jpeg"
                                                    data-max-size="2mb">
                                                <div class="textbox">
                                                    <img width="40" height="40" class="svg"
                                                        src="<?php echo e(asset('public/assets/admin/img/doc-uploaded.png')); ?>"
                                                        alt="">
                                                    <p class="fs-12 mb-0 px-1 text-center">
                                                        <?php echo e(translate('messages.Select_a_file_or')); ?> <span
                                                            class="font-semibold"><?php echo e(translate('messages.Drag & Drop')); ?></span>
                                                        <?php echo e(translate('messages.here')); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="btn--container justify-content-end mt-4">
                <button type="reset" id="reset_btn"
                    class="btn btn--reset"><?php echo e(translate('messages.reset')); ?></button>
                <button type="submit" id="submitButton"
                    class="btn btn--primary"><i class="tio-save"></i> <?php echo e(translate('messages.Save Information')); ?></button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <?php ($default_location =  \App\CentralLogics\Helpers::get_business_settings('default_location') ?? ''); ?>

    <script>
        const getAllModules ="<?php echo e(route('restaurant.get-all-modules')); ?>";
         const getModuleType ="<?php echo e(route('restaurant.get-module-type')); ?>";
         const checkModuleTypeUrl ="<?php echo e(route('restaurant.check-module-type')); ?>";
        const estimatedPickupText =
        "<?php echo e(translate('messages.Estimated_pickup_time')); ?> <span class='text-danger'>*</span>";
        const approxDeliveryText =
        "<?php echo e(translate('messages.approx_delivery_time')); ?> <span class='text-danger'>*</span>";

        window.mapConfig = {
            mapApiKey: "<?php echo e(\App\CentralLogics\Helpers::get_business_settings('map_api_key')); ?>",
            defaultLocation: <?php echo json_encode($default_location); ?>,
            oldLat: parseFloat("<?php echo e(old('latitude')); ?>"),
            oldLng: parseFloat("<?php echo e(old('longitude')); ?>"),
            oldZoneId: "<?php echo e(old('zone_id')); ?>",
            oldAddress: <?php echo json_encode(old('address.0'), 15, 512) ?>,
            translations: {
                selectedLocation: "<?php echo e(translate('Selected Location')); ?>",
                clickMap: "<?php echo e(translate('Click_the_map_inside_the_red_marked_area_to_get_Lat/Lng!!!')); ?>",
                selectZone: "<?php echo e(translate('Select_Zone_From_The_Dropdown')); ?>",
                geolocationError: "<?php echo e(translate('Error:_Your_browser_doesnot_support_geolocation.')); ?>",
                outOfZone: "<?php echo e(translate('messages.out_of_coverage')); ?>",
            },
            urls: {
                zoneCoordinates: "<?php echo e(route('admin.zone.get-coordinates', ['id' => ':coordinatesZoneId'])); ?>",
                zoneGetZone: "<?php echo e(route('admin.zone.get-zone')); ?>",
            }
        };
    </script>


    <script src="<?php echo e(asset('public/assets/admin/js/file-preview/pdf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/file-preview/pdf-worker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/file-preview/add-multiple-document-upload.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/view-pages/map-functionality.js')); ?>"></script>

    <script src="<?php echo e(asset('public/assets/admin/js/spartan-multi-image-picker.js')); ?>"></script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(\App\CentralLogics\Helpers::get_business_settings('map_api_key')); ?>&libraries=drawing,places,marker,geometry&v=3.61&language=<?php echo e(str_replace('_', '-', app()->getLocale())); ?>&callback=initMap"
        async defer>
    </script>

    <script>
        "use strict";

        $(document).on('ready', function() {
            <?php if(isset(auth('admin')->user()->zone_id)): ?>
                $('#choice_zones').trigger('change');
            <?php endif; ?>
        });


        $('#reset_btn').click(function() {
             $('#choice_zones').val(null).trigger('change');
            zonePolygon.setMap(null);
            $('#latitude').val(null);
            $('#longitude').val(null);
        })
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\6ammart37\resources\views/admin-views/vendor/index.blade.php ENDPATH**/ ?>