<?php $__env->startSection('title', translate('messages.add_new_item')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(asset('public/assets/admin/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/admin/css/AI/animation/product/ai-sidebar.css')); ?>" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/admin/css/custom.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/admin/css/upload-single-image.css')); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php ($module_type = \App\CentralLogics\Helpers::get_store_data()->module->module_type); ?>
    <?php (Config::set('module.current_module_type', $module_type)); ?>
    <?php ($openai_config = \App\CentralLogics\Helpers::get_business_settings('openai_config')); ?>

    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/items.png')); ?>" class="w--22" alt="">
                </span>
                <span>
                    <?php echo e(translate('messages.add_new_item')); ?>

                </span>
            </h1>
        </div>
        <!-- End Page Header -->
        <form id="item_form" enctype="multipart/form-data" class="validate-form" data-ajax="true">
            <input type="hidden" id="request_type" value="vendor">
            <input type="hidden" id="store_id" value="<?php echo e(\App\CentralLogics\Helpers::get_store_id()); ?>">
            <input type="hidden" id="module_type" value="<?php echo e($module_type); ?>">

            <div class="row g-2">
                <?php if ($__env->exists('admin-views.product.partials._title_and_discription')) echo $__env->make('admin-views.product.partials._title_and_discription', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-body d-flex flex-wrap align-items-center">
                            <div class="w-100 d-flex gap-3 flex-wrap flex-lg-nowrap">
                                <div class="flex-grow-1 mx-auto overflow-x-auto scrollbar-primary">
                                    <label class="text-dark d-block mb-4 mb-xl-5">
                                        <?php echo e(translate('messages.item_image')); ?>

                                        <small class="">( <?php echo e(translate('messages.ratio')); ?> 1:1 )</small>
                                    </label>
                                    <div class="d-flex __gap-12px __new-coba overflow-x-auto pb-2" id="coba"></div>
                                </div>

                                <div class="flex-grow-1 mx-auto pb-2 flex-shrink-0">
                                    <label class="text-dark d-block mb-4 mb-xl-5">
                                        <?php echo e(translate('messages.item_thumbnail')); ?>

                                        <?php if(Config::get('module.current_module_type') == 'food'): ?>
                                            <small class="">( <?php echo e(translate('messages.ratio')); ?> 1:1 )</small>
                                        <?php else: ?>
                                            <small class="text-danger">* ( <?php echo e(translate('messages.ratio')); ?> 1:1 )</small>
                                        <?php endif; ?>
                                    </label>
                                    <label class="d-inline-block m-0 position-relative error-wrapper">
                                        <img class="img--176 border" id="viewer"
                                            src="<?php echo e(asset('public/assets/admin/img/upload-img.png')); ?>" alt="thumbnail" />
                                        <div class="icon-file-group">
                                            <div class="icon-file"><input type="file" name="image" id="customFileEg1"
                                                    class="custom-file-input d-none"
                                                    accept=".webp, .jpg, .png, .webp, .jpeg, .gif, .bmp, .tif, .tiff|image/*" required>
                                                <i class="tio-edit"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <?php if ($__env->exists('admin-views.product.partials._category_and_general')) echo $__env->make('admin-views.product.partials._category_and_general', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php if ($__env->exists('admin-views.product.partials._price_and_stock')) echo $__env->make('admin-views.product.partials._price_and_stock', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


                <?php if($module_type == 'food'): ?>
                    <?php if ($__env->exists('admin-views.product.partials._food_variations')) echo $__env->make('admin-views.product.partials._food_variations', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php else: ?>
                    <?php if ($__env->exists('admin-views.product.partials._other_variations')) echo $__env->make('admin-views.product.partials._other_variations', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endif; ?>

                <?php if ($__env->exists('admin-views.product.partials._ai_sidebar')) echo $__env->make('admin-views.product.partials._ai_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <?php if(Config::get('module.current_module_type') == 'ecommerce'): ?>
                    <?php if ($__env->exists('admin-views.business-settings.landing-page-settings.partial._meta_data')) echo $__env->make('admin-views.business-settings.landing-page-settings.partial._meta_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endif; ?>

                <div class="col-12">
                    <div class="btn--container justify-content-end">
                        <button type="reset" id="reset_btn"
                            class="btn btn--reset"><?php echo e(translate('messages.reset')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('messages.submit')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <span id="message-enter-choice-values" data-text="<?php echo e(translate('enter_choice_values')); ?>"></span>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin')); ?>/js/tags-input.min.js"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/spartan-multi-image-picker.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin')); ?>/js/view-pages/vendor/product-index.js"></script>


    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/product-title-autofill.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/product-description-autofill.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/general-setup-autofill.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/product-others-autofill.js')); ?>"></script>
    <?php if($module_type == 'food'): ?>
        <script src="<?php echo e(asset('public/assets/admin/js/AI/products/variation-setup-auto-fill.js')); ?>"></script>
    <?php else: ?>
        <script src="<?php echo e(asset('public/assets/admin/js/AI/products/other-variation-setup-auto-fill.js')); ?>"></script>
    <?php endif; ?>
    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/seo-section-autofill.js')); ?>"></script>

    <script src="<?php echo e(asset('public/assets/admin/js/AI/products/ai-sidebar.js')); ?>"></script>

    <script src="<?php echo e(asset('/public/assets/admin/js/AI/products/compressor/image-compressor.js')); ?>"></script>
    <script src="<?php echo e(asset('/public/assets/admin/js/AI/products/compressor/compressor.min.js')); ?>"></script>



    <script>
        "use strict";


        function validateImageSize(inputSelector, imageType = "Image", maxSizeMB = 2) {
            let fileInput = $(inputSelector)[0];
            if (fileInput && fileInput.files.length > 0) {
                let fileSize = fileInput.files[0].size;
                if (fileSize > maxSizeMB * 1024 * 1024) {
                    toastr.error(`${imageType} size should not exceed ${maxSizeMB}MB`, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                    return false;
                }
            }
            return true;
        }

        mod_type = "<?php echo e($module_type); ?>";

        $(document).ready(function() {
            $("#add_new_option_button").click(function(e) {
                add_new_option_button();
            });

        });

        // INITIALIZATION OF SELECT2
        // =======================================================
        $('.js-select2-custom').each(function() {
            let select2 = $.HSCore.components.HSSelect2.init($(this));
        });

        function add_new_option_button() {
            $('#empty-variation').hide();
            count++;
            let add_option_view = `
                    <div class="__bg-F8F9FC-card view_new_option mb-2">
                        <div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <label class="form-check form--check">
                                    <input id="options[` + count + `][required]" name="options[` + count + `][required]" class="form-check-input" type="checkbox">
                                    <span class="form-check-label"><?php echo e(translate('Required')); ?></span>
                                </label>
                                <div>
                                    <button type="button" class="btn btn-danger btn-sm delete_input_button"
                                        title="<?php echo e(translate('Delete')); ?>">
                                        <i class="tio-add-to-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="row g-2">
                                <div class="col-xl-4 col-lg-6">
                                    <label for=""><?php echo e(translate('name')); ?></label>
                                    <input required name=options[` + count +
                `][name] class="form-control new_option_name" type="text" data-count="` +
                count + `">
                                </div>

                                <div class="col-xl-4 col-lg-6">
                                    <div>
                                        <label class="input-label text-capitalize d-flex align-items-center"><span class="line--limit-1"><?php echo e(translate('messages.selcetion_type')); ?> </span>
                                        </label>
                                        <div class="resturant-type-group px-0">
                                            <label class="form-check form--check mr-2 mr-md-4">
                                                <input class="form-check-input show_min_max" data-count="` + count + `" type="radio" value="multi"
                                                name="options[` + count + `][type]" id="type` + count +
                `" checked
                                                >
                                                <span class="form-check-label">
                                                    <?php echo e(translate('Multiple Selection')); ?>

                </span>
                </label>

                <label class="form-check form--check mr-2 mr-md-4">
                <input class="form-check-input hide_min_max" data-count="` + count + `" type="radio" value="single"
                    name="options[` + count + `][type]" id="type` + count +
                `"
                                                >
                                                <span class="form-check-label">
                                                    <?php echo e(translate('Single Selection')); ?>

                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-6">
                                <div class="row g-2">
                                    <div class="col-6">
                                        <label for=""><?php echo e(translate('Min')); ?></label>
                                            <input id="min_max1_` + count + `" required  name="options[` + count + `][min]" class="form-control" type="number" min="1">
                                        </div>
                                        <div class="col-6">
                                            <label for=""><?php echo e(translate('Max')); ?></label>
                                            <input id="min_max2_` + count + `"   required name="options[` + count + `][max]" class="form-control" type="number" min="1">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="option_price_` + count + `" >
                                <div class="bg-white border rounded p-3 pb-0 mt-3">
                                    <div  id="option_price_view_` + count + `">
                                        <div class="row g-3 add_new_view_row_class mb-3">
                                            <div class="col-md-4 col-sm-6">
                                                <label for=""><?php echo e(translate('Option_name')); ?></label>
                                                <input class="form-control" required type="text" name="options[` +
                count +
                `][values][0][label]" id="">
                                            </div>
                                            <div class="col-md-4 col-sm-6">
                                                <label for=""><?php echo e(translate('Additional_price')); ?></label>
                                                <input class="form-control" required type="number" min="0" step="0.01" name="options[` +
                count + `][values][0][optionPrice]" id="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-3 p-3 mr-1 d-flex "  id="add_new_button_` + count +
                `">
                                        <button type="button" class="btn btn--primary btn-outline-primary add_new_row_button" data-count="` +
                count + `"><?php echo e(translate('Add_New_Option')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>`;

            $("#add_new_option").append(add_option_view);
        }



        function add_new_row_button(data) {
            count = data;
            countRow = 1 + $('#option_price_view_' + data).children('.add_new_view_row_class').length;
            let add_new_row_view = `
            <div class="row add_new_view_row_class mb-3 position-relative pt-3 pt-sm-0">
                <div class="col-md-4 col-sm-5">
                        <label for=""><?php echo e(translate('Option_name')); ?></label>
                        <input class="form-control" required type="text" name="options[` + count + `][values][` +
                countRow + `][label]" id="">
                    </div>
                    <div class="col-md-4 col-sm-5">
                        <label for=""><?php echo e(translate('Additional_price')); ?></label>
                        <input class="form-control"  required type="number" min="0" step="0.01" name="options[` +
                count +
                `][values][` + countRow + `][optionPrice]" id="">
                    </div>
                    <div class="col-sm-2 max-sm-absolute">
                        <label class="d-none d-sm-block">&nbsp;</label>
                        <div class="mt-1">
                            <button type="button" class="btn btn-danger btn-sm deleteRow"
                                title="<?php echo e(translate('Delete')); ?>">
                                <i class="tio-add-to-trash"></i>
                            </button>
                        </div>
                </div>
            </div>`;
            $('#option_price_view_' + data).append(add_new_row_view);

        }

        function add_more_customer_choice_option(i, name) {
            let n = name;

            $('#customer_choice_options').append(
                `<div class="__choos-item"><div><input type="hidden" name="choice_no[]" value="${i}"><input type="text" class="form-control d-none" name="choice[]" value="${n}" placeholder="<?php echo e(translate('messages.choice_title')); ?>" readonly> <label class="form-label">${n}</label> </div><div><input type="text" class="form-control combination_update" name="choice_options_${i}[]" placeholder="<?php echo e(translate('messages.enter_choice_values')); ?>" data-role="tagsinput"></div></div>`
            );
            $("input[data-role=tagsinput], select[multiple][data-role=tagsinput]").tagsinput();
        }

        function combination_update() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('vendor.item.variant-combination')); ?>',
                data: $('#item_form').serialize() + '&stock=<?php echo e($module_data['stock']); ?>',
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    $('#loading').hide();
                    $('#variant_combination').html(data.view);
                    if (data.length < 1) {
                        $('input[name="current_stock"]').attr("readonly", false);
                    }
                }
            });
        }


        // $('#item_form').on('keydown', function(e) {
        //         if (e.key === 'Enter') {
        //         e.preventDefault(); // Prevent submission on Enter
        //         }
        //     });




        $('#brand_id').select2({
            ajax: {
                url: '<?php echo e(route('vendor.item.getBrandList')); ?>',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page,
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                __port: function(params, success, failure) {
                    let $request = $.ajax(params);

                    $request.then(success);
                    $request.fail(failure);

                    return $request;
                }
            }
        });



        $('#item_form').on('submit', function(e) {

            e.preventDefault();
            if(typeof FormValidation != 'undefined' && !FormValidation.validateForm(this)) {
                return false;
            }

            let formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('vendor.item.store')); ?>',
                data: $('#item_form').serialize(),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    $('#loading').hide();
                    if (data.errors) {
                        for (let i = 0; i < data.errors.length; i++) {
                            toastr.error(data.errors[i].message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        }
                    }
                    if (data.product_approval) {
                        toastr.success(data.product_approval, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function() {
                            location.href = '<?php echo e(route('vendor.item.pending_item_list')); ?>';
                        }, 2000);
                    }
                    if (data.success) {
                        toastr.success(data.success, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function() {
                            location.href = '<?php echo e(route('vendor.item.list')); ?>';
                        }, 2000);
                    }
                }
            });
        });

        function initImagePicker() {
            $("#coba").spartanMultiImagePicker({
                fieldName: 'item_images[]',
                maxCount: 5,
                rowHeight: '176px !important',
                groupClassName: 'spartan_item_wrapper min-w-176px max-w-176px',
                maxFileSize: 1024 * 1024 * 2,
                placeholderImage: {
                    image: "<?php echo e(asset('public/assets/admin/img/upload-img.png')); ?>",
                    width: '176px'
                },
                dropFileLabel: "Drop Here",
                onAddRow: function(index, file) {
                    setTimeout(function() {
                        let $newInput = $("#coba .spartan_item_wrapper").last();
                        if ($newInput.length) {
                            $newInput[0].scrollIntoView({
                                behavior: "smooth",
                                inline: "end",
                                block: "nearest"
                            });
                        }
                    }, 50);
                },
                onExtensionErr: function(index, file) {
                    toastr.error("<?php echo e(translate('messages.please_only_input_png_or_jpg_type_file')); ?>", {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function(index, file) {
                    toastr.error("<?php echo e(translate('messages.file_size_too_big')); ?>", {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        }

        $(function() {
            initImagePicker();
        });

        $('#reset_btn').click(function() {
            $('#category_id').val(null).trigger('change');
            $('#sub-categories').val(null).trigger('change');
            $('#unit').val(null).trigger('change');
            $('#veg').val(0).trigger('change');
            $('#addons').val(null).trigger('change');
            $('#discount_type').val(null).trigger('change');
            $('#choice_attributes').val(null).trigger('change');
            $('#customer_choice_options').empty().trigger('change');
            $('#variant_combination').empty().trigger('change');
            $('#viewer').attr('src', "<?php echo e(asset('public/assets/admin/img/upload.png')); ?>");
            $("#coba").empty();
            initImagePicker();
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.vendor.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\6ammart37\resources\views/vendor-views/product/index.blade.php ENDPATH**/ ?>