@extends('layouts.vendor.app')

@section('title', request()->product_gellary == 1 ? translate('Add item') : translate('Update_item'))

@push('css_or_js')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="{{ asset('public/assets/admin/css/tags-input.min.css') }}" rel="stylesheet">
    <link href="{{ asset('public/assets/admin/css/AI/animation/product/ai-sidebar.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('public/assets/admin/css/custom.css')}}">
<link rel="stylesheet" href="{{asset('public/assets/admin/css/upload-single-image.css')}}">
@endpush

@section('content')
    @php($module_type = \App\CentralLogics\Helpers::get_store_data()->module->module_type)
    @php(Config::set('module.current_module_type', $module_type))
    @php($openai_config = \App\CentralLogics\Helpers::get_business_settings('openai_config'))
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="{{ asset('public/assets/admin/img/edit.png') }}" class="w--22" alt="">
                </span>
                <span>
                    {{ request()->product_gellary == 1 ? translate('Add_item') : translate('item_update') }}
                </span>
            </h1>
        </div>

        @if (isset($temp_product) && $temp_product == 1 && $product->note)
            <div class="card-header border-0 align-items-start flex-wrap">
                <div class="order-invoice-left d-flex d-sm-block justify-content-between">
                    <div class="d-flex align-items-center __gap-5px">
                        <h1 class="page-header-title text-danger ">
                            {{ translate('messages.Rejection_Note') }} :
                        </h1>
                        <h3 class="">
                            {{ $product->note }}
                        </h3>
                    </div>
                </div>
            </div>
        @endif
        <!-- End Page Header -->
        <form id="product_form" enctype="multipart/form-data" class="validate-form" data-ajax="true">

            @if (request()->product_gellary == 1)
                @php($route = route('vendor.item.store', ['product_gellary' => request()->product_gellary]))
                @php($product->price = 0)
            @else
                @php($route = route('vendor.item.update', [isset($temp_product) && $temp_product == 1 ? $product['item_id'] : $product['id']]))
            @endif

            <input type="hidden" class="route_url"
                value="{{ $route ?? route('vendor.item.update', [isset($temp_product) && $temp_product == 1 ? $product['item_id'] : $product['id']]) }}">
            <input type="hidden" value="{{ $temp_product ?? 0 }}" name="temp_product">
            <input type="hidden" value="{{ $product['id'] ?? null }}" name="item_id">


            <input type="hidden" id="request_type" value="vendor">
            <input type="hidden" id="store_id" value="{{ \App\CentralLogics\Helpers::get_store_id() }}">
            <input type="hidden" id="module_type" value="{{ $module_type }}">



            <div class="row g-2">

                @includeif('admin-views.product.partials._title_and_discription')

                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-body d-flex flex-wrap align-items-center">
                            <div class="w-100 d-flex gap-3 flex-wrap flex-lg-nowrap">
                                <div class="flex-grow-1 mx-auto overflow-x-auto scrollbar-primary">
                                    <label class="text-dark d-block">
                                        {{ translate('messages.item_image') }}
                                        <small>( {{ translate('messages.ratio') }} 1:1 )</small>
                                    </label>
                                    <div class="d-flex __gap-12px __new-coba overflow-x-auto pb-2" id="coba">

                                        <input type="hidden" id="removedImageKeysInput" name="removedImageKeys"
                                            value="">
                                        @foreach ($product->images as $key => $photo)
                                            @php($photo = is_array($photo) ? $photo : ['img' => $photo, 'storage' => 'public'])
                                            <div id="product_images_{{ $key }}"
                                                class="spartan_item_wrapper min-w-176px max-w-176px">
                                                <img class="img--square onerror-image"
                                                    src="{{ \App\CentralLogics\Helpers::get_full_url('product', $photo['img'] ?? '', $photo['storage']) }}"
                                                    data-onerror-image="{{ asset('public/assets/admin/img/upload-img.png') }}"
                                                    alt="Product image">
                                                <a href="#" data-key={{ $key }}
                                                    data-photo="{{ $photo['img'] }}"
                                                    class="spartan_remove_row function_remove_img"><i
                                                        class="tio-add-to-trash"></i></a>

                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="flex-grow-1 mx-auto pb-2 flex-shrink-0">
                                    <label class="text-dark d-block">
                                        {{ translate('messages.item_thumbnail') }}
                                        <small class="text-danger">* ( {{ translate('messages.ratio') }} 1:1 )</small>
                                    </label>
                                    <label class="d-inline-block m-0 position-relative error-wrapper">
                                        <img class="img--176 border onerror-image" id="viewer"
                                            src="{{ $product['image_full_url'] ?? asset('public/assets/admin/img/upload-img.png') }}"
                                            data-onerror-image="{{ asset('public/assets/admin/img/upload-img.png') }}"
                                            alt="thumbnail" />
                                        <div class="icon-file-group">
                                            <div class="icon-file">
                                                <input type="file" name="image" id="customFileEg1"
                                                    class="custom-file-input read-url"
                                                    accept=".webp, .jpg, .png, .jpeg, .webp, .gif, .bmp, .tif, .tiff|image/*">
                                                <i class="tio-edit"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @includeif('admin-views.product.partials._category_and_general')
                @includeif('admin-views.product.partials._price_and_stock')



                <div class="col-lg-12" id="food_variation_section">
                    <div class="variation_wrapper">
                        <div class="outline-wrapper">
                            <div class="card shadow--card-2 border-0 bg-animate">
                                <div class="card-header flex-wrap">
                                    <h5 class="card-title">
                                        <span class="card-header-icon mr-2">
                                            <i class="tio-canvas-text"></i>
                                        </span>
                                        <span>{{ translate('messages.food_variations') }}</span>
                                    </h5>
                                    <div>

                                        <a class="btn text--primary-2" id="add_new_option_button">
                                            {{ translate('add_new_variation') }}
                                            <i class="tio-add"></i>
                                        </a>
                                        @if (isset($openai_config) && data_get($openai_config, 'status') == 1)
                                            <button type="button"
                                                class="btn bg-white text-primary opacity-1 generate_btn_wrapper p-0 mb-2 variation_setup_auto_fill"
                                                id="variation_setup_auto_fill"
                                                data-route="{{ route('admin.product.variation-setup-auto-fill') }}"
                                                data-error="{{ translate('Please provide an item name and description so the AI can generate a suitable food variations.') }}"
                                                data-lang="en">
                                                <div class="btn-svg-wrapper">
                                                    <img width="18" height="18" class=""
                                                        src="{{ asset('public/assets/admin/img/svg/blink-right-small.svg') }}"
                                                        alt="">
                                                </div>
                                                <span class="ai-text-animation d-none" role="status">
                                                    {{ translate('Just_a_second') }}
                                                </span>
                                                <span class="btn-text">{{ translate('Generate') }}</span>
                                            </button>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="add_new_option">
                                        @if (isset($product->food_variations) && count(json_decode($product->food_variations, true)) > 0)
                                            @foreach (json_decode($product->food_variations, true) as $key_choice_options => $item)
                                                @if (isset($item['price']))
                                                    @break

                                                @else
                                                    @include(
                                                        'admin-views.product.partials._new_variations',
                                                        [
                                                            'item' => $item,
                                                            'key' => $key_choice_options + 1,
                                                        ]
                                                    )
                                                @endif
                                            @endforeach
                                        @endif
                                    </div>

                                    <!-- Empty Variation -->
                                    @if (!isset($product->food_variations) || count(json_decode($product->food_variations, true)) < 1)
                                        <div id="empty-variation">
                                            <div class="text-center">
                                                <img src="{{ asset('/public/assets/admin/img/variation.png') }}"
                                                    alt="">
                                                <div>{{ translate('No variation added') }}</div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-md-12" id="attribute_section">
                    <div class="variation_wrapper">
                        <div class="outline-wrapper">
                            <div class="card shadow--card-2 border-0 bg-animate">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <span class="card-header-icon"><i class="tio-canvas-text"></i></span>
                                        <span>{{ translate('attribute') }}</span>
                                    </h5>
                                    @if (isset($openai_config) && data_get($openai_config, 'status') == 1)
                                        <button type="button"
                                            class="btn bg-white text-primary opacity-1 generate_btn_wrapper p-0 mb-2 other_variation_setup_auto_fill"
                                            id="other_variation_setup_auto_fill"
                                            data-route="{{ route('admin.product.generate-other-variation-data') }}"
                                            data-error="{{ translate('Please provide an item name and description so the AI can generate a suitable variations.') }}"
                                            data-lang="en">
                                            <div class="btn-svg-wrapper">
                                                <img width="18" height="18" class=""
                                                    src="{{ asset('public/assets/admin/img/svg/blink-right-small.svg') }}"
                                                    alt="">
                                            </div>
                                            <span class="ai-text-animation d-none" role="status">
                                                {{ translate('Just_a_second') }}
                                            </span>
                                            <span class="btn-text">{{ translate('Generate') }}</span>
                                        </button>
                                    @endif
                                </div>
                                <div class="card-body pb-0">
                                    <div class="row g-2">
                                        <div class="col-12">
                                            <div class="form-group mb-0">
                                                <label class="input-label"
                                                    for="exampleFormControlSelect1">{{ translate('messages.attribute') }}<span
                                                        class="input-label-secondary"></span></label>
                                                <select name="attribute_id[]" id="choice_attributes"
                                                    class="form-control js-select2-custom" multiple="multiple">
                                                    @foreach (\App\Models\Attribute::orderBy('name')->get() as $attribute)
                                                        <option value="{{ $attribute['id'] }}"
                                                            {{ in_array($attribute->id, json_decode($product['attributes'], true)) ? 'selected' : '' }}>
                                                            {{ $attribute['name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="customer_choice_options" id="customer_choice_options">
                                                @include('vendor-views.product.partials._choices', [
                                                    'choice_no' => json_decode($product['attributes']),
                                                    'choice_options' => json_decode(
                                                        $product['choice_options'],
                                                        true),
                                                ])
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="variant_combination" id="variant_combination">
                                                @include(
                                                    'vendor-views.product.partials._edit-combinations',
                                                    [
                                                        'combinations' => json_decode(
                                                            $product['variations'],
                                                            true),
                                                        'stock' => $module_data['stock'],
                                                    ]
                                                )
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if (Config::get('module.current_module_type') == 'ecommerce')
                    @includeIf('admin-views.business-settings.landing-page-settings.partial._meta_data', ['item' => $product])
                @endif
                </div>


                


                <div class="col-12">
                    <div class="btn--container justify-content-end">
                        <button type="reset" id="reset_btn"
                            class="btn btn--reset">{{ translate('messages.reset') }}</button>
                        <button type="submit" class="btn btn--primary">{{ translate('messages.update') }}</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <span id="message-enter-choice-values" data-text="{{ translate('enter_choice_values') }}"></span>

@endsection

@push('script')
@endpush

@push('script_2')
    <script src="{{asset('public/assets/admin/js/upload-single-image.js')}}"></script>
    <script src="{{ asset('public/assets/admin') }}/js/tags-input.min.js"></script>
    <script src="{{ asset('public/assets/admin/js/spartan-multi-image-picker.js') }}"></script>
    <script src="{{ asset('public/assets/admin') }}/js/view-pages/vendor/product-index.js"></script>

    <script src="{{ asset('public/assets/admin/js/AI/products/product-title-autofill.js') }}"></script>
    <script src="{{ asset('public/assets/admin/js/AI/products/product-description-autofill.js') }}"></script>
    <script src="{{ asset('public/assets/admin/js/AI/products/general-setup-autofill.js') }}"></script>
    <script src="{{ asset('public/assets/admin/js/AI/products/product-others-autofill.js') }}"></script>
    @if ($module_type == 'food')
        <script src="{{ asset('public/assets/admin/js/AI/products/variation-setup-auto-fill.js') }}"></script>
    @else
        <script src="{{ asset('public/assets/admin/js/AI/products/other-variation-setup-auto-fill.js') }}"></script>
    @endif
    <script src="{{ asset('public/assets/admin/js/AI/products/seo-section-autofill.js') }}"></script>

    <script src="{{ asset('public/assets/admin/js/AI/products/ai-sidebar.js') }}"></script>

    <script src="{{ asset('/public/assets/admin/js/AI/products/compressor/image-compressor.js') }}"></script>
    <script src="{{ asset('/public/assets/admin/js/AI/products/compressor/compressor.min.js') }}"></script>




    <script>
        "use strict";

        mod_type = "{{ $module_type }}";

        function add_new_option_button() {
            $('#empty-variation').hide();
            count++;
            let add_option_view = `
                            <div class="__bg-F8F9FC-card count_div view_new_option mb-2">
                                <div>
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <label class="form-check form--check">
                                            <input id="options[` + count + `][required]" name="options[` + count + `][required]" class="form-check-input" type="checkbox">
                                            <span class="form-check-label">{{ translate('Required') }}</span>
                                        </label>
                                        <div>
                                            <button type="button" class="btn btn-danger btn-sm delete_input_button"
                                                title="{{ translate('Delete') }}">
                                                <i class="tio-add-to-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="row g-2">
                                        <div class="col-xl-4 col-lg-6">
                                            <label for="">{{ translate('name') }}</label>
                                            <input required name=options[` + count +
                `][name] class="form-control new_option_name" type="text" data-count="` +
                count + `">
                                        </div>

                                        <div class="col-xl-4 col-lg-6">
                                            <div>
                                                <label class="input-label text-capitalize d-flex align-items-center"><span class="line--limit-1">{{ translate('messages.selcetion_type') }} </span>
                                                </label>
                                                <div class="resturant-type-group px-0">
                                                    <label class="form-check form--check mr-2 mr-md-4">
                                                        <input class="form-check-input show_min_max" data-count="` +
                count + `" type="radio" value="multi"
                                                        name="options[` + count + `][type]" id="type` + count +
                `" checked
                                                        >
                                                        <span class="form-check-label">
                                                            {{ translate('Multiple Selection') }}
                        </span>
                    </label>

                    <label class="form-check form--check mr-2 mr-md-4">
                        <input class="form-check-input hide_min_max" data-count="` + count + `" type="radio" value="single"
                            name="options[` + count + `][type]" id="type` + count +
                `"
                                                        >
                                                        <span class="form-check-label">
                                                            {{ translate('Single Selection') }}
                        </span>
                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6">
                            <div class="row g-2">
                                <div class="col-6">
                                    <label for="">{{ translate('Min') }}</label>
                                                    <input id="min_max1_` + count + `" required  name="options[` +
                count + `][min]" class="form-control" type="number" min="1">
                                                </div>
                                                <div class="col-6">
                                                    <label for="">{{ translate('Max') }}</label>
                                                    <input id="min_max2_` + count + `"   required name="options[` +
                count + `][max]" class="form-control" type="number" min="1">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="option_price_` + count + `" >
                                        <div class="bg-white border rounded p-3 pb-0 mt-3">
                                            <div  id="option_price_view_` + count +
                `">
                                                <div class="row g-3 add_new_view_row_class mb-3">
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="">{{ translate('Option_name') }}</label>
                                                        <input class="form-control" required type="text" name="options[` +
                count +
                `][values][0][label]" id="">
                                                    </div>
                                                    <div class="col-md-4 col-sm-6">
                                                        <label for="">{{ translate('Additional_price') }}</label>
                                                        <input class="form-control" required type="number" min="0" step="0.01" name="options[` +
                count + `][values][0][optionPrice]" id="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3 p-3 mr-1 d-flex "  id="add_new_button_` + count +
                `">
                                                <button type="button" class="btn btn--primary btn-outline-primary add_new_row_button" data-count="` +
                count + `">{{ translate('Add_New_Option') }}</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>`;

            $("#add_new_option").append(add_option_view);
        }
        $(document).ready(function() {
            $("#add_new_option_button").click(function(e) {
                add_new_option_button();
            });
        });

        function add_new_row_button(data) {
            countRow = 1 + $('#option_price_view_' + data).children('.add_new_view_row_class').length;
            let add_new_row_view = `
            <div class="row add_new_view_row_class mb-3 position-relative pt-3 pt-sm-0">
                <div class="col-md-4 col-sm-5">
                        <label for="">{{ translate('Option_name') }}</label>
                        <input class="form-control" required type="text" name="options[` + data + `][values][` +
                countRow + `][label]" id="">
                    </div>
                    <div class="col-md-4 col-sm-5">
                        <label for="">{{ translate('Additional_price') }}</label>
                        <input class="form-control"  required type="number" min="0" step="0.01" name="options[` +
                data +
                `][values][` + countRow + `][optionPrice]" id="">
                    </div>
                    <div class="col-sm-2 max-sm-absolute">
                        <label class="d-none d-sm-block">&nbsp;</label>
                        <div class="mt-1">
                            <button type="button" class="btn btn-danger btn-sm deleteRow"
                                title="{{ translate('Delete') }}">
                                <i class="tio-add-to-trash"></i>
                            </button>
                        </div>
                </div>
            </div>`;
            $('#option_price_view_' + data).append(add_new_row_view);

        }



        $(document).ready(function() {
            setTimeout(function() {
                let category = $("#category_id").val();
                let sub_category = '{{ count($product_category) >= 2 ? $product_category[1]->id : '' }}';
                let sub_sub_category = '{{ count($product_category) >= 3 ? $product_category[2]->id : '' }}';
                getRequest('{{ url('/') }}/vendor-panel/item/get-categories?parent_id=' + category +
                    '&&sub_category=' + sub_category, 'sub-categories');
                getRequest('{{ url('/') }}/vendor-panel/item/get-categories?parent_id=' +
                    sub_category + '&&sub_category=' + sub_sub_category, 'sub-sub-categories');
            }, 1000)
        });





        function add_more_customer_choice_option(i, name) {
            let n = name;

            $('#customer_choice_options').append(
                `<div class="__choos-item"><div><input type="hidden" name="choice_no[]" value="${i}"><input type="text" class="form-control d-none" name="choice[]" value="${n}" placeholder="{{ translate('messages.choice_title') }}" readonly> <label class="form-label">${n}</label> </div><div><input type="text" class="form-control combination_update" name="choice_options_${i}[]" placeholder="{{ translate('messages.enter_choice_values') }}" data-role="tagsinput"></div></div>`
            );
            $("input[data-role=tagsinput], select[multiple][data-role=tagsinput]").tagsinput();
        }



        function combination_update() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: "POST",
                url: '{{ route('vendor.item.variant-combination') }}',
                data: $('#product_form').serialize() + '&stock={{ $module_data['stock'] }}',
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    $('#loading').hide();
                    $('#variant_combination').html(data.view);
                    if (data.length < 1) {
                        $('input[name="current_stock"]').attr("readonly", false);
                        $('input[name="current_stock"]').val(0);
                    }
                    update_qty();
                }
                // success: function(data) {
                //     $('#loading').hide();
                //     $('#variant_combination').html(data.view);
                //     if (data.length > 1) {
                //         $('#quantity').hide();
                //     } else {
                //         $('#quantity').show();
                //     }
                // }
            });
        }


        $('#brand_id').select2({
            ajax: {
                 url: '{{ route('vendor.item.getBrandList') }}',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page,
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                __port: function(params, success, failure) {
                    let $request = $.ajax(params);

                    $request.then(success);
                    $request.fail(failure);

                    return $request;
                }
            }
        });



        $('#product_form').on('submit', function(e) {
            e.preventDefault();
            if(typeof FormValidation != 'undefined' && !FormValidation.validateForm(this)) {
                return false;
            }
            
            let formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: $('.route_url').val(),
                data: $('#product_form').serialize(),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    $('#loading').hide();
                    if (data.errors) {
                        for (let i = 0; i < data.errors.length; i++) {
                            toastr.error(data.errors[i].message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        }
                    }
                    if (data.product_approval) {
                        toastr.success(data.product_approval, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function() {
                            location.href = '{{ route('vendor.item.pending_item_list') }}';
                        }, 2000);
                    }
                    if (data.success) {
                        toastr.success(data.success, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        setTimeout(function() {
                            location.href = '{{ route('vendor.item.list') }}';
                        }, 2000);
                    }
                }
            });
        });

        function initImagePicker() {
            $("#coba").spartanMultiImagePicker({
                fieldName: 'item_images[]',
                maxCount: 5,
                rowHeight: '176px !important',
                groupClassName: 'spartan_item_wrapper min-w-176px max-w-176px',
                maxFileSize: 1024 * 1024 * 2,
                placeholderImage: {
                    image: "{{ asset('public/assets/admin/img/upload-img.png') }}",
                    width: '176px'
                },
                dropFileLabel: "Drop Here",
                onAddRow: function(index, file) {
                    setTimeout(function() {
                        let $newInput = $("#coba .spartan_item_wrapper").last();
                        if ($newInput.length) {
                            $newInput[0].scrollIntoView({
                                behavior: "smooth",
                                inline: "end",
                                block: "nearest"
                            });
                        }
                    }, 50);
                },
                onExtensionErr: function(index, file) {
                    toastr.error("{{ translate('messages.please_only_input_png_or_jpg_type_file') }}", {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function(index, file) {
                    toastr.error("{{ translate('messages.file_size_too_big') }}", {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        }

        $(function() {
            initImagePicker();
        });

        $(document).on('change', '.combination_update', function() {
            combination_update();
        });
        function removeOption(e) {
            element = $(e);
            element.parents('.view_new_option').remove();
            combination_update();
        }
        function deleteRow(e) {
            element = $(e);
            element.parents('.add_new_view_row_class').remove();
            combination_update();
        }

        update_qty();

        function update_qty() {
            let total_qty = 0;
            let qty_elements = $('input[name^="stock_"]');
            for (let i = 0; i < qty_elements.length; i++) {
                total_qty += parseInt(qty_elements.eq(i).val() || 0);
            }
            if (qty_elements.length > 0) {

                $('input[name="current_stock"]').attr("readonly", true);
                $('input[name="current_stock"]').val(total_qty);
            } else {
                $('input[name="current_stock"]').attr("readonly", false);
            }
        }
        
        $(document).on('keyup', 'input[name^="stock_"]', function() {
            let total_qty = 0;
            let qty_elements = $('input[name^="stock_"]');
            for (let i = 0; i < qty_elements.length; i++) {
                total_qty += parseInt(qty_elements.eq(i).val() || 0);
            }
            $('input[name="current_stock"]').val(total_qty);
        });


        // $('#product_form').on('keydown', function(e) {
        //     if (e.key === 'Enter') {
        //     e.preventDefault(); // Prevent submission on Enter
        //     }
        // });
    </script>
@endpush
